/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.plugin.video;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSAction;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.events.MediaPluginsAnalyticsFactory;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.RunningAverage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J%\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00142\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007J\u0016\u0010\u001f\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010 \u001a\u00020!J\u001c\u0010\"\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001a0$J\u001e\u0010%\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\bJ\u001c\u0010(\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0$J\u000e\u0010*\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0007J\u0014\u0010+\u001a\u00020\b2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u001a0$R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0004R*\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u000f`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0011\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00120\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0012`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0014`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0015\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00140\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0014`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0016\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0017`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0018\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00170\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0017`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Llive/hms/video/plugin/video/HMSVideoPluginAnalytics;", "", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "(Llive/hms/video/events/AnalyticsEventsService;)V", "addedTimestamps", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "getAnalyticsEventsService", "()Llive/hms/video/events/AnalyticsEventsService;", "setAnalyticsEventsService", "initTime", "peakValueWithMl", "", "peakValueWithoutMl", "pluginAdded", "", "pluginFrameRate", "", "pluginInputFrameRate", "processingAvgsWithMl", "Llive/hms/video/utils/RunningAverage;", "processingAvgsWithoutMl", "added", "", "name", "inputFrameRate", "(Ljava/lang/String;ILjava/lang/Integer;)V", "clean", "failure", "error", "Llive/hms/video/error/HMSException;", "initWithTime", "lmbd", "Lkotlin/Function0;", "processTime", "timeWithML", "timeWithoutML", "processWithTime", "processFn", "removed", "timeInMs", "Companion", "lib_release"})
public final class HMSVideoPluginAnalytics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private AnalyticsEventsService analyticsEventsService;
    @NotNull
    private HashMap<String, Long> initTime;
    @NotNull
    private HashMap<String, Long> addedTimestamps;
    @NotNull
    private HashMap<String, RunningAverage> processingAvgsWithMl;
    @NotNull
    private HashMap<String, Double> peakValueWithMl;
    @NotNull
    private HashMap<String, RunningAverage> processingAvgsWithoutMl;
    @NotNull
    private HashMap<String, Double> peakValueWithoutMl;
    @NotNull
    private HashMap<String, Boolean> pluginAdded;
    @NotNull
    private HashMap<String, Integer> pluginInputFrameRate;
    @NotNull
    private HashMap<String, Integer> pluginFrameRate;
    @NotNull
    public static final String TAG = "HMSVideoPluginAnalytics";

    public HMSVideoPluginAnalytics(@NotNull AnalyticsEventsService analyticsEventsService2) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        this.analyticsEventsService = analyticsEventsService2;
        this.initTime = new HashMap();
        this.addedTimestamps = new HashMap();
        this.processingAvgsWithMl = new HashMap();
        this.peakValueWithMl = new HashMap();
        this.processingAvgsWithoutMl = new HashMap();
        this.peakValueWithoutMl = new HashMap();
        this.pluginAdded = new HashMap();
        this.pluginInputFrameRate = new HashMap();
        this.pluginFrameRate = new HashMap();
    }

    @NotNull
    public final AnalyticsEventsService getAnalyticsEventsService() {
        return this.analyticsEventsService;
    }

    public final void setAnalyticsEventsService(@NotNull AnalyticsEventsService analyticsEventsService2) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"<set-?>");
        this.analyticsEventsService = analyticsEventsService2;
    }

    public final void added(@NotNull String name, int inputFrameRate, @Nullable Integer pluginFrameRate) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Map map2 = this.pluginAdded;
        Object object = true;
        map2.put(name, object);
        map2 = this.addedTimestamps;
        object = System.currentTimeMillis();
        map2.put(name, object);
        map2 = this.processingAvgsWithMl;
        object = new RunningAverage();
        map2.put(name, object);
        map2 = this.processingAvgsWithoutMl;
        object = new RunningAverage();
        map2.put(name, object);
        map2 = this.peakValueWithMl;
        object = 0.0;
        map2.put(name, object);
        map2 = this.peakValueWithoutMl;
        object = 0.0;
        map2.put(name, object);
        map2 = this.pluginInputFrameRate;
        object = inputFrameRate;
        map2.put(name, object);
        if (pluginFrameRate != null) {
            map2 = this.pluginFrameRate;
            map2.put(name, pluginFrameRate);
        } else {
            map2 = this.pluginFrameRate;
            object = inputFrameRate;
            map2.put(name, object);
        }
    }

    public final void removed(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.pluginAdded.containsKey(name)) {
            long l = System.currentTimeMillis();
            Long l2 = this.addedTimestamps.get(name);
            Intrinsics.checkNotNull((Object)l2);
            Long l3 = l2;
            Intrinsics.checkNotNullExpressionValue((Object)l3, (String)"addedTimestamps[name]!!");
            long duration = (l - ((Number)l3).longValue()) / (long)1000;
            Long loadTime = this.initTime.get(name);
            RunningAverage runningAverage = this.processingAvgsWithMl.get(name);
            Double avgProcessingTimeWithMl = runningAverage == null ? null : Double.valueOf(runningAverage.getAvg());
            RunningAverage runningAverage2 = this.processingAvgsWithoutMl.get(name);
            Double avgProcessingTimeWithoutMl = runningAverage2 == null ? null : Double.valueOf(runningAverage2.getAvg());
            Integer inputFrameRate = this.pluginInputFrameRate.get(name);
            Integer pluginFrameRate = this.pluginFrameRate.get(name);
            HMSLogger.INSTANCE.i(TAG, "pluginName = " + name + ", duration = " + duration + ", loadTime = " + loadTime + ", avgProcesstimeWithMl = " + avgProcessingTimeWithMl + ", avgProcesstimeWithoutMl = " + avgProcessingTimeWithoutMl + ", inputFR = " + inputFrameRate + ", pluginFr = " + pluginFrameRate);
            Long l4 = loadTime;
            Intrinsics.checkNotNull((Object)l4);
            long l5 = l4;
            Double d = avgProcessingTimeWithMl;
            Intrinsics.checkNotNull((Object)d);
            double d2 = d;
            Double d3 = avgProcessingTimeWithoutMl;
            Intrinsics.checkNotNull((Object)d3);
            double d4 = d3;
            Double d5 = this.peakValueWithMl.get(name);
            Intrinsics.checkNotNull((Object)d5);
            Double d6 = d5;
            Intrinsics.checkNotNullExpressionValue((Object)d6, (String)"this.peakValueWithMl[name]!!");
            double d7 = ((Number)d6).doubleValue();
            Double d8 = this.peakValueWithoutMl.get(name);
            Intrinsics.checkNotNull((Object)d8);
            d6 = d8;
            Intrinsics.checkNotNullExpressionValue((Object)d6, (String)"this.peakValueWithoutMl[name]!!");
            double d9 = ((Number)d6).doubleValue();
            Integer n = inputFrameRate;
            Intrinsics.checkNotNull((Object)n);
            int n2 = n;
            Integer n3 = pluginFrameRate;
            Intrinsics.checkNotNull((Object)n3);
            AnalyticsEvent event = MediaPluginsAnalyticsFactory.INSTANCE.stats(name, duration, l5, d2, d4, d7, d9, n2, n3);
            HMSLogger.INSTANCE.i(TAG, "event got = " + event + ", sending to service " + this.analyticsEventsService);
            this.analyticsEventsService.queue(event).flush();
            this.clean(name);
        }
    }

    public final void failure(@NotNull String name, @NotNull HMSException error) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        if (Intrinsics.areEqual((Object)this.pluginAdded.get(name), (Object)true)) {
            this.analyticsEventsService.queue(MediaPluginsAnalyticsFactory.INSTANCE.failure(name, error)).flush();
            this.clean(name);
        }
    }

    public final void initWithTime(@NotNull String name, @NotNull Function0<Unit> lmbd) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(lmbd, (String)"lmbd");
        if (this.initTime.containsKey(name)) {
            HMSLogger.INSTANCE.i(TAG, "Plugin Already loaded " + name + ", time it took: " + this.initTime.get(name));
            return;
        }
        Long time = null;
        try {
            time = this.timeInMs(lmbd);
            HMSLogger.INSTANCE.i(TAG, "Time taken for Plugin " + name + " initialization : " + time);
        }
        catch (HMSException e) {
            HMSException err = ErrorFactory.MediaPluginErrors.INSTANCE.InitFailed(HMSAction.VIDEO_PLUGINS, Intrinsics.stringPlus((String)"failed during initialization of plugin", (Object)e.getMessage()));
            this.failure(name, err);
            throw err;
        }
        if (((Number)time).longValue() >= 0L) {
            Map map2 = this.initTime;
            Long l = time;
            map2.put(name, l);
        }
    }

    public final void processWithTime(@NotNull String name, @NotNull Function0<Unit> processFn2) {
        RunningAverage runningAverage;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(processFn2, (String)"processFn");
        Long time = null;
        try {
            time = this.timeInMs(processFn2);
        }
        catch (HMSException e) {
            HMSException err = ErrorFactory.MediaPluginErrors.INSTANCE.ProcessingFailed(HMSAction.VIDEO_PLUGINS, Intrinsics.stringPlus((String)"Failed during processing of plugin", (Object)e.getMessage()));
            HMSLogger.e(TAG, err.toString());
            this.failure(name, err);
            throw err;
        }
        if (((Number)time).longValue() >= 0L && (runningAverage = this.processingAvgsWithMl.get(name)) != null) {
            runningAverage.add(((Number)time).longValue());
        }
    }

    public final void processTime(@NotNull String name, long timeWithML, long timeWithoutML) {
        Double d;
        Object object;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (timeWithML > 0L) {
            object = this.processingAvgsWithMl.get(name);
            if (object != null) {
                ((RunningAverage)object).add(timeWithML);
            }
            if (this.peakValueWithMl.containsKey(name)) {
                Double d2 = this.peakValueWithMl.get(name);
                Intrinsics.checkNotNull((Object)d2);
                object = d2;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.peakValueWithMl[name]!!");
                if (((Number)object).doubleValue() < (double)timeWithML) {
                    object = this.peakValueWithMl;
                    d = timeWithML;
                    object.put(name, d);
                }
            }
        }
        if (timeWithoutML > 0L) {
            object = this.processingAvgsWithoutMl.get(name);
            if (object != null) {
                ((RunningAverage)object).add(timeWithoutML);
            }
            if (this.peakValueWithoutMl.containsKey(name)) {
                Double d3 = this.peakValueWithoutMl.get(name);
                Intrinsics.checkNotNull((Object)d3);
                object = d3;
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.peakValueWithoutMl[name]!!");
                if (((Number)object).doubleValue() < (double)timeWithoutML) {
                    object = this.peakValueWithoutMl;
                    d = timeWithoutML;
                    object.put(name, d);
                }
            }
        }
    }

    public final long timeInMs(@NotNull Function0<Unit> processFn2) {
        Intrinsics.checkNotNullParameter(processFn2, (String)"processFn");
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        processFn2.invoke();
        long elapsedTime = System.currentTimeMillis() - start$iv;
        return elapsedTime;
    }

    public final void clean(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.addedTimestamps.remove(name);
        this.initTime.remove(name);
        this.processingAvgsWithMl.remove(name);
        this.peakValueWithMl.remove(name);
        this.peakValueWithoutMl.remove(name);
        this.processingAvgsWithoutMl.remove(name);
        this.pluginAdded.remove(name);
        this.pluginInputFrameRate.remove(name);
        this.pluginFrameRate.remove(name);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/video/plugin/video/HMSVideoPluginAnalytics$Companion;", "", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

