/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.settings;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.events.IAnalyticsPropertiesProvider;
import live.hms.video.media.codec.HMSAudioCodec;
import live.hms.video.media.settings.HMSTrackSettings;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB1\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u0017\u001a\u00020\u0018J$\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aj\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c`\u001dH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001f"}, d2={"Llive/hms/video/media/settings/HMSAudioTrackSettings;", "Llive/hms/video/events/IAnalyticsPropertiesProvider;", "volume", "", "maxBitrate", "", "codec", "Llive/hms/video/media/codec/HMSAudioCodec;", "useHardwareAcousticEchoCanceler", "", "initialState", "Llive/hms/video/media/settings/HMSTrackSettings$InitState;", "(DILlive/hms/video/media/codec/HMSAudioCodec;ZLlive/hms/video/media/settings/HMSTrackSettings$InitState;)V", "getCodec", "()Llive/hms/video/media/codec/HMSAudioCodec;", "getInitialState", "()Llive/hms/video/media/settings/HMSTrackSettings$InitState;", "getMaxBitrate", "()I", "getUseHardwareAcousticEchoCanceler", "()Z", "getVolume", "()D", "builder", "Llive/hms/video/media/settings/HMSAudioTrackSettings$Builder;", "toAnalyticsProperties", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "Builder", "lib_release"})
public final class HMSAudioTrackSettings
implements IAnalyticsPropertiesProvider {
    private final double volume;
    private final int maxBitrate;
    @NotNull
    private final HMSAudioCodec codec;
    private final boolean useHardwareAcousticEchoCanceler;
    @NotNull
    private final HMSTrackSettings.InitState initialState;

    private HMSAudioTrackSettings(double volume, int maxBitrate, HMSAudioCodec codec, boolean useHardwareAcousticEchoCanceler, HMSTrackSettings.InitState initialState) {
        this.volume = volume;
        this.maxBitrate = maxBitrate;
        this.codec = codec;
        this.useHardwareAcousticEchoCanceler = useHardwareAcousticEchoCanceler;
        this.initialState = initialState;
    }

    /* synthetic */ HMSAudioTrackSettings(double d, int n, HMSAudioCodec hMSAudioCodec, boolean bl, HMSTrackSettings.InitState initState, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x10) != 0) {
            initState = HMSTrackSettings.InitState.UNMUTED;
        }
        this(d, n, hMSAudioCodec, bl, initState);
    }

    public final double getVolume() {
        return this.volume;
    }

    public final int getMaxBitrate() {
        return this.maxBitrate;
    }

    @NotNull
    public final HMSAudioCodec getCodec() {
        return this.codec;
    }

    public final boolean getUseHardwareAcousticEchoCanceler() {
        return this.useHardwareAcousticEchoCanceler;
    }

    @NotNull
    public final HMSTrackSettings.InitState getInitialState() {
        return this.initialState;
    }

    @Override
    @NotNull
    public HashMap<String, Object> toAnalyticsProperties() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"audio_bitrate", (Object)this.maxBitrate), TuplesKt.to((Object)"audio_codec", (Object)((Object)this.codec))};
        return MapsKt.hashMapOf((Pair[])pairArray);
    }

    @NotNull
    public final Builder builder() {
        return new Builder().volume(this.volume).maxBitrate(this.maxBitrate).codec(this.codec).setUseHardwareAcousticEchoCanceler(this.useHardwareAcousticEchoCanceler);
    }

    public /* synthetic */ HMSAudioTrackSettings(double volume, int maxBitrate, HMSAudioCodec codec, boolean useHardwareAcousticEchoCanceler, HMSTrackSettings.InitState initialState, DefaultConstructorMarker $constructor_marker) {
        this(volume, maxBitrate, codec, useHardwareAcousticEchoCanceler, initialState);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u00020\u00002\b\b\u0001\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\u00002\b\b\u0001\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Llive/hms/video/media/settings/HMSAudioTrackSettings$Builder;", "", "()V", "codec", "Llive/hms/video/media/codec/HMSAudioCodec;", "initialState", "Llive/hms/video/media/settings/HMSTrackSettings$InitState;", "maxBitRate", "", "useHardwareAcousticEchoCanceler", "", "volume", "", "build", "Llive/hms/video/media/settings/HMSAudioTrackSettings;", "maxBitrate", "setUseHardwareAcousticEchoCanceler", "lib_release"})
    public static final class Builder {
        private double volume = 1.0;
        private int maxBitRate = 32000;
        @NotNull
        private HMSAudioCodec codec = HMSAudioCodec.OPUS;
        private boolean useHardwareAcousticEchoCanceler = true;
        @NotNull
        private HMSTrackSettings.InitState initialState = HMSTrackSettings.InitState.UNMUTED;

        @NotNull
        public final Builder volume(@FloatRange(from=0.0, to=1.0, fromInclusive=true, toInclusive=true) double volume) {
            Builder builder;
            Builder $this$volume_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$volume_u24lambda_u2d0.volume = volume;
            return builder;
        }

        @NotNull
        public final Builder maxBitrate(@IntRange(from=1L) int maxBitRate) {
            Builder builder;
            Builder $this$maxBitrate_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$maxBitrate_u24lambda_u2d1.maxBitRate = maxBitRate;
            return builder;
        }

        @NotNull
        public final Builder codec(@NotNull HMSAudioCodec codec) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)codec), (String)"codec");
            Builder $this$codec_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$codec_u24lambda_u2d2.codec = codec;
            return builder;
        }

        @NotNull
        public final Builder initialState(@NotNull HMSTrackSettings.InitState initialState) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)initialState), (String)"initialState");
            Builder $this$initialState_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$initialState_u24lambda_u2d3.initialState = initialState;
            return builder;
        }

        @NotNull
        public final Builder setUseHardwareAcousticEchoCanceler(boolean useHardwareAcousticEchoCanceler) {
            Builder builder;
            Builder $this$setUseHardwareAcousticEchoCanceler_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$setUseHardwareAcousticEchoCanceler_u24lambda_u2d4.useHardwareAcousticEchoCanceler = useHardwareAcousticEchoCanceler;
            return builder;
        }

        @NotNull
        public final HMSAudioTrackSettings build() {
            return new HMSAudioTrackSettings(this.volume, this.maxBitRate, this.codec, this.useHardwareAcousticEchoCanceler, this.initialState, null);
        }
    }
}

