/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.content.Context;
import android.graphics.Point;
import android.view.WindowManager;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import live.hms.video.error.HMSException;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0017\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0004J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004J\u0012\u0010\u0019\u001a\u00020\u00162\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001cR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Llive/hms/video/utils/HMSUtils;", "", "()V", "MAX_SCREENSHARE_SIZE", "", "TAG", "", "addAndConvertBuffers", "", "a1", "", "a1Limit", "a2", "a2Limit", "applySizeConstraint", "Landroid/graphics/Point;", "actualSize", "getDeviceWidthAndHeight", "context", "Landroid/content/Context;", "getOrientation", "hasOrientationChange", "", "currentOrientation", "oldOrientation", "shouldRetry", "ex", "Ljava/lang/Exception;", "Lkotlin/Exception;", "lib_release"})
public final class HMSUtils {
    @NotNull
    public static final HMSUtils INSTANCE = new HMSUtils();
    @NotNull
    private static final String TAG = "HMSUtils";
    private static final int MAX_SCREENSHARE_SIZE = 1920;

    private HMSUtils() {
    }

    public final int getOrientation(@NotNull Context context) {
        int n;
        Integer n2;
        WindowManager windowManager;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = context.getSystemService("window");
        WindowManager windowManager2 = windowManager = object instanceof WindowManager ? (WindowManager)object : null;
        Integer n3 = n2 = windowManager == null ? null : ((object = windowManager.getDefaultDisplay()) == null ? null : Integer.valueOf(object.getRotation()));
        int n4 = 1;
        if (n3 != null && n3 == n4) {
            n = 90;
        } else {
            Integer n5 = n2;
            n4 = 2;
            if (n5 != null && n5 == n4) {
                n = 180;
            } else {
                Integer n6 = n2;
                n4 = 3;
                n = n6 != null && n6 == n4 ? 270 : 0;
            }
        }
        return n;
    }

    public final boolean hasOrientationChange(int currentOrientation, int oldOrientation) {
        int n;
        return currentOrientation != oldOrientation && Math.abs(n = currentOrientation - oldOrientation) != 180;
    }

    public final boolean shouldRetry(@NotNull Exception ex) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        return ex instanceof HMSException ? ArraysKt.contains((Object[])(objectArray = new Integer[]{2003, 1003}), (Object)((HMSException)ex).getCode()) || StringsKt.startsWith$default((String)String.valueOf(((HMSException)ex).getCode()), (String)"5", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)String.valueOf(((HMSException)ex).getCode()), (String)"429", (boolean)false, (int)2, null) : false;
    }

    @NotNull
    public final byte[] addAndConvertBuffers(@NotNull short[] a1, int a1Limit, @NotNull short[] a2, int a2Limit) {
        Intrinsics.checkNotNullParameter((Object)a1, (String)"a1");
        Intrinsics.checkNotNullParameter((Object)a2, (String)"a2");
        int size = Math.max(a1Limit, a2Limit);
        if (size < 0) {
            return new byte[0];
        }
        byte[] buff = new byte[size * 2];
        int n = 0;
        if (n < size) {
            do {
                int i = n++;
                int sum = 0;
                int n2 = i >= a1Limit ? a2[i] : (sum = i >= a2Limit ? a1[i] : a1[i] + a2[i]);
                if (sum > Short.MAX_VALUE) {
                    sum = Short.MAX_VALUE;
                }
                if (sum < Short.MIN_VALUE) {
                    sum = Short.MIN_VALUE;
                }
                int byteIndex = i * 2;
                buff[byteIndex] = (byte)(sum & 0xFF);
                buff[byteIndex + 1] = (byte)(sum >> 8 & 0xFF);
            } while (n < size);
        }
        return buff;
    }

    @NotNull
    public final Point getDeviceWidthAndHeight(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Point size = new Point();
        Object object = context.getSystemService("window");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.view.WindowManager");
        }
        WindowManager wm = (WindowManager)object;
        Object $this$getDeviceWidthAndHeight_u24lambda_u2d0 = object = wm.getDefaultDisplay();
        boolean bl = false;
        $this$getDeviceWidthAndHeight_u24lambda_u2d0.getRealSize(size);
        return size;
    }

    @NotNull
    public final Point applySizeConstraint(@NotNull Point actualSize) {
        Intrinsics.checkNotNullParameter((Object)actualSize, (String)"actualSize");
        int width = actualSize.x;
        int height = actualSize.y;
        int maxSize = Math.max(width, height);
        if (maxSize > 1920) {
            float ratio = (float)width / (float)height;
            if (width == maxSize) {
                width = 1920;
                height = (int)(1.0f / ratio * (float)1920);
            } else {
                height = 1920;
                width = (int)((float)1920 * ratio);
            }
            return new Point(width, height);
        }
        return actualSize;
    }
}

