/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk.models;

import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.sdk.models.EVENT_TYPE;
import live.hms.video.sdk.models.IRetryAttemptTracking;
import live.hms.video.utils.HMSCoroutineScope;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0015\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0015\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b\u0015J\u001b\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u000bH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0018\u0010\u0019J!\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\tH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001cJ\u0015\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u001eJ\r\u0010\u001f\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006!"}, d2={"Llive/hms/video/sdk/models/PerformanceMeasurement;", "Ljava/io/Closeable;", "Llive/hms/video/sdk/models/IRetryAttemptTracking;", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "(Llive/hms/video/events/AnalyticsEventsService;)V", "eventMap", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "isPreviewCalled", "", "previewStartTime", "close", "", "end", "eventType", "Llive/hms/video/sdk/models/EVENT_TYPE;", "end$lib_release", "firePreviewPerformanceMeasurementEvent", "eventSuccessful", "firePreviewPerformanceMeasurementEvent$lib_release", "flushJoin", "success", "flushJoin$lib_release", "(ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "numberedValue", "times", "(Llive/hms/video/sdk/models/EVENT_TYPE;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "start", "start$lib_release", "startPreview", "startPreview$lib_release", "lib_release"})
public final class PerformanceMeasurement
implements Closeable,
IRetryAttemptTracking {
    @NotNull
    private AnalyticsEventsService analyticsEventsService;
    @NotNull
    private final ConcurrentHashMap<String, Long> eventMap;
    private long previewStartTime;
    private boolean isPreviewCalled;

    public PerformanceMeasurement(@NotNull AnalyticsEventsService analyticsEventsService2) {
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService2, (String)"analyticsEventsService");
        this.analyticsEventsService = analyticsEventsService2;
        this.eventMap = new ConcurrentHashMap();
    }

    public final void start$lib_release(@NotNull EVENT_TYPE eventType) {
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
        String eventName = eventType.getValue();
        Map map2 = this.eventMap;
        Long l = System.currentTimeMillis();
        map2.put(eventName, l);
    }

    @NotNull
    public final PerformanceMeasurement end$lib_release(@NotNull EVENT_TYPE eventType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)eventType), (String)"eventType");
        String eventName = eventType.getValue();
        long endTime = System.currentTimeMillis();
        try {
            object = this.eventMap.get(eventName);
        }
        catch (NullPointerException ex) {
            object = null;
        }
        Long existingEvent = object;
        if (existingEvent != null && existingEvent - (long)1000000000 > 0L) {
            object = this.eventMap;
            Long l = endTime - existingEvent;
            object.put(eventName, l);
        } else {
            HMSLogger.e("PerformanceJoinEvents", Intrinsics.stringPlus((String)"Error recording ending ", (Object)((Object)eventType)));
        }
        return this;
    }

    @Override
    @Nullable
    public Object numberedValue(@NotNull EVENT_TYPE eventType, long times, @NotNull Continuation<? super Unit> $completion) {
        Map map2 = this.eventMap;
        String string = eventType.getValue();
        Long l = Boxing.boxLong((long)times);
        Long l2 = map2.put(string, l);
        if (l2 == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return l2;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object flushJoin$lib_release(boolean success, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)HMSCoroutineScope.INSTANCE.getCoroutineContext(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, success, null){
            int label;
            final /* synthetic */ PerformanceMeasurement this$0;
            final /* synthetic */ boolean $success;
            {
                this.this$0 = $receiver;
                this.$success = $success;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Long l;
                        ResultKt.throwOnFailure((Object)object);
                        EVENT_TYPE eventType = EVENT_TYPE.JOIN_CALL;
                        String joinProperties = "time";
                        try {
                            l = (Long)PerformanceMeasurement.access$getEventMap$p(this.this$0).remove(eventType.getValue());
                        }
                        catch (NullPointerException nullPointerException) {
                            l = null;
                        }
                        Long performanceEvent = l;
                        boolean wasPreviewCalled = PerformanceMeasurement.access$isPreviewCalled$p(this.this$0);
                        if (performanceEvent != null) {
                            HashMap properties = (HashMap)MapsKt.toMap((Map)PerformanceMeasurement.access$getEventMap$p(this.this$0), (Map)new HashMap<K, V>());
                            Map map2 = properties;
                            String string = String.valueOf(performanceEvent);
                            map2.put(joinProperties, string);
                            map2 = properties;
                            string = "is_preview_called";
                            Boolean bl = Boxing.boxBoolean((wasPreviewCalled ? 1 : 0) != 0);
                            map2.put(string, bl);
                            HMSLogger.d("PerformanceJoinEvents", "Sending event: " + performanceEvent + ' ' + properties);
                            PerformanceMeasurement.access$getAnalyticsEventsService$p(this.this$0).queue(AnalyticsEventFactory.INSTANCE.joinStatusEvent(this.$success, properties)).flush();
                        } else {
                            HMSLogger.e("PerformanceJoinEvents", "Throwing away a flush since the measurement was wrong by not having a time at all");
                        }
                        PerformanceMeasurement.access$getEventMap$p(this.this$0).clear();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    public final void startPreview$lib_release() {
        this.previewStartTime = System.currentTimeMillis();
        this.isPreviewCalled = true;
    }

    public final void firePreviewPerformanceMeasurementEvent$lib_release(boolean eventSuccessful) {
        String previewResultTimeProp = "time";
        Map map2 = this.eventMap;
        Long l = System.currentTimeMillis() - this.previewStartTime;
        map2.put(previewResultTimeProp, l);
        AnalyticsEvent event = AnalyticsEventFactory.INSTANCE.previewStatusEvent(eventSuccessful, (HashMap)MapsKt.toMap((Map)this.eventMap, (Map)new HashMap()));
        this.analyticsEventsService.queue(event).flush();
        HMSLogger.d("PerformanceJoinEvents", Intrinsics.stringPlus((String)"Fire preview measurement: ", (Object)event));
    }

    @Override
    public void close() {
        this.isPreviewCalled = false;
        this.eventMap.clear();
    }

    public static final /* synthetic */ ConcurrentHashMap access$getEventMap$p(PerformanceMeasurement $this) {
        return $this.eventMap;
    }

    public static final /* synthetic */ boolean access$isPreviewCalled$p(PerformanceMeasurement $this) {
        return $this.isPreviewCalled;
    }

    public static final /* synthetic */ AnalyticsEventsService access$getAnalyticsEventsService$p(PerformanceMeasurement $this) {
        return $this.analyticsEventsService;
    }
}

