/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.connection;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import live.hms.video.connection.HMSDataChannel;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.DataChannel;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0002\u0019\u001aB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0013\u001a\u00020\u0014J\u0019\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0007H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0017J\b\u0010\u0018\u001a\u00020\u0007H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Llive/hms/video/connection/HMSDataChannel;", "", "nativeChannel", "Lorg/webrtc/DataChannel;", "observer", "Llive/hms/video/connection/HMSDataChannel$Observer;", "metadata", "", "(Lorg/webrtc/DataChannel;Llive/hms/video/connection/HMSDataChannel$Observer;Ljava/lang/String;)V", "channelOpenDeferred", "Lkotlinx/coroutines/CompletableDeferred;", "", "id", "", "getId", "()I", "label", "getLabel", "()Ljava/lang/String;", "close", "", "send", "message", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toString", "Companion", "Observer", "lib_release"})
public final class HMSDataChannel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataChannel nativeChannel;
    @NotNull
    private final Observer observer;
    @NotNull
    private final String metadata;
    @NotNull
    private final CompletableDeferred<Boolean> channelOpenDeferred;
    @NotNull
    private final String label;
    private final int id;
    @NotNull
    private static final String TAG = "HMSDataChannel";

    public HMSDataChannel(@NotNull DataChannel nativeChannel, @NotNull Observer observer, @NotNull String metadata) {
        Intrinsics.checkNotNullParameter((Object)nativeChannel, (String)"nativeChannel");
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        this.nativeChannel = nativeChannel;
        this.observer = observer;
        this.metadata = metadata;
        this.channelOpenDeferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        String string = this.nativeChannel.label();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nativeChannel.label()");
        this.label = string;
        this.id = this.nativeChannel.id();
        HMSLogger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"Created data channel ", (Object)this));
        if (this.nativeChannel.state() == DataChannel.State.OPEN) {
            this.channelOpenDeferred.complete((Object)true);
        }
        this.nativeChannel.registerObserver(new DataChannel.Observer(){

            public void onBufferedAmountChange(long previousAmount) {
                HMSLogger.d(HMSDataChannel.TAG, '[' + metadata + "] onBufferedAmountChange: previousAmount=" + previousAmount);
            }

            public void onStateChange() {
                DataChannel.State state2 = nativeChannel.state();
                HMSLogger.d(HMSDataChannel.TAG, '[' + metadata + "] onStateChanged: state=" + state2);
                if (state2 == DataChannel.State.OPEN) {
                    channelOpenDeferred.complete((Object)true);
                }
            }

            public void onMessage(@NotNull DataChannel.Buffer buffer) {
                Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                String string = StandardCharsets.UTF_8.decode(buffer.data).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"UTF_8.decode(buffer.data).toString()");
                String message = string;
                HMSLogger.d(HMSDataChannel.TAG, '[' + metadata + "] onMessage: label=" + this.getLabel() + ", [size=" + message.length() + "] message=" + message);
                observer.onMessage(message);
            }
        });
    }

    public /* synthetic */ HMSDataChannel(DataChannel dataChannel, Observer observer, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "";
        }
        this(dataChannel, observer, string);
    }

    @NotNull
    public final String getLabel() {
        return this.label;
    }

    public final int getId() {
        return this.id;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object send(@NotNull String var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof send.1)) ** GOTO lbl-1000
        var8_3 = var2_2;
        if ((var8_3.label & -2147483648) != 0) {
            var8_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ HMSDataChannel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.send(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!this.channelOpenDeferred.isCompleted()) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = message;
                    $continuation.label = 1;
                    v0 = this.channelOpenDeferred.await((Continuation)$continuation);
                    if (v0 == var9_5) {
                        return var9_5;
                    }
                }
                ** GOTO lbl25
            }
            case 1: {
                message = (String)$continuation.L$1;
                this = (HMSDataChannel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                var4_6 = message;
                var5_7 = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)var5_7, (String)"forName(\"UTF-8\")");
                var6_8 = var4_6.getBytes(var5_7);
                Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"this as java.lang.String).getBytes(charset)");
                buffer = ByteBuffer.wrap(var6_8);
                HMSLogger.d("HMSDataChannel", '[' + this.metadata + "] Sending [size=" + message.length() + "] message=" + message);
                this.nativeChannel.send(new DataChannel.Buffer(buffer, false));
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final void close() {
        HMSLogger.d(TAG, "Closing " + this + " START");
        try {
            this.nativeChannel.unregisterObserver();
            this.nativeChannel.close();
        }
        catch (IllegalStateException ex) {
            HMSLogger.INSTANCE.w(TAG, '[' + this.metadata + "] Could not close " + this + " cleanly", ex);
        }
        HMSLogger.d(TAG, "Closing " + this + " DONE");
    }

    @NotNull
    public String toString() {
        return "HMSDataChannel{id=" + this.id + ", label=" + this.label + ", metadata=[" + this.metadata + "]}";
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/video/connection/HMSDataChannel$Companion;", "", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Llive/hms/video/connection/HMSDataChannel$Observer;", "", "onMessage", "", "value", "", "lib_release"})
    public static interface Observer {
        public void onMessage(@NotNull String var1);
    }
}

