/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.sdk.models;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.sdk.models.HMSHLSVariant;
import live.hms.video.sdk.models.HMSSpeakerServerResponse;
import live.hms.video.sdk.models.RecordingType;
import live.hms.video.sdk.models.TrackForLayerUpdate;
import live.hms.video.sdk.models.role.HMSRole;
import live.hms.video.sdk.peerlist.models.Recording;
import live.hms.video.utils.GsonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u00062\u00020\u0001:\u001f\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001d\u001e\u001f !B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0016\"#$%&'()*+,-./01234567\u00a8\u00068"}, d2={"Llive/hms/video/sdk/models/HMSNotifications;", "", "()V", "BroadcastInfo", "BroadcastPeer", "ChangeTrackMuteRequest", "Companion", "HLSStateChangeNotification", "Hls", "HlsStartRecording", "InitialRoom", "OnBroadcast", "OnRoleChangeRequest", "OnTrackLayerUpdate", "Peer", "PeerInfo", "PeerJoin", "PeerLeave", "PeerList", "PeerNetworkInfoList", "PeerRemoved", "PolicyChange", "RecordingStateChangeNotification", "RoleChange", "Rtmp", "RtmpUpdatedNotification", "ServerError", "SpeakerList", "Streaming", "Track", "TrackMetadata", "TrackMetadataPeer", "TrackUpdateRequest", "Unsupported", "Llive/hms/video/sdk/models/HMSNotifications$Peer;", "Llive/hms/video/sdk/models/HMSNotifications$PeerJoin;", "Llive/hms/video/sdk/models/HMSNotifications$PeerLeave;", "Llive/hms/video/sdk/models/HMSNotifications$Track;", "Llive/hms/video/sdk/models/HMSNotifications$PeerNetworkInfoList;", "Llive/hms/video/sdk/models/HMSNotifications$PeerList;", "Llive/hms/video/sdk/models/HMSNotifications$TrackMetadataPeer;", "Llive/hms/video/sdk/models/HMSNotifications$TrackMetadata;", "Llive/hms/video/sdk/models/HMSNotifications$RoleChange;", "Llive/hms/video/sdk/models/HMSNotifications$PolicyChange;", "Llive/hms/video/sdk/models/HMSNotifications$SpeakerList;", "Llive/hms/video/sdk/models/HMSNotifications$BroadcastPeer;", "Llive/hms/video/sdk/models/HMSNotifications$OnBroadcast;", "Llive/hms/video/sdk/models/HMSNotifications$OnRoleChangeRequest;", "Llive/hms/video/sdk/models/HMSNotifications$Unsupported;", "Llive/hms/video/sdk/models/HMSNotifications$PeerRemoved;", "Llive/hms/video/sdk/models/HMSNotifications$TrackUpdateRequest;", "Llive/hms/video/sdk/models/HMSNotifications$ChangeTrackMuteRequest;", "Llive/hms/video/sdk/models/HMSNotifications$RecordingStateChangeNotification;", "Llive/hms/video/sdk/models/HMSNotifications$RtmpUpdatedNotification;", "Llive/hms/video/sdk/models/HMSNotifications$HLSStateChangeNotification;", "Llive/hms/video/sdk/models/HMSNotifications$OnTrackLayerUpdate;", "lib_release"})
public abstract class HMSNotifications {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private HMSNotifications() {
    }

    public /* synthetic */ HMSNotifications(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0014\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t\u0018\u00010\b\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0006H\u00c6\u0003J\u0017\u0010\u001e\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u00c6\u0003J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0003JP\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u0016\b\u0002\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t\u0018\u00010\b2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000bH\u00c6\u0001\u00a2\u0006\u0002\u0010$J\u0013\u0010%\u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010'H\u00d6\u0003J\t\u0010(\u001a\u00020\u000bH\u00d6\u0001J\u0006\u0010)\u001a\u00020*J\u0006\u0010+\u001a\u00020,J\t\u0010-\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0017\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R$\u0010\u0007\u001a\u0010\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006."}, d2={"Llive/hms/video/sdk/models/HMSNotifications$Peer;", "Llive/hms/video/sdk/models/HMSNotifications;", "peerId", "", "role", "info", "Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;", "tracksMap", "Ljava/util/HashMap;", "Llive/hms/video/sdk/models/HMSNotifications$Track;", "downlinkScore", "", "(Ljava/lang/String;Ljava/lang/String;Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;Ljava/util/HashMap;Ljava/lang/Integer;)V", "getDownlinkScore", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getInfo", "()Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;", "getPeerId", "()Ljava/lang/String;", "getRole", "tracks", "", "getTracks", "()[Llive/hms/video/sdk/models/HMSNotifications$Track;", "getTracksMap", "()Ljava/util/HashMap;", "component1", "component2", "component3", "component4", "component5", "containsTrack", "", "trackId", "copy", "(Ljava/lang/String;Ljava/lang/String;Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;Ljava/util/HashMap;Ljava/lang/Integer;)Llive/hms/video/sdk/models/HMSNotifications$Peer;", "equals", "other", "", "hashCode", "toPeerJoin", "Llive/hms/video/sdk/models/HMSNotifications$PeerJoin;", "toPeerLeave", "Llive/hms/video/sdk/models/HMSNotifications$PeerLeave;", "toString", "lib_release"})
    public static final class Peer
    extends HMSNotifications {
        @SerializedName(value="peer_id")
        @NotNull
        private final String peerId;
        @SerializedName(value="role")
        @NotNull
        private final String role;
        @SerializedName(value="info")
        @NotNull
        private final PeerInfo info;
        @SerializedName(value="tracks")
        @Nullable
        private final HashMap<String, Track> tracksMap;
        @SerializedName(value="downlink_score")
        @Nullable
        private final Integer downlinkScore;

        public Peer(@NotNull String peerId, @NotNull String role, @NotNull PeerInfo info, @Nullable HashMap<String, Track> tracksMap, @Nullable Integer downlinkScore) {
            Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            super(null);
            this.peerId = peerId;
            this.role = role;
            this.info = info;
            this.tracksMap = tracksMap;
            this.downlinkScore = downlinkScore;
        }

        @NotNull
        public final String getPeerId() {
            return this.peerId;
        }

        @NotNull
        public final String getRole() {
            return this.role;
        }

        @NotNull
        public final PeerInfo getInfo() {
            return this.info;
        }

        @Nullable
        public final HashMap<String, Track> getTracksMap() {
            return this.tracksMap;
        }

        @Nullable
        public final Integer getDownlinkScore() {
            return this.downlinkScore;
        }

        @NotNull
        public final Track[] getTracks() {
            Track[] trackArray;
            HashMap<String, Track> hashMap = this.tracksMap;
            if (hashMap == null) {
                trackArray = null;
            } else {
                Collection<Track> collection = hashMap.values();
                if (collection == null) {
                    trackArray = null;
                } else {
                    Collection<Track> $this$toTypedArray$iv = collection;
                    boolean $i$f$toTypedArray = false;
                    Collection<Track> thisCollection$iv = $this$toTypedArray$iv;
                    Track[] trackArray2 = thisCollection$iv.toArray(new Track[0]);
                    if (trackArray2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    trackArray = trackArray2;
                }
            }
            Track[] trackArray3 = trackArray;
            return trackArray3 == null ? new Track[]{} : trackArray3;
        }

        public final boolean containsTrack(@NotNull String trackId) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
            HashMap<String, Track> hashMap = this.tracksMap;
            return hashMap == null ? false : (bl = hashMap.containsKey(trackId));
        }

        @NotNull
        public final PeerJoin toPeerJoin() {
            return new PeerJoin(this.peerId, this.role, this.info);
        }

        @NotNull
        public final PeerLeave toPeerLeave() {
            return new PeerLeave(this.peerId, this.role, this.info);
        }

        @NotNull
        public final String component1() {
            return this.peerId;
        }

        @NotNull
        public final String component2() {
            return this.role;
        }

        @NotNull
        public final PeerInfo component3() {
            return this.info;
        }

        @Nullable
        public final HashMap<String, Track> component4() {
            return this.tracksMap;
        }

        @Nullable
        public final Integer component5() {
            return this.downlinkScore;
        }

        @NotNull
        public final Peer copy(@NotNull String peerId, @NotNull String role, @NotNull PeerInfo info, @Nullable HashMap<String, Track> tracksMap, @Nullable Integer downlinkScore) {
            Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return new Peer(peerId, role, info, tracksMap, downlinkScore);
        }

        public static /* synthetic */ Peer copy$default(Peer peer, String string, String string2, PeerInfo peerInfo, HashMap hashMap, Integer n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = peer.peerId;
            }
            if ((n2 & 2) != 0) {
                string2 = peer.role;
            }
            if ((n2 & 4) != 0) {
                peerInfo = peer.info;
            }
            if ((n2 & 8) != 0) {
                hashMap = peer.tracksMap;
            }
            if ((n2 & 0x10) != 0) {
                n = peer.downlinkScore;
            }
            return peer.copy(string, string2, peerInfo, hashMap, n);
        }

        @NotNull
        public String toString() {
            return "Peer(peerId=" + this.peerId + ", role=" + this.role + ", info=" + this.info + ", tracksMap=" + this.tracksMap + ", downlinkScore=" + this.downlinkScore + ')';
        }

        public int hashCode() {
            int result2 = this.peerId.hashCode();
            result2 = result2 * 31 + this.role.hashCode();
            result2 = result2 * 31 + this.info.hashCode();
            result2 = result2 * 31 + (this.tracksMap == null ? 0 : this.tracksMap.hashCode());
            result2 = result2 * 31 + (this.downlinkScore == null ? 0 : ((Object)this.downlinkScore).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Peer)) {
                return false;
            }
            Peer peer = (Peer)other;
            if (!Intrinsics.areEqual((Object)this.peerId, (Object)peer.peerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.role, (Object)peer.role)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.info, (Object)peer.info)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.tracksMap, peer.tracksMap)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.downlinkScore, (Object)peer.downlinkScore);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$PeerJoin;", "Llive/hms/video/sdk/models/HMSNotifications;", "peerId", "", "role", "info", "Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;", "(Ljava/lang/String;Ljava/lang/String;Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;)V", "getInfo", "()Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;", "getPeerId", "()Ljava/lang/String;", "getRole", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "lib_release"})
    public static final class PeerJoin
    extends HMSNotifications {
        @SerializedName(value="peer_id")
        @NotNull
        private final String peerId;
        @SerializedName(value="role")
        @NotNull
        private final String role;
        @SerializedName(value="info")
        @NotNull
        private final PeerInfo info;

        public PeerJoin(@NotNull String peerId, @NotNull String role, @NotNull PeerInfo info) {
            Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            super(null);
            this.peerId = peerId;
            this.role = role;
            this.info = info;
        }

        @NotNull
        public final String getPeerId() {
            return this.peerId;
        }

        @NotNull
        public final String getRole() {
            return this.role;
        }

        @NotNull
        public final PeerInfo getInfo() {
            return this.info;
        }

        @NotNull
        public final String component1() {
            return this.peerId;
        }

        @NotNull
        public final String component2() {
            return this.role;
        }

        @NotNull
        public final PeerInfo component3() {
            return this.info;
        }

        @NotNull
        public final PeerJoin copy(@NotNull String peerId, @NotNull String role, @NotNull PeerInfo info) {
            Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return new PeerJoin(peerId, role, info);
        }

        public static /* synthetic */ PeerJoin copy$default(PeerJoin peerJoin, String string, String string2, PeerInfo peerInfo, int n, Object object) {
            if ((n & 1) != 0) {
                string = peerJoin.peerId;
            }
            if ((n & 2) != 0) {
                string2 = peerJoin.role;
            }
            if ((n & 4) != 0) {
                peerInfo = peerJoin.info;
            }
            return peerJoin.copy(string, string2, peerInfo);
        }

        @NotNull
        public String toString() {
            return "PeerJoin(peerId=" + this.peerId + ", role=" + this.role + ", info=" + this.info + ')';
        }

        public int hashCode() {
            int result2 = this.peerId.hashCode();
            result2 = result2 * 31 + this.role.hashCode();
            result2 = result2 * 31 + this.info.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PeerJoin)) {
                return false;
            }
            PeerJoin peerJoin = (PeerJoin)other;
            if (!Intrinsics.areEqual((Object)this.peerId, (Object)peerJoin.peerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.role, (Object)peerJoin.role)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.info, (Object)peerJoin.info);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0006H\u00c6\u0003J'\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$PeerLeave;", "Llive/hms/video/sdk/models/HMSNotifications;", "peerId", "", "role", "info", "Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;", "(Ljava/lang/String;Ljava/lang/String;Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;)V", "getInfo", "()Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;", "getPeerId", "()Ljava/lang/String;", "getRole", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "lib_release"})
    public static final class PeerLeave
    extends HMSNotifications {
        @SerializedName(value="peer_id")
        @NotNull
        private final String peerId;
        @SerializedName(value="role")
        @NotNull
        private final String role;
        @SerializedName(value="info")
        @NotNull
        private final PeerInfo info;

        public PeerLeave(@NotNull String peerId, @NotNull String role, @NotNull PeerInfo info) {
            Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            super(null);
            this.peerId = peerId;
            this.role = role;
            this.info = info;
        }

        @NotNull
        public final String getPeerId() {
            return this.peerId;
        }

        @NotNull
        public final String getRole() {
            return this.role;
        }

        @NotNull
        public final PeerInfo getInfo() {
            return this.info;
        }

        @NotNull
        public final String component1() {
            return this.peerId;
        }

        @NotNull
        public final String component2() {
            return this.role;
        }

        @NotNull
        public final PeerInfo component3() {
            return this.info;
        }

        @NotNull
        public final PeerLeave copy(@NotNull String peerId, @NotNull String role, @NotNull PeerInfo info) {
            Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return new PeerLeave(peerId, role, info);
        }

        public static /* synthetic */ PeerLeave copy$default(PeerLeave peerLeave, String string, String string2, PeerInfo peerInfo, int n, Object object) {
            if ((n & 1) != 0) {
                string = peerLeave.peerId;
            }
            if ((n & 2) != 0) {
                string2 = peerLeave.role;
            }
            if ((n & 4) != 0) {
                peerInfo = peerLeave.info;
            }
            return peerLeave.copy(string, string2, peerInfo);
        }

        @NotNull
        public String toString() {
            return "PeerLeave(peerId=" + this.peerId + ", role=" + this.role + ", info=" + this.info + ')';
        }

        public int hashCode() {
            int result2 = this.peerId.hashCode();
            result2 = result2 * 31 + this.role.hashCode();
            result2 = result2 * 31 + this.info.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PeerLeave)) {
                return false;
            }
            PeerLeave peerLeave = (PeerLeave)other;
            if (!Intrinsics.areEqual((Object)this.peerId, (Object)peerLeave.peerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.role, (Object)peerLeave.role)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.info, (Object)peerLeave.info);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u0012\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003JE\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u00032\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0005H\u00d6\u0001R\u0016\u0010\u0007\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\rR\u0016\u0010\u0006\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0016\u0010\t\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR\u0016\u0010\b\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006 "}, d2={"Llive/hms/video/sdk/models/HMSNotifications$Track;", "Llive/hms/video/sdk/models/HMSNotifications;", "isMute", "", "type", "", "source", "description", "trackId", "streamId", "(ZLjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "()Z", "getSource", "getStreamId", "getTrackId", "getType", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "lib_release"})
    public static final class Track
    extends HMSNotifications {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @SerializedName(value="mute")
        private final boolean isMute;
        @SerializedName(value="type")
        @NotNull
        private final String type;
        @SerializedName(value="source")
        @NotNull
        private final String source;
        @SerializedName(value="description")
        @NotNull
        private final String description;
        @SerializedName(value="track_id")
        @NotNull
        private final String trackId;
        @SerializedName(value="stream_id")
        @NotNull
        private final String streamId;

        public Track(boolean isMute, @NotNull String type, @NotNull String source, @NotNull String description, @NotNull String trackId, @NotNull String streamId) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
            Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
            super(null);
            this.isMute = isMute;
            this.type = type;
            this.source = source;
            this.description = description;
            this.trackId = trackId;
            this.streamId = streamId;
        }

        public final boolean isMute() {
            return this.isMute;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getSource() {
            return this.source;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        @NotNull
        public final String getTrackId() {
            return this.trackId;
        }

        @NotNull
        public final String getStreamId() {
            return this.streamId;
        }

        public final boolean component1() {
            return this.isMute;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final String component3() {
            return this.source;
        }

        @NotNull
        public final String component4() {
            return this.description;
        }

        @NotNull
        public final String component5() {
            return this.trackId;
        }

        @NotNull
        public final String component6() {
            return this.streamId;
        }

        @NotNull
        public final Track copy(boolean isMute, @NotNull String type, @NotNull String source, @NotNull String description, @NotNull String trackId, @NotNull String streamId) {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            Intrinsics.checkNotNullParameter((Object)description, (String)"description");
            Intrinsics.checkNotNullParameter((Object)trackId, (String)"trackId");
            Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
            return new Track(isMute, type, source, description, trackId, streamId);
        }

        public static /* synthetic */ Track copy$default(Track track, boolean bl, String string, String string2, String string3, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                bl = track.isMute;
            }
            if ((n & 2) != 0) {
                string = track.type;
            }
            if ((n & 4) != 0) {
                string2 = track.source;
            }
            if ((n & 8) != 0) {
                string3 = track.description;
            }
            if ((n & 0x10) != 0) {
                string4 = track.trackId;
            }
            if ((n & 0x20) != 0) {
                string5 = track.streamId;
            }
            return track.copy(bl, string, string2, string3, string4, string5);
        }

        @NotNull
        public String toString() {
            return "Track(isMute=" + this.isMute + ", type=" + this.type + ", source=" + this.source + ", description=" + this.description + ", trackId=" + this.trackId + ", streamId=" + this.streamId + ')';
        }

        public int hashCode() {
            int n = this.isMute ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result2 = n;
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + this.source.hashCode();
            result2 = result2 * 31 + this.description.hashCode();
            result2 = result2 * 31 + this.trackId.hashCode();
            result2 = result2 * 31 + this.streamId.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Track)) {
                return false;
            }
            Track track = (Track)other;
            if (this.isMute != track.isMute) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)track.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.source, (Object)track.source)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.description, (Object)track.description)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.trackId, (Object)track.trackId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.streamId, (Object)track.streamId);
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$Track$Companion;", "", "()V", "from", "Llive/hms/video/sdk/models/HMSNotifications$Track;", "track", "Llive/hms/video/media/tracks/HMSTrack;", "lib_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Track from(@NotNull HMSTrack track) {
                Intrinsics.checkNotNullParameter((Object)track, (String)"track");
                boolean bl = track.isMute();
                String string = track.getType().toString();
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                String string2 = string.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
                return new Track(bl, string2, track.getSource(), track.getDescription(), track.getTrackId(), track.getStream$lib_release().getId());
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$PeerNetworkInfoList;", "Llive/hms/video/sdk/models/HMSNotifications;", "peerNetworkInfoList", "", "Llive/hms/video/sdk/models/HMSNotifications$Peer;", "(Ljava/util/List;)V", "getPeerNetworkInfoList", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "lib_release"})
    public static final class PeerNetworkInfoList
    extends HMSNotifications {
        @SerializedName(value="peers")
        @NotNull
        private final List<Peer> peerNetworkInfoList;

        public PeerNetworkInfoList(@NotNull List<Peer> peerNetworkInfoList) {
            Intrinsics.checkNotNullParameter(peerNetworkInfoList, (String)"peerNetworkInfoList");
            super(null);
            this.peerNetworkInfoList = peerNetworkInfoList;
        }

        @NotNull
        public final List<Peer> getPeerNetworkInfoList() {
            return this.peerNetworkInfoList;
        }

        @NotNull
        public final List<Peer> component1() {
            return this.peerNetworkInfoList;
        }

        @NotNull
        public final PeerNetworkInfoList copy(@NotNull List<Peer> peerNetworkInfoList) {
            Intrinsics.checkNotNullParameter(peerNetworkInfoList, (String)"peerNetworkInfoList");
            return new PeerNetworkInfoList(peerNetworkInfoList);
        }

        public static /* synthetic */ PeerNetworkInfoList copy$default(PeerNetworkInfoList peerNetworkInfoList, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = peerNetworkInfoList.peerNetworkInfoList;
            }
            return peerNetworkInfoList.copy(list);
        }

        @NotNull
        public String toString() {
            return "PeerNetworkInfoList(peerNetworkInfoList=" + this.peerNetworkInfoList + ')';
        }

        public int hashCode() {
            return ((Object)this.peerNetworkInfoList).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PeerNetworkInfoList)) {
                return false;
            }
            PeerNetworkInfoList peerNetworkInfoList = (PeerNetworkInfoList)other;
            return Intrinsics.areEqual(this.peerNetworkInfoList, peerNetworkInfoList.peerNetworkInfoList);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J+\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;", "", "userName", "", "metadata", "customerUserId", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCustomerUserId", "()Ljava/lang/String;", "getMetadata", "getUserName", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "lib_release"})
    public static final class PeerInfo {
        @SerializedName(value="name")
        @NotNull
        private final String userName;
        @SerializedName(value="data")
        @Nullable
        private final String metadata;
        @SerializedName(value="user_id")
        @Nullable
        private final String customerUserId;

        public PeerInfo(@NotNull String userName, @Nullable String metadata, @Nullable String customerUserId) {
            Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
            this.userName = userName;
            this.metadata = metadata;
            this.customerUserId = customerUserId;
        }

        @NotNull
        public final String getUserName() {
            return this.userName;
        }

        @Nullable
        public final String getMetadata() {
            return this.metadata;
        }

        @Nullable
        public final String getCustomerUserId() {
            return this.customerUserId;
        }

        @NotNull
        public final String component1() {
            return this.userName;
        }

        @Nullable
        public final String component2() {
            return this.metadata;
        }

        @Nullable
        public final String component3() {
            return this.customerUserId;
        }

        @NotNull
        public final PeerInfo copy(@NotNull String userName, @Nullable String metadata, @Nullable String customerUserId) {
            Intrinsics.checkNotNullParameter((Object)userName, (String)"userName");
            return new PeerInfo(userName, metadata, customerUserId);
        }

        public static /* synthetic */ PeerInfo copy$default(PeerInfo peerInfo, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = peerInfo.userName;
            }
            if ((n & 2) != 0) {
                string2 = peerInfo.metadata;
            }
            if ((n & 4) != 0) {
                string3 = peerInfo.customerUserId;
            }
            return peerInfo.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "PeerInfo(userName=" + this.userName + ", metadata=" + this.metadata + ", customerUserId=" + this.customerUserId + ')';
        }

        public int hashCode() {
            int result2 = this.userName.hashCode();
            result2 = result2 * 31 + (this.metadata == null ? 0 : this.metadata.hashCode());
            result2 = result2 * 31 + (this.customerUserId == null ? 0 : this.customerUserId.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PeerInfo)) {
                return false;
            }
            PeerInfo peerInfo = (PeerInfo)other;
            if (!Intrinsics.areEqual((Object)this.userName, (Object)peerInfo.userName)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.metadata, (Object)peerInfo.metadata)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.customerUserId, (Object)peerInfo.customerUserId);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0014\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0017\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\u0017\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\nH\u00c6\u0003J\u0015\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001eJA\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u0016\b\u0002\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00062\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u00c6\u0001J\u0013\u0010 \u001a\u00020\u001c2\b\u0010!\u001a\u0004\u0018\u00010\"H\u00d6\u0003J\t\u0010#\u001a\u00020\u0003H\u00d6\u0001J\t\u0010$\u001a\u00020\u0007H\u00d6\u0001R\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R$\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\t\u001a\u0004\u0018\u00010\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\r\u00a8\u0006%"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$PeerList;", "Llive/hms/video/sdk/models/HMSNotifications;", "timestamp", "", "peerCount", "peersMap", "Ljava/util/HashMap;", "", "Llive/hms/video/sdk/models/HMSNotifications$Peer;", "room", "Llive/hms/video/sdk/models/HMSNotifications$InitialRoom;", "(IILjava/util/HashMap;Llive/hms/video/sdk/models/HMSNotifications$InitialRoom;)V", "getPeerCount", "()I", "peers", "", "getPeers", "()[Llive/hms/video/sdk/models/HMSNotifications$Peer;", "getPeersMap", "()Ljava/util/HashMap;", "getRoom", "()Llive/hms/video/sdk/models/HMSNotifications$InitialRoom;", "getTimestamp", "component1", "component2", "component3", "component4", "contains", "", "peerId", "(Ljava/lang/String;)Ljava/lang/Boolean;", "copy", "equals", "other", "", "hashCode", "toString", "lib_release"})
    public static final class PeerList
    extends HMSNotifications {
        @SerializedName(value="timestamp")
        private final int timestamp;
        @SerializedName(value="peer_count")
        private final int peerCount;
        @SerializedName(value="peers")
        @Nullable
        private final HashMap<String, Peer> peersMap;
        @SerializedName(value="room")
        @Nullable
        private final InitialRoom room;

        public PeerList(int timestamp, int peerCount, @Nullable HashMap<String, Peer> peersMap, @Nullable InitialRoom room) {
            super(null);
            this.timestamp = timestamp;
            this.peerCount = peerCount;
            this.peersMap = peersMap;
            this.room = room;
        }

        public final int getTimestamp() {
            return this.timestamp;
        }

        public final int getPeerCount() {
            return this.peerCount;
        }

        @Nullable
        public final HashMap<String, Peer> getPeersMap() {
            return this.peersMap;
        }

        @Nullable
        public final InitialRoom getRoom() {
            return this.room;
        }

        @NotNull
        public final Peer[] getPeers() {
            Peer[] peerArray;
            HashMap<String, Peer> hashMap = this.peersMap;
            if (hashMap == null) {
                peerArray = null;
            } else {
                Collection<Peer> collection = hashMap.values();
                if (collection == null) {
                    peerArray = null;
                } else {
                    Collection<Peer> $this$toTypedArray$iv = collection;
                    boolean $i$f$toTypedArray = false;
                    Collection<Peer> thisCollection$iv = $this$toTypedArray$iv;
                    Peer[] peerArray2 = thisCollection$iv.toArray(new Peer[0]);
                    if (peerArray2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    peerArray = peerArray2;
                }
            }
            Peer[] peerArray3 = peerArray;
            return peerArray3 == null ? new Peer[]{} : peerArray3;
        }

        @Nullable
        public final Boolean contains(@NotNull String peerId) {
            Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
            HashMap<String, Peer> hashMap = this.peersMap;
            return hashMap == null ? null : Boolean.valueOf(hashMap.containsKey(peerId));
        }

        public final int component1() {
            return this.timestamp;
        }

        public final int component2() {
            return this.peerCount;
        }

        @Nullable
        public final HashMap<String, Peer> component3() {
            return this.peersMap;
        }

        @Nullable
        public final InitialRoom component4() {
            return this.room;
        }

        @NotNull
        public final PeerList copy(int timestamp, int peerCount, @Nullable HashMap<String, Peer> peersMap, @Nullable InitialRoom room) {
            return new PeerList(timestamp, peerCount, peersMap, room);
        }

        public static /* synthetic */ PeerList copy$default(PeerList peerList, int n, int n2, HashMap hashMap, InitialRoom initialRoom, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = peerList.timestamp;
            }
            if ((n3 & 2) != 0) {
                n2 = peerList.peerCount;
            }
            if ((n3 & 4) != 0) {
                hashMap = peerList.peersMap;
            }
            if ((n3 & 8) != 0) {
                initialRoom = peerList.room;
            }
            return peerList.copy(n, n2, hashMap, initialRoom);
        }

        @NotNull
        public String toString() {
            return "PeerList(timestamp=" + this.timestamp + ", peerCount=" + this.peerCount + ", peersMap=" + this.peersMap + ", room=" + this.room + ')';
        }

        public int hashCode() {
            int result2 = Integer.hashCode(this.timestamp);
            result2 = result2 * 31 + Integer.hashCode(this.peerCount);
            result2 = result2 * 31 + (this.peersMap == null ? 0 : this.peersMap.hashCode());
            result2 = result2 * 31 + (this.room == null ? 0 : this.room.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PeerList)) {
                return false;
            }
            PeerList peerList = (PeerList)other;
            if (this.timestamp != peerList.timestamp) {
                return false;
            }
            if (this.peerCount != peerList.peerCount) {
                return false;
            }
            if (!Intrinsics.areEqual(this.peersMap, peerList.peersMap)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.room, (Object)peerList.room);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0018\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0080\b\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010!\u001a\u0004\u0018\u00010\tH\u00c6\u0003J\u000b\u0010\"\u001a\u0004\u0018\u00010\u000bH\u00c6\u0003J\t\u0010#\u001a\u00020\rH\u00c6\u0003JS\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\rH\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001e\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u0018\u0010\b\u001a\u0004\u0018\u00010\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0010R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006*"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$InitialRoom;", "", "roomId", "", "sessionId", "name", "startedAt", "", "recording", "Llive/hms/video/sdk/peerlist/models/Recording;", "streaming", "Llive/hms/video/sdk/models/HMSNotifications$Streaming;", "peerCount", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JLlive/hms/video/sdk/peerlist/models/Recording;Llive/hms/video/sdk/models/HMSNotifications$Streaming;I)V", "getName", "()Ljava/lang/String;", "getPeerCount", "()I", "setPeerCount", "(I)V", "getRecording", "()Llive/hms/video/sdk/peerlist/models/Recording;", "getRoomId", "getSessionId", "getStartedAt", "()J", "getStreaming", "()Llive/hms/video/sdk/models/HMSNotifications$Streaming;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "lib_release"})
    public static final class InitialRoom {
        @SerializedName(value="room_id")
        @NotNull
        private final String roomId;
        @SerializedName(value="session_id")
        @NotNull
        private final String sessionId;
        @SerializedName(value="name")
        @NotNull
        private final String name;
        @SerializedName(value="started_at")
        private final long startedAt;
        @SerializedName(value="recording")
        @Nullable
        private final Recording recording;
        @SerializedName(value="streaming")
        @Nullable
        private final Streaming streaming;
        @SerializedName(value="peer_count")
        private int peerCount;

        public InitialRoom(@NotNull String roomId, @NotNull String sessionId, @NotNull String name, long startedAt, @Nullable Recording recording, @Nullable Streaming streaming, int peerCount) {
            Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.roomId = roomId;
            this.sessionId = sessionId;
            this.name = name;
            this.startedAt = startedAt;
            this.recording = recording;
            this.streaming = streaming;
            this.peerCount = peerCount;
        }

        @NotNull
        public final String getRoomId() {
            return this.roomId;
        }

        @NotNull
        public final String getSessionId() {
            return this.sessionId;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final long getStartedAt() {
            return this.startedAt;
        }

        @Nullable
        public final Recording getRecording() {
            return this.recording;
        }

        @Nullable
        public final Streaming getStreaming() {
            return this.streaming;
        }

        public final int getPeerCount() {
            return this.peerCount;
        }

        public final void setPeerCount(int n) {
            this.peerCount = n;
        }

        @NotNull
        public final String component1() {
            return this.roomId;
        }

        @NotNull
        public final String component2() {
            return this.sessionId;
        }

        @NotNull
        public final String component3() {
            return this.name;
        }

        public final long component4() {
            return this.startedAt;
        }

        @Nullable
        public final Recording component5() {
            return this.recording;
        }

        @Nullable
        public final Streaming component6() {
            return this.streaming;
        }

        public final int component7() {
            return this.peerCount;
        }

        @NotNull
        public final InitialRoom copy(@NotNull String roomId, @NotNull String sessionId, @NotNull String name, long startedAt, @Nullable Recording recording, @Nullable Streaming streaming, int peerCount) {
            Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
            Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return new InitialRoom(roomId, sessionId, name, startedAt, recording, streaming, peerCount);
        }

        public static /* synthetic */ InitialRoom copy$default(InitialRoom initialRoom, String string, String string2, String string3, long l, Recording recording, Streaming streaming, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = initialRoom.roomId;
            }
            if ((n2 & 2) != 0) {
                string2 = initialRoom.sessionId;
            }
            if ((n2 & 4) != 0) {
                string3 = initialRoom.name;
            }
            if ((n2 & 8) != 0) {
                l = initialRoom.startedAt;
            }
            if ((n2 & 0x10) != 0) {
                recording = initialRoom.recording;
            }
            if ((n2 & 0x20) != 0) {
                streaming = initialRoom.streaming;
            }
            if ((n2 & 0x40) != 0) {
                n = initialRoom.peerCount;
            }
            return initialRoom.copy(string, string2, string3, l, recording, streaming, n);
        }

        @NotNull
        public String toString() {
            return "InitialRoom(roomId=" + this.roomId + ", sessionId=" + this.sessionId + ", name=" + this.name + ", startedAt=" + this.startedAt + ", recording=" + this.recording + ", streaming=" + this.streaming + ", peerCount=" + this.peerCount + ')';
        }

        public int hashCode() {
            int result2 = this.roomId.hashCode();
            result2 = result2 * 31 + this.sessionId.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.startedAt);
            result2 = result2 * 31 + (this.recording == null ? 0 : this.recording.hashCode());
            result2 = result2 * 31 + (this.streaming == null ? 0 : this.streaming.hashCode());
            result2 = result2 * 31 + Integer.hashCode(this.peerCount);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof InitialRoom)) {
                return false;
            }
            InitialRoom initialRoom = (InitialRoom)other;
            if (!Intrinsics.areEqual((Object)this.roomId, (Object)initialRoom.roomId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.sessionId, (Object)initialRoom.sessionId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)initialRoom.name)) {
                return false;
            }
            if (this.startedAt != initialRoom.startedAt) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.recording, (Object)initialRoom.recording)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.streaming, (Object)initialRoom.streaming)) {
                return false;
            }
            return this.peerCount == initialRoom.peerCount;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$Streaming;", "", "rtmp", "Llive/hms/video/sdk/models/HMSNotifications$Rtmp;", "hls", "Llive/hms/video/sdk/models/HMSNotifications$Hls;", "(Llive/hms/video/sdk/models/HMSNotifications$Rtmp;Llive/hms/video/sdk/models/HMSNotifications$Hls;)V", "getHls", "()Llive/hms/video/sdk/models/HMSNotifications$Hls;", "getRtmp", "()Llive/hms/video/sdk/models/HMSNotifications$Rtmp;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "lib_release"})
    public static final class Streaming {
        @SerializedName(value="rtmp")
        @NotNull
        private final Rtmp rtmp;
        @SerializedName(value="hls")
        @NotNull
        private final Hls hls;

        public Streaming(@NotNull Rtmp rtmp, @NotNull Hls hls) {
            Intrinsics.checkNotNullParameter((Object)rtmp, (String)"rtmp");
            Intrinsics.checkNotNullParameter((Object)hls, (String)"hls");
            this.rtmp = rtmp;
            this.hls = hls;
        }

        @NotNull
        public final Rtmp getRtmp() {
            return this.rtmp;
        }

        @NotNull
        public final Hls getHls() {
            return this.hls;
        }

        @NotNull
        public final Rtmp component1() {
            return this.rtmp;
        }

        @NotNull
        public final Hls component2() {
            return this.hls;
        }

        @NotNull
        public final Streaming copy(@NotNull Rtmp rtmp, @NotNull Hls hls) {
            Intrinsics.checkNotNullParameter((Object)rtmp, (String)"rtmp");
            Intrinsics.checkNotNullParameter((Object)hls, (String)"hls");
            return new Streaming(rtmp, hls);
        }

        public static /* synthetic */ Streaming copy$default(Streaming streaming, Rtmp rtmp, Hls hls, int n, Object object) {
            if ((n & 1) != 0) {
                rtmp = streaming.rtmp;
            }
            if ((n & 2) != 0) {
                hls = streaming.hls;
            }
            return streaming.copy(rtmp, hls);
        }

        @NotNull
        public String toString() {
            return "Streaming(rtmp=" + this.rtmp + ", hls=" + this.hls + ')';
        }

        public int hashCode() {
            int result2 = this.rtmp.hashCode();
            result2 = result2 * 31 + this.hls.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Streaming)) {
                return false;
            }
            Streaming streaming = (Streaming)other;
            if (!Intrinsics.areEqual((Object)this.rtmp, (Object)streaming.rtmp)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.hls, (Object)streaming.hls);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000bJ0\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00032\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0019"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$Rtmp;", "", "enabled", "", "startedAt", "", "stoppedAt", "(ZLjava/lang/Long;Ljava/lang/Long;)V", "getEnabled", "()Z", "getStartedAt", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getStoppedAt", "component1", "component2", "component3", "copy", "(ZLjava/lang/Long;Ljava/lang/Long;)Llive/hms/video/sdk/models/HMSNotifications$Rtmp;", "equals", "other", "hashCode", "", "toString", "", "lib_release"})
    public static final class Rtmp {
        @SerializedName(value="enabled")
        private final boolean enabled;
        @SerializedName(value="started_at")
        @Nullable
        private final Long startedAt;
        @SerializedName(value="stopped_at")
        @Nullable
        private final Long stoppedAt;

        public Rtmp(boolean enabled, @Nullable Long startedAt, @Nullable Long stoppedAt) {
            this.enabled = enabled;
            this.startedAt = startedAt;
            this.stoppedAt = stoppedAt;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        @Nullable
        public final Long getStartedAt() {
            return this.startedAt;
        }

        @Nullable
        public final Long getStoppedAt() {
            return this.stoppedAt;
        }

        public final boolean component1() {
            return this.enabled;
        }

        @Nullable
        public final Long component2() {
            return this.startedAt;
        }

        @Nullable
        public final Long component3() {
            return this.stoppedAt;
        }

        @NotNull
        public final Rtmp copy(boolean enabled, @Nullable Long startedAt, @Nullable Long stoppedAt) {
            return new Rtmp(enabled, startedAt, stoppedAt);
        }

        public static /* synthetic */ Rtmp copy$default(Rtmp rtmp, boolean bl, Long l, Long l2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = rtmp.enabled;
            }
            if ((n & 2) != 0) {
                l = rtmp.startedAt;
            }
            if ((n & 4) != 0) {
                l2 = rtmp.stoppedAt;
            }
            return rtmp.copy(bl, l, l2);
        }

        @NotNull
        public String toString() {
            return "Rtmp(enabled=" + this.enabled + ", startedAt=" + this.startedAt + ", stoppedAt=" + this.stoppedAt + ')';
        }

        public int hashCode() {
            int n = this.enabled ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result2 = n;
            result2 = result2 * 31 + (this.startedAt == null ? 0 : ((Object)this.startedAt).hashCode());
            result2 = result2 * 31 + (this.stoppedAt == null ? 0 : ((Object)this.stoppedAt).hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Rtmp)) {
                return false;
            }
            Rtmp rtmp = (Rtmp)other;
            if (this.enabled != rtmp.enabled) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.startedAt, (Object)rtmp.startedAt)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.stoppedAt, (Object)rtmp.stoppedAt);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$Hls;", "", "enabled", "", "variants", "Ljava/util/ArrayList;", "Llive/hms/video/sdk/models/HMSHLSVariant;", "(ZLjava/util/ArrayList;)V", "getEnabled", "()Z", "getVariants", "()Ljava/util/ArrayList;", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "lib_release"})
    public static final class Hls {
        @SerializedName(value="enabled")
        private final boolean enabled;
        @SerializedName(value="variants")
        @NotNull
        private final ArrayList<HMSHLSVariant> variants;

        public Hls(boolean enabled, @NotNull ArrayList<HMSHLSVariant> variants) {
            Intrinsics.checkNotNullParameter(variants, (String)"variants");
            this.enabled = enabled;
            this.variants = variants;
        }

        public final boolean getEnabled() {
            return this.enabled;
        }

        @NotNull
        public final ArrayList<HMSHLSVariant> getVariants() {
            return this.variants;
        }

        public final boolean component1() {
            return this.enabled;
        }

        @NotNull
        public final ArrayList<HMSHLSVariant> component2() {
            return this.variants;
        }

        @NotNull
        public final Hls copy(boolean enabled, @NotNull ArrayList<HMSHLSVariant> variants) {
            Intrinsics.checkNotNullParameter(variants, (String)"variants");
            return new Hls(enabled, variants);
        }

        public static /* synthetic */ Hls copy$default(Hls hls, boolean bl, ArrayList arrayList, int n, Object object) {
            if ((n & 1) != 0) {
                bl = hls.enabled;
            }
            if ((n & 2) != 0) {
                arrayList = hls.variants;
            }
            return hls.copy(bl, arrayList);
        }

        @NotNull
        public String toString() {
            return "Hls(enabled=" + this.enabled + ", variants=" + this.variants + ')';
        }

        public int hashCode() {
            int n = this.enabled ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result2 = n;
            result2 = result2 * 31 + this.variants.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Hls)) {
                return false;
            }
            Hls hls = (Hls)other;
            if (this.enabled != hls.enabled) {
                return false;
            }
            return Intrinsics.areEqual(this.variants, hls.variants);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$TrackMetadataPeer;", "Llive/hms/video/sdk/models/HMSNotifications;", "peerId", "", "info", "Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;", "(Ljava/lang/String;Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;)V", "getInfo", "()Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;", "getPeerId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "lib_release"})
    public static final class TrackMetadataPeer
    extends HMSNotifications {
        @SerializedName(value="peer_id")
        @NotNull
        private final String peerId;
        @SerializedName(value="info")
        @NotNull
        private final PeerInfo info;

        public TrackMetadataPeer(@NotNull String peerId, @NotNull PeerInfo info) {
            Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            super(null);
            this.peerId = peerId;
            this.info = info;
        }

        @NotNull
        public final String getPeerId() {
            return this.peerId;
        }

        @NotNull
        public final PeerInfo getInfo() {
            return this.info;
        }

        @NotNull
        public final String component1() {
            return this.peerId;
        }

        @NotNull
        public final PeerInfo component2() {
            return this.info;
        }

        @NotNull
        public final TrackMetadataPeer copy(@NotNull String peerId, @NotNull PeerInfo info) {
            Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return new TrackMetadataPeer(peerId, info);
        }

        public static /* synthetic */ TrackMetadataPeer copy$default(TrackMetadataPeer trackMetadataPeer, String string, PeerInfo peerInfo, int n, Object object) {
            if ((n & 1) != 0) {
                string = trackMetadataPeer.peerId;
            }
            if ((n & 2) != 0) {
                peerInfo = trackMetadataPeer.info;
            }
            return trackMetadataPeer.copy(string, peerInfo);
        }

        @NotNull
        public String toString() {
            return "TrackMetadataPeer(peerId=" + this.peerId + ", info=" + this.info + ')';
        }

        public int hashCode() {
            int result2 = this.peerId.hashCode();
            result2 = result2 * 31 + this.info.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrackMetadataPeer)) {
                return false;
            }
            TrackMetadataPeer trackMetadataPeer = (TrackMetadataPeer)other;
            if (!Intrinsics.areEqual((Object)this.peerId, (Object)trackMetadataPeer.peerId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.info, (Object)trackMetadataPeer.info);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J)\u0010\u0013\u001a\u00020\u00002\u0014\b\u0002\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0004H\u00d6\u0001R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$TrackMetadata;", "Llive/hms/video/sdk/models/HMSNotifications;", "tracksMap", "Ljava/util/HashMap;", "", "Llive/hms/video/sdk/models/HMSNotifications$Track;", "peer", "Llive/hms/video/sdk/models/HMSNotifications$TrackMetadataPeer;", "(Ljava/util/HashMap;Llive/hms/video/sdk/models/HMSNotifications$TrackMetadataPeer;)V", "getPeer", "()Llive/hms/video/sdk/models/HMSNotifications$TrackMetadataPeer;", "tracks", "", "getTracks", "()[Llive/hms/video/sdk/models/HMSNotifications$Track;", "getTracksMap", "()Ljava/util/HashMap;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "lib_release"})
    public static final class TrackMetadata
    extends HMSNotifications {
        @SerializedName(value="tracks")
        @NotNull
        private final HashMap<String, Track> tracksMap;
        @SerializedName(value="peer")
        @NotNull
        private final TrackMetadataPeer peer;

        public TrackMetadata(@NotNull HashMap<String, Track> tracksMap, @NotNull TrackMetadataPeer peer) {
            Intrinsics.checkNotNullParameter(tracksMap, (String)"tracksMap");
            Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
            super(null);
            this.tracksMap = tracksMap;
            this.peer = peer;
        }

        @NotNull
        public final HashMap<String, Track> getTracksMap() {
            return this.tracksMap;
        }

        @NotNull
        public final TrackMetadataPeer getPeer() {
            return this.peer;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Track[] getTracks() {
            void $this$toTypedArray$iv;
            Collection<Track> collection = this.tracksMap.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"tracksMap.values");
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            Track[] trackArray = thisCollection$iv.toArray(new Track[0]);
            if (trackArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            return trackArray;
        }

        @NotNull
        public final HashMap<String, Track> component1() {
            return this.tracksMap;
        }

        @NotNull
        public final TrackMetadataPeer component2() {
            return this.peer;
        }

        @NotNull
        public final TrackMetadata copy(@NotNull HashMap<String, Track> tracksMap, @NotNull TrackMetadataPeer peer) {
            Intrinsics.checkNotNullParameter(tracksMap, (String)"tracksMap");
            Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
            return new TrackMetadata(tracksMap, peer);
        }

        public static /* synthetic */ TrackMetadata copy$default(TrackMetadata trackMetadata, HashMap hashMap, TrackMetadataPeer trackMetadataPeer, int n, Object object) {
            if ((n & 1) != 0) {
                hashMap = trackMetadata.tracksMap;
            }
            if ((n & 2) != 0) {
                trackMetadataPeer = trackMetadata.peer;
            }
            return trackMetadata.copy(hashMap, trackMetadataPeer);
        }

        @NotNull
        public String toString() {
            return "TrackMetadata(tracksMap=" + this.tracksMap + ", peer=" + this.peer + ')';
        }

        public int hashCode() {
            int result2 = this.tracksMap.hashCode();
            result2 = result2 * 31 + this.peer.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrackMetadata)) {
                return false;
            }
            TrackMetadata trackMetadata = (TrackMetadata)other;
            if (!Intrinsics.areEqual(this.tracksMap, trackMetadata.tracksMap)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.peer, (Object)trackMetadata.peer);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$RoleChange;", "Llive/hms/video/sdk/models/HMSNotifications;", "role", "Llive/hms/video/sdk/models/role/HMSRole;", "(Llive/hms/video/sdk/models/role/HMSRole;)V", "getRole", "()Llive/hms/video/sdk/models/role/HMSRole;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "lib_release"})
    public static final class RoleChange
    extends HMSNotifications {
        @SerializedName(value="role")
        @NotNull
        private final HMSRole role;

        public RoleChange(@NotNull HMSRole role) {
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            super(null);
            this.role = role;
        }

        @NotNull
        public final HMSRole getRole() {
            return this.role;
        }

        @NotNull
        public final HMSRole component1() {
            return this.role;
        }

        @NotNull
        public final RoleChange copy(@NotNull HMSRole role) {
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            return new RoleChange(role);
        }

        public static /* synthetic */ RoleChange copy$default(RoleChange roleChange, HMSRole hMSRole, int n, Object object) {
            if ((n & 1) != 0) {
                hMSRole = roleChange.role;
            }
            return roleChange.copy(hMSRole);
        }

        @NotNull
        public String toString() {
            return "RoleChange(role=" + this.role + ')';
        }

        public int hashCode() {
            return this.role.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof RoleChange)) {
                return false;
            }
            RoleChange roleChange = (RoleChange)other;
            return Intrinsics.areEqual((Object)this.role, (Object)roleChange.role);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\"\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$PolicyChange;", "Llive/hms/video/sdk/models/HMSNotifications;", "roleName", "", "rolesMap", "Ljava/util/HashMap;", "Llive/hms/video/sdk/models/role/HMSRole;", "(Ljava/lang/String;Ljava/util/HashMap;)V", "getRoleName", "()Ljava/lang/String;", "getRolesMap", "()Ljava/util/HashMap;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "lib_release"})
    public static final class PolicyChange
    extends HMSNotifications {
        @SerializedName(value="name")
        @NotNull
        private final String roleName;
        @SerializedName(value="known_roles")
        @NotNull
        private final HashMap<String, HMSRole> rolesMap;

        public PolicyChange(@NotNull String roleName, @NotNull HashMap<String, HMSRole> rolesMap) {
            Intrinsics.checkNotNullParameter((Object)roleName, (String)"roleName");
            Intrinsics.checkNotNullParameter(rolesMap, (String)"rolesMap");
            super(null);
            this.roleName = roleName;
            this.rolesMap = rolesMap;
        }

        @NotNull
        public final String getRoleName() {
            return this.roleName;
        }

        @NotNull
        public final HashMap<String, HMSRole> getRolesMap() {
            return this.rolesMap;
        }

        @NotNull
        public final String component1() {
            return this.roleName;
        }

        @NotNull
        public final HashMap<String, HMSRole> component2() {
            return this.rolesMap;
        }

        @NotNull
        public final PolicyChange copy(@NotNull String roleName, @NotNull HashMap<String, HMSRole> rolesMap) {
            Intrinsics.checkNotNullParameter((Object)roleName, (String)"roleName");
            Intrinsics.checkNotNullParameter(rolesMap, (String)"rolesMap");
            return new PolicyChange(roleName, rolesMap);
        }

        public static /* synthetic */ PolicyChange copy$default(PolicyChange policyChange, String string, HashMap hashMap, int n, Object object) {
            if ((n & 1) != 0) {
                string = policyChange.roleName;
            }
            if ((n & 2) != 0) {
                hashMap = policyChange.rolesMap;
            }
            return policyChange.copy(string, hashMap);
        }

        @NotNull
        public String toString() {
            return "PolicyChange(roleName=" + this.roleName + ", rolesMap=" + this.rolesMap + ')';
        }

        public int hashCode() {
            int result2 = this.roleName.hashCode();
            result2 = result2 * 31 + this.rolesMap.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PolicyChange)) {
                return false;
            }
            PolicyChange policyChange = (PolicyChange)other;
            if (!Intrinsics.areEqual((Object)this.roleName, (Object)policyChange.roleName)) {
                return false;
            }
            return Intrinsics.areEqual(this.rolesMap, policyChange.rolesMap);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u001c\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$SpeakerList;", "Llive/hms/video/sdk/models/HMSNotifications;", "speakers", "", "Llive/hms/video/sdk/models/HMSSpeakerServerResponse;", "(Ljava/util/List;)V", "getSpeakers", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "lib_release"})
    public static final class SpeakerList
    extends HMSNotifications {
        @SerializedName(value="speaker-list")
        @NotNull
        private final List<HMSSpeakerServerResponse> speakers;

        public SpeakerList(@NotNull List<HMSSpeakerServerResponse> speakers) {
            Intrinsics.checkNotNullParameter(speakers, (String)"speakers");
            super(null);
            this.speakers = speakers;
        }

        @NotNull
        public final List<HMSSpeakerServerResponse> getSpeakers() {
            return this.speakers;
        }

        @NotNull
        public final List<HMSSpeakerServerResponse> component1() {
            return this.speakers;
        }

        @NotNull
        public final SpeakerList copy(@NotNull List<HMSSpeakerServerResponse> speakers) {
            Intrinsics.checkNotNullParameter(speakers, (String)"speakers");
            return new SpeakerList(speakers);
        }

        public static /* synthetic */ SpeakerList copy$default(SpeakerList speakerList, List list, int n, Object object) {
            if ((n & 1) != 0) {
                list = speakerList.speakers;
            }
            return speakerList.copy(list);
        }

        @NotNull
        public String toString() {
            return "SpeakerList(speakers=" + this.speakers + ')';
        }

        public int hashCode() {
            return ((Object)this.speakers).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SpeakerList)) {
                return false;
            }
            SpeakerList speakerList = (SpeakerList)other;
            return Intrinsics.areEqual(this.speakers, speakerList.speakers);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0015"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$BroadcastPeer;", "Llive/hms/video/sdk/models/HMSNotifications;", "peerId", "", "info", "Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;", "(Ljava/lang/String;Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;)V", "getInfo", "()Llive/hms/video/sdk/models/HMSNotifications$PeerInfo;", "getPeerId", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "lib_release"})
    public static final class BroadcastPeer
    extends HMSNotifications {
        @SerializedName(value="peer_id")
        @NotNull
        private final String peerId;
        @SerializedName(value="info")
        @NotNull
        private final PeerInfo info;

        public BroadcastPeer(@NotNull String peerId, @NotNull PeerInfo info) {
            Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            super(null);
            this.peerId = peerId;
            this.info = info;
        }

        @NotNull
        public final String getPeerId() {
            return this.peerId;
        }

        @NotNull
        public final PeerInfo getInfo() {
            return this.info;
        }

        @NotNull
        public final String component1() {
            return this.peerId;
        }

        @NotNull
        public final PeerInfo component2() {
            return this.info;
        }

        @NotNull
        public final BroadcastPeer copy(@NotNull String peerId, @NotNull PeerInfo info) {
            Intrinsics.checkNotNullParameter((Object)peerId, (String)"peerId");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return new BroadcastPeer(peerId, info);
        }

        public static /* synthetic */ BroadcastPeer copy$default(BroadcastPeer broadcastPeer, String string, PeerInfo peerInfo, int n, Object object) {
            if ((n & 1) != 0) {
                string = broadcastPeer.peerId;
            }
            if ((n & 2) != 0) {
                peerInfo = broadcastPeer.info;
            }
            return broadcastPeer.copy(string, peerInfo);
        }

        @NotNull
        public String toString() {
            return "BroadcastPeer(peerId=" + this.peerId + ", info=" + this.info + ')';
        }

        public int hashCode() {
            int result2 = this.peerId.hashCode();
            result2 = result2 * 31 + this.info.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BroadcastPeer)) {
                return false;
            }
            BroadcastPeer broadcastPeer = (BroadcastPeer)other;
            if (!Intrinsics.areEqual((Object)this.peerId, (Object)broadcastPeer.peerId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.info, (Object)broadcastPeer.info);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$BroadcastInfo;", "", "message", "", "type", "(Ljava/lang/String;Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "getType", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "lib_release"})
    public static final class BroadcastInfo {
        @SerializedName(value="message")
        @NotNull
        private final String message;
        @SerializedName(value="type")
        @NotNull
        private final String type;

        public BroadcastInfo(@NotNull String message, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            this.message = message;
            this.type = type;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String component1() {
            return this.message;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        @NotNull
        public final BroadcastInfo copy(@NotNull String message, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return new BroadcastInfo(message, type);
        }

        public static /* synthetic */ BroadcastInfo copy$default(BroadcastInfo broadcastInfo, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = broadcastInfo.message;
            }
            if ((n & 2) != 0) {
                string2 = broadcastInfo.type;
            }
            return broadcastInfo.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "BroadcastInfo(message=" + this.message + ", type=" + this.type + ')';
        }

        public int hashCode() {
            int result2 = this.message.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BroadcastInfo)) {
                return false;
            }
            BroadcastInfo broadcastInfo = (BroadcastInfo)other;
            if (!Intrinsics.areEqual((Object)this.message, (Object)broadcastInfo.message)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.type, (Object)broadcastInfo.type);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\u0011\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J\t\u0010\u001c\u001a\u00020\fH\u00c6\u0003JC\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00072\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00052\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\t\u0010!\u001a\u00020\"H\u00d6\u0001J\t\u0010#\u001a\u00020\bH\u00d6\u0001R\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$OnBroadcast;", "Llive/hms/video/sdk/models/HMSNotifications;", "peer", "Llive/hms/video/sdk/models/HMSNotifications$BroadcastPeer;", "private", "", "roleNames", "Ljava/util/ArrayList;", "", "timestamp", "", "info", "Llive/hms/video/sdk/models/HMSNotifications$BroadcastInfo;", "(Llive/hms/video/sdk/models/HMSNotifications$BroadcastPeer;ZLjava/util/ArrayList;JLlive/hms/video/sdk/models/HMSNotifications$BroadcastInfo;)V", "getInfo", "()Llive/hms/video/sdk/models/HMSNotifications$BroadcastInfo;", "getPeer", "()Llive/hms/video/sdk/models/HMSNotifications$BroadcastPeer;", "getPrivate", "()Z", "getRoleNames", "()Ljava/util/ArrayList;", "getTimestamp", "()J", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "lib_release"})
    public static final class OnBroadcast
    extends HMSNotifications {
        @SerializedName(value="peer")
        @NotNull
        private final BroadcastPeer peer;
        @SerializedName(value="private")
        private final boolean private;
        @SerializedName(value="roles")
        @Nullable
        private final ArrayList<String> roleNames;
        @SerializedName(value="timestamp")
        private final long timestamp;
        @SerializedName(value="info")
        @NotNull
        private final BroadcastInfo info;

        public OnBroadcast(@NotNull BroadcastPeer peer, boolean bl, @Nullable ArrayList<String> roleNames, long timestamp, @NotNull BroadcastInfo info) {
            Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            super(null);
            this.peer = peer;
            this.private = bl;
            this.roleNames = roleNames;
            this.timestamp = timestamp;
            this.info = info;
        }

        @NotNull
        public final BroadcastPeer getPeer() {
            return this.peer;
        }

        public final boolean getPrivate() {
            return this.private;
        }

        @Nullable
        public final ArrayList<String> getRoleNames() {
            return this.roleNames;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        @NotNull
        public final BroadcastInfo getInfo() {
            return this.info;
        }

        @NotNull
        public final BroadcastPeer component1() {
            return this.peer;
        }

        public final boolean component2() {
            return this.private;
        }

        @Nullable
        public final ArrayList<String> component3() {
            return this.roleNames;
        }

        public final long component4() {
            return this.timestamp;
        }

        @NotNull
        public final BroadcastInfo component5() {
            return this.info;
        }

        @NotNull
        public final OnBroadcast copy(@NotNull BroadcastPeer peer, boolean bl, @Nullable ArrayList<String> roleNames, long timestamp, @NotNull BroadcastInfo info) {
            Intrinsics.checkNotNullParameter((Object)peer, (String)"peer");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            return new OnBroadcast(peer, bl, roleNames, timestamp, info);
        }

        public static /* synthetic */ OnBroadcast copy$default(OnBroadcast onBroadcast, BroadcastPeer broadcastPeer, boolean bl, ArrayList arrayList, long l, BroadcastInfo broadcastInfo, int n, Object object) {
            if ((n & 1) != 0) {
                broadcastPeer = onBroadcast.peer;
            }
            if ((n & 2) != 0) {
                bl = onBroadcast.private;
            }
            if ((n & 4) != 0) {
                arrayList = onBroadcast.roleNames;
            }
            if ((n & 8) != 0) {
                l = onBroadcast.timestamp;
            }
            if ((n & 0x10) != 0) {
                broadcastInfo = onBroadcast.info;
            }
            return onBroadcast.copy(broadcastPeer, bl, arrayList, l, broadcastInfo);
        }

        @NotNull
        public String toString() {
            return "OnBroadcast(peer=" + this.peer + ", private=" + this.private + ", roleNames=" + this.roleNames + ", timestamp=" + this.timestamp + ", info=" + this.info + ')';
        }

        public int hashCode() {
            int result2 = this.peer.hashCode();
            int n = this.private ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            result2 = result2 * 31 + (this.roleNames == null ? 0 : this.roleNames.hashCode());
            result2 = result2 * 31 + Long.hashCode(this.timestamp);
            result2 = result2 * 31 + this.info.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OnBroadcast)) {
                return false;
            }
            OnBroadcast onBroadcast = (OnBroadcast)other;
            if (!Intrinsics.areEqual((Object)this.peer, (Object)onBroadcast.peer)) {
                return false;
            }
            if (this.private != onBroadcast.private) {
                return false;
            }
            if (!Intrinsics.areEqual(this.roleNames, onBroadcast.roleNames)) {
                return false;
            }
            if (this.timestamp != onBroadcast.timestamp) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.info, (Object)onBroadcast.info);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u000b\u0010\u000b\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J)\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0016"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$OnRoleChangeRequest;", "Llive/hms/video/sdk/models/HMSNotifications;", "requested_by", "", "roleName", "token", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getRequested_by", "()Ljava/lang/String;", "getRoleName", "getToken", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "lib_release"})
    public static final class OnRoleChangeRequest
    extends HMSNotifications {
        @SerializedName(value="requested_by")
        @Nullable
        private final String requested_by;
        @SerializedName(value="role")
        @NotNull
        private final String roleName;
        @SerializedName(value="token")
        @NotNull
        private final String token;

        public OnRoleChangeRequest(@Nullable String requested_by, @NotNull String roleName, @NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)roleName, (String)"roleName");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            super(null);
            this.requested_by = requested_by;
            this.roleName = roleName;
            this.token = token;
        }

        @Nullable
        public final String getRequested_by() {
            return this.requested_by;
        }

        @NotNull
        public final String getRoleName() {
            return this.roleName;
        }

        @NotNull
        public final String getToken() {
            return this.token;
        }

        @Nullable
        public final String component1() {
            return this.requested_by;
        }

        @NotNull
        public final String component2() {
            return this.roleName;
        }

        @NotNull
        public final String component3() {
            return this.token;
        }

        @NotNull
        public final OnRoleChangeRequest copy(@Nullable String requested_by, @NotNull String roleName, @NotNull String token) {
            Intrinsics.checkNotNullParameter((Object)roleName, (String)"roleName");
            Intrinsics.checkNotNullParameter((Object)token, (String)"token");
            return new OnRoleChangeRequest(requested_by, roleName, token);
        }

        public static /* synthetic */ OnRoleChangeRequest copy$default(OnRoleChangeRequest onRoleChangeRequest, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = onRoleChangeRequest.requested_by;
            }
            if ((n & 2) != 0) {
                string2 = onRoleChangeRequest.roleName;
            }
            if ((n & 4) != 0) {
                string3 = onRoleChangeRequest.token;
            }
            return onRoleChangeRequest.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "OnRoleChangeRequest(requested_by=" + this.requested_by + ", roleName=" + this.roleName + ", token=" + this.token + ')';
        }

        public int hashCode() {
            int result2 = this.requested_by == null ? 0 : this.requested_by.hashCode();
            result2 = result2 * 31 + this.roleName.hashCode();
            result2 = result2 * 31 + this.token.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OnRoleChangeRequest)) {
                return false;
            }
            OnRoleChangeRequest onRoleChangeRequest = (OnRoleChangeRequest)other;
            if (!Intrinsics.areEqual((Object)this.requested_by, (Object)onRoleChangeRequest.requested_by)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.roleName, (Object)onRoleChangeRequest.roleName)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.token, (Object)onRoleChangeRequest.token);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$Unsupported;", "Llive/hms/video/sdk/models/HMSNotifications;", "()V", "lib_release"})
    public static final class Unsupported
    extends HMSNotifications {
        public Unsupported() {
            super(null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$Companion;", "", "()V", "from", "Llive/hms/video/sdk/models/HMSNotifications;", "method", "", "params", "Lcom/google/gson/JsonObject;", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HMSNotifications from(@NotNull String method, @NotNull JsonObject params) {
            Class clazz;
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            switch (method) {
                case "on-peer-join": {
                    clazz = PeerJoin.class;
                    break;
                }
                case "room-state": {
                    clazz = PeerList.class;
                    break;
                }
                case "on-peer-leave": {
                    clazz = PeerLeave.class;
                    break;
                }
                case "on-track-add": {
                    clazz = TrackMetadata.class;
                    break;
                }
                case "on-track-update": {
                    clazz = TrackMetadata.class;
                    break;
                }
                case "peer-list": {
                    clazz = PeerList.class;
                    break;
                }
                case "on-connection-quality-update": {
                    clazz = PeerNetworkInfoList.class;
                    break;
                }
                case "on-policy-change": {
                    clazz = PolicyChange.class;
                    break;
                }
                case "active-speakers": {
                    clazz = SpeakerList.class;
                    break;
                }
                case "on-broadcast": {
                    clazz = OnBroadcast.class;
                    break;
                }
                case "on-role-change-request": {
                    clazz = OnRoleChangeRequest.class;
                    break;
                }
                case "on-peer-update": {
                    clazz = Peer.class;
                    break;
                }
                case "on-peer-leave-request": {
                    clazz = PeerRemoved.class;
                    break;
                }
                case "on-track-update-request": {
                    clazz = TrackUpdateRequest.class;
                    break;
                }
                case "on-change-track-mute-state-request": {
                    clazz = ChangeTrackMuteRequest.class;
                    break;
                }
                case "on-rtmp-start": {
                    clazz = RtmpUpdatedNotification.Start.class;
                    break;
                }
                case "on-rtmp-stop": {
                    clazz = RtmpUpdatedNotification.Stop.class;
                    break;
                }
                case "on-record-start": {
                    clazz = RecordingStateChangeNotification.Start.class;
                    break;
                }
                case "on-record-stop": {
                    clazz = RecordingStateChangeNotification.Stop.class;
                    break;
                }
                case "on-hls-start": {
                    clazz = HLSStateChangeNotification.class;
                    break;
                }
                case "on-hls-stop": {
                    clazz = HLSStateChangeNotification.class;
                    break;
                }
                case "on-track-layer-update": {
                    clazz = OnTrackLayerUpdate.class;
                    break;
                }
                default: {
                    clazz = Unsupported.class;
                }
            }
            Class<Unsupported> cls = clazz;
            Object object = GsonUtils.INSTANCE.getGson().fromJson((JsonElement)params, cls);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"GsonUtils.gson.fromJson(params, cls)");
            return (HMSNotifications)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000f\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J3\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0016\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$PeerRemoved;", "Llive/hms/video/sdk/models/HMSNotifications;", "reason", "", "requestedByPeerId", "timeout", "", "roomWasEnded", "", "(Ljava/lang/String;Ljava/lang/String;IZ)V", "getReason", "()Ljava/lang/String;", "getRequestedByPeerId", "getRoomWasEnded", "()Z", "getTimeout", "()I", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "toString", "lib_release"})
    public static final class PeerRemoved
    extends HMSNotifications {
        @SerializedName(value="reason")
        @NotNull
        private final String reason;
        @SerializedName(value="requested_by")
        @Nullable
        private final String requestedByPeerId;
        @SerializedName(value="timeout")
        private final int timeout;
        @SerializedName(value="room_end")
        private final boolean roomWasEnded;

        public PeerRemoved(@NotNull String reason, @Nullable String requestedByPeerId, int timeout, boolean roomWasEnded) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            super(null);
            this.reason = reason;
            this.requestedByPeerId = requestedByPeerId;
            this.timeout = timeout;
            this.roomWasEnded = roomWasEnded;
        }

        @NotNull
        public final String getReason() {
            return this.reason;
        }

        @Nullable
        public final String getRequestedByPeerId() {
            return this.requestedByPeerId;
        }

        public final int getTimeout() {
            return this.timeout;
        }

        public final boolean getRoomWasEnded() {
            return this.roomWasEnded;
        }

        @NotNull
        public final String component1() {
            return this.reason;
        }

        @Nullable
        public final String component2() {
            return this.requestedByPeerId;
        }

        public final int component3() {
            return this.timeout;
        }

        public final boolean component4() {
            return this.roomWasEnded;
        }

        @NotNull
        public final PeerRemoved copy(@NotNull String reason, @Nullable String requestedByPeerId, int timeout, boolean roomWasEnded) {
            Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
            return new PeerRemoved(reason, requestedByPeerId, timeout, roomWasEnded);
        }

        public static /* synthetic */ PeerRemoved copy$default(PeerRemoved peerRemoved, String string, String string2, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = peerRemoved.reason;
            }
            if ((n2 & 2) != 0) {
                string2 = peerRemoved.requestedByPeerId;
            }
            if ((n2 & 4) != 0) {
                n = peerRemoved.timeout;
            }
            if ((n2 & 8) != 0) {
                bl = peerRemoved.roomWasEnded;
            }
            return peerRemoved.copy(string, string2, n, bl);
        }

        @NotNull
        public String toString() {
            return "PeerRemoved(reason=" + this.reason + ", requestedByPeerId=" + this.requestedByPeerId + ", timeout=" + this.timeout + ", roomWasEnded=" + this.roomWasEnded + ')';
        }

        public int hashCode() {
            int result2 = this.reason.hashCode();
            result2 = result2 * 31 + (this.requestedByPeerId == null ? 0 : this.requestedByPeerId.hashCode());
            result2 = result2 * 31 + Integer.hashCode(this.timeout);
            int n = this.roomWasEnded ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PeerRemoved)) {
                return false;
            }
            PeerRemoved peerRemoved = (PeerRemoved)other;
            if (!Intrinsics.areEqual((Object)this.reason, (Object)peerRemoved.reason)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.requestedByPeerId, (Object)peerRemoved.requestedByPeerId)) {
                return false;
            }
            if (this.timeout != peerRemoved.timeout) {
                return false;
            }
            return this.roomWasEnded == peerRemoved.roomWasEnded;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\tR\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0019"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$TrackUpdateRequest;", "Llive/hms/video/sdk/models/HMSNotifications;", "peerId", "", "trackid", "streamId", "isMute", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "()Z", "getPeerId", "()Ljava/lang/String;", "getStreamId", "getTrackid", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "lib_release"})
    public static final class TrackUpdateRequest
    extends HMSNotifications {
        @SerializedName(value="requested_by")
        @Nullable
        private final String peerId;
        @SerializedName(value="track_id")
        @NotNull
        private final String trackid;
        @SerializedName(value="stream_id")
        @NotNull
        private final String streamId;
        @SerializedName(value="mute")
        private final boolean isMute;

        public TrackUpdateRequest(@Nullable String peerId, @NotNull String trackid, @NotNull String streamId, boolean isMute) {
            Intrinsics.checkNotNullParameter((Object)trackid, (String)"trackid");
            Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
            super(null);
            this.peerId = peerId;
            this.trackid = trackid;
            this.streamId = streamId;
            this.isMute = isMute;
        }

        @Nullable
        public final String getPeerId() {
            return this.peerId;
        }

        @NotNull
        public final String getTrackid() {
            return this.trackid;
        }

        @NotNull
        public final String getStreamId() {
            return this.streamId;
        }

        public final boolean isMute() {
            return this.isMute;
        }

        @Nullable
        public final String component1() {
            return this.peerId;
        }

        @NotNull
        public final String component2() {
            return this.trackid;
        }

        @NotNull
        public final String component3() {
            return this.streamId;
        }

        public final boolean component4() {
            return this.isMute;
        }

        @NotNull
        public final TrackUpdateRequest copy(@Nullable String peerId, @NotNull String trackid, @NotNull String streamId, boolean isMute) {
            Intrinsics.checkNotNullParameter((Object)trackid, (String)"trackid");
            Intrinsics.checkNotNullParameter((Object)streamId, (String)"streamId");
            return new TrackUpdateRequest(peerId, trackid, streamId, isMute);
        }

        public static /* synthetic */ TrackUpdateRequest copy$default(TrackUpdateRequest trackUpdateRequest, String string, String string2, String string3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = trackUpdateRequest.peerId;
            }
            if ((n & 2) != 0) {
                string2 = trackUpdateRequest.trackid;
            }
            if ((n & 4) != 0) {
                string3 = trackUpdateRequest.streamId;
            }
            if ((n & 8) != 0) {
                bl = trackUpdateRequest.isMute;
            }
            return trackUpdateRequest.copy(string, string2, string3, bl);
        }

        @NotNull
        public String toString() {
            return "TrackUpdateRequest(peerId=" + this.peerId + ", trackid=" + this.trackid + ", streamId=" + this.streamId + ", isMute=" + this.isMute + ')';
        }

        public int hashCode() {
            int result2 = this.peerId == null ? 0 : this.peerId.hashCode();
            result2 = result2 * 31 + this.trackid.hashCode();
            result2 = result2 * 31 + this.streamId.hashCode();
            int n = this.isMute ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TrackUpdateRequest)) {
                return false;
            }
            TrackUpdateRequest trackUpdateRequest = (TrackUpdateRequest)other;
            if (!Intrinsics.areEqual((Object)this.peerId, (Object)trackUpdateRequest.peerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.trackid, (Object)trackUpdateRequest.trackid)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.streamId, (Object)trackUpdateRequest.streamId)) {
                return false;
            }
            return this.isMute == trackUpdateRequest.isMute;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B;\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u0011\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003JI\u0010\u0018\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\t2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0007\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006\u001f"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$ChangeTrackMuteRequest;", "Llive/hms/video/sdk/models/HMSNotifications;", "peerId", "", "roles", "", "type", "source", "mute", "", "(Ljava/lang/String;Ljava/util/List;Ljava/lang/String;Ljava/lang/String;Z)V", "getMute", "()Z", "getPeerId", "()Ljava/lang/String;", "getRoles", "()Ljava/util/List;", "getSource", "getType", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "", "hashCode", "", "toString", "lib_release"})
    public static final class ChangeTrackMuteRequest
    extends HMSNotifications {
        @SerializedName(value="requested_by")
        @Nullable
        private final String peerId;
        @SerializedName(value="roles")
        @Nullable
        private final List<String> roles;
        @SerializedName(value="type")
        @Nullable
        private final String type;
        @SerializedName(value="source")
        @Nullable
        private final String source;
        @SerializedName(value="value")
        private final boolean mute;

        public ChangeTrackMuteRequest(@Nullable String peerId, @Nullable List<String> roles, @Nullable String type, @Nullable String source, boolean mute) {
            super(null);
            this.peerId = peerId;
            this.roles = roles;
            this.type = type;
            this.source = source;
            this.mute = mute;
        }

        @Nullable
        public final String getPeerId() {
            return this.peerId;
        }

        @Nullable
        public final List<String> getRoles() {
            return this.roles;
        }

        @Nullable
        public final String getType() {
            return this.type;
        }

        @Nullable
        public final String getSource() {
            return this.source;
        }

        public final boolean getMute() {
            return this.mute;
        }

        @Nullable
        public final String component1() {
            return this.peerId;
        }

        @Nullable
        public final List<String> component2() {
            return this.roles;
        }

        @Nullable
        public final String component3() {
            return this.type;
        }

        @Nullable
        public final String component4() {
            return this.source;
        }

        public final boolean component5() {
            return this.mute;
        }

        @NotNull
        public final ChangeTrackMuteRequest copy(@Nullable String peerId, @Nullable List<String> roles, @Nullable String type, @Nullable String source, boolean mute) {
            return new ChangeTrackMuteRequest(peerId, roles, type, source, mute);
        }

        public static /* synthetic */ ChangeTrackMuteRequest copy$default(ChangeTrackMuteRequest changeTrackMuteRequest, String string, List list, String string2, String string3, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                string = changeTrackMuteRequest.peerId;
            }
            if ((n & 2) != 0) {
                list = changeTrackMuteRequest.roles;
            }
            if ((n & 4) != 0) {
                string2 = changeTrackMuteRequest.type;
            }
            if ((n & 8) != 0) {
                string3 = changeTrackMuteRequest.source;
            }
            if ((n & 0x10) != 0) {
                bl = changeTrackMuteRequest.mute;
            }
            return changeTrackMuteRequest.copy(string, list, string2, string3, bl);
        }

        @NotNull
        public String toString() {
            return "ChangeTrackMuteRequest(peerId=" + this.peerId + ", roles=" + this.roles + ", type=" + this.type + ", source=" + this.source + ", mute=" + this.mute + ')';
        }

        public int hashCode() {
            int result2 = this.peerId == null ? 0 : this.peerId.hashCode();
            result2 = result2 * 31 + (this.roles == null ? 0 : ((Object)this.roles).hashCode());
            result2 = result2 * 31 + (this.type == null ? 0 : this.type.hashCode());
            result2 = result2 * 31 + (this.source == null ? 0 : this.source.hashCode());
            int n = this.mute ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ChangeTrackMuteRequest)) {
                return false;
            }
            ChangeTrackMuteRequest changeTrackMuteRequest = (ChangeTrackMuteRequest)other;
            if (!Intrinsics.areEqual((Object)this.peerId, (Object)changeTrackMuteRequest.peerId)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.roles, changeTrackMuteRequest.roles)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)changeTrackMuteRequest.type)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.source, (Object)changeTrackMuteRequest.source)) {
                return false;
            }
            return this.mute == changeTrackMuteRequest.mute;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$RecordingStateChangeNotification;", "Llive/hms/video/sdk/models/HMSNotifications;", "()V", "Start", "Stop", "Llive/hms/video/sdk/models/HMSNotifications$RecordingStateChangeNotification$Start;", "Llive/hms/video/sdk/models/HMSNotifications$RecordingStateChangeNotification$Stop;", "lib_release"})
    public static abstract class RecordingStateChangeNotification
    extends HMSNotifications {
        private RecordingStateChangeNotification() {
            super(null);
        }

        public /* synthetic */ RecordingStateChangeNotification(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J0\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$RecordingStateChangeNotification$Start;", "Llive/hms/video/sdk/models/HMSNotifications$RecordingStateChangeNotification;", "type", "Llive/hms/video/sdk/models/RecordingType;", "startedAt", "", "error", "Llive/hms/video/sdk/models/HMSNotifications$ServerError;", "(Llive/hms/video/sdk/models/RecordingType;Ljava/lang/Long;Llive/hms/video/sdk/models/HMSNotifications$ServerError;)V", "getError", "()Llive/hms/video/sdk/models/HMSNotifications$ServerError;", "getStartedAt", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getType", "()Llive/hms/video/sdk/models/RecordingType;", "component1", "component2", "component3", "copy", "(Llive/hms/video/sdk/models/RecordingType;Ljava/lang/Long;Llive/hms/video/sdk/models/HMSNotifications$ServerError;)Llive/hms/video/sdk/models/HMSNotifications$RecordingStateChangeNotification$Start;", "equals", "", "other", "", "hashCode", "", "toString", "", "lib_release"})
        public static final class Start
        extends RecordingStateChangeNotification {
            @SerializedName(value="type")
            @NotNull
            private final RecordingType type;
            @SerializedName(value="started_at")
            @Nullable
            private final Long startedAt;
            @SerializedName(value="error")
            @Nullable
            private final ServerError error;

            public Start(@NotNull RecordingType type, @Nullable Long startedAt, @Nullable ServerError error) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                super(null);
                this.type = type;
                this.startedAt = startedAt;
                this.error = error;
            }

            @NotNull
            public final RecordingType getType() {
                return this.type;
            }

            @Nullable
            public final Long getStartedAt() {
                return this.startedAt;
            }

            @Nullable
            public final ServerError getError() {
                return this.error;
            }

            @NotNull
            public final RecordingType component1() {
                return this.type;
            }

            @Nullable
            public final Long component2() {
                return this.startedAt;
            }

            @Nullable
            public final ServerError component3() {
                return this.error;
            }

            @NotNull
            public final Start copy(@NotNull RecordingType type, @Nullable Long startedAt, @Nullable ServerError error) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return new Start(type, startedAt, error);
            }

            public static /* synthetic */ Start copy$default(Start start2, RecordingType recordingType, Long l, ServerError serverError, int n, Object object) {
                if ((n & 1) != 0) {
                    recordingType = start2.type;
                }
                if ((n & 2) != 0) {
                    l = start2.startedAt;
                }
                if ((n & 4) != 0) {
                    serverError = start2.error;
                }
                return start2.copy(recordingType, l, serverError);
            }

            @NotNull
            public String toString() {
                return "Start(type=" + (Object)((Object)this.type) + ", startedAt=" + this.startedAt + ", error=" + this.error + ')';
            }

            public int hashCode() {
                int result2 = this.type.hashCode();
                result2 = result2 * 31 + (this.startedAt == null ? 0 : ((Object)this.startedAt).hashCode());
                result2 = result2 * 31 + (this.error == null ? 0 : this.error.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Start)) {
                    return false;
                }
                Start start2 = (Start)other;
                if (this.type != start2.type) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.startedAt, (Object)start2.startedAt)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.error, (Object)start2.error);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J0\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0018\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$RecordingStateChangeNotification$Stop;", "Llive/hms/video/sdk/models/HMSNotifications$RecordingStateChangeNotification;", "type", "Llive/hms/video/sdk/models/RecordingType;", "stoppedAt", "", "error", "Llive/hms/video/sdk/models/HMSNotifications$ServerError;", "(Llive/hms/video/sdk/models/RecordingType;Ljava/lang/Long;Llive/hms/video/sdk/models/HMSNotifications$ServerError;)V", "getError", "()Llive/hms/video/sdk/models/HMSNotifications$ServerError;", "getStoppedAt", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getType", "()Llive/hms/video/sdk/models/RecordingType;", "component1", "component2", "component3", "copy", "(Llive/hms/video/sdk/models/RecordingType;Ljava/lang/Long;Llive/hms/video/sdk/models/HMSNotifications$ServerError;)Llive/hms/video/sdk/models/HMSNotifications$RecordingStateChangeNotification$Stop;", "equals", "", "other", "", "hashCode", "", "toString", "", "lib_release"})
        public static final class Stop
        extends RecordingStateChangeNotification {
            @SerializedName(value="type")
            @NotNull
            private final RecordingType type;
            @SerializedName(value="stopped_at")
            @Nullable
            private final Long stoppedAt;
            @SerializedName(value="error")
            @Nullable
            private final ServerError error;

            public Stop(@NotNull RecordingType type, @Nullable Long stoppedAt, @Nullable ServerError error) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                super(null);
                this.type = type;
                this.stoppedAt = stoppedAt;
                this.error = error;
            }

            @NotNull
            public final RecordingType getType() {
                return this.type;
            }

            @Nullable
            public final Long getStoppedAt() {
                return this.stoppedAt;
            }

            @Nullable
            public final ServerError getError() {
                return this.error;
            }

            @NotNull
            public final RecordingType component1() {
                return this.type;
            }

            @Nullable
            public final Long component2() {
                return this.stoppedAt;
            }

            @Nullable
            public final ServerError component3() {
                return this.error;
            }

            @NotNull
            public final Stop copy(@NotNull RecordingType type, @Nullable Long stoppedAt, @Nullable ServerError error) {
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                return new Stop(type, stoppedAt, error);
            }

            public static /* synthetic */ Stop copy$default(Stop stop, RecordingType recordingType, Long l, ServerError serverError, int n, Object object) {
                if ((n & 1) != 0) {
                    recordingType = stop.type;
                }
                if ((n & 2) != 0) {
                    l = stop.stoppedAt;
                }
                if ((n & 4) != 0) {
                    serverError = stop.error;
                }
                return stop.copy(recordingType, l, serverError);
            }

            @NotNull
            public String toString() {
                return "Stop(type=" + (Object)((Object)this.type) + ", stoppedAt=" + this.stoppedAt + ", error=" + this.error + ')';
            }

            public int hashCode() {
                int result2 = this.type.hashCode();
                result2 = result2 * 31 + (this.stoppedAt == null ? 0 : ((Object)this.stoppedAt).hashCode());
                result2 = result2 * 31 + (this.error == null ? 0 : this.error.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Stop)) {
                    return false;
                }
                Stop stop = (Stop)other;
                if (this.type != stop.type) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.stoppedAt, (Object)stop.stoppedAt)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.error, (Object)stop.error);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u0003\u0004B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0002\u0005\u0006\u00a8\u0006\u0007"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$RtmpUpdatedNotification;", "Llive/hms/video/sdk/models/HMSNotifications;", "()V", "Start", "Stop", "Llive/hms/video/sdk/models/HMSNotifications$RtmpUpdatedNotification$Start;", "Llive/hms/video/sdk/models/HMSNotifications$RtmpUpdatedNotification$Stop;", "lib_release"})
    public static abstract class RtmpUpdatedNotification
    extends HMSNotifications {
        private RtmpUpdatedNotification() {
            super(null);
        }

        public /* synthetic */ RtmpUpdatedNotification(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J&\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$RtmpUpdatedNotification$Start;", "Llive/hms/video/sdk/models/HMSNotifications$RtmpUpdatedNotification;", "startedAt", "", "error", "Llive/hms/video/sdk/models/HMSNotifications$ServerError;", "(Ljava/lang/Long;Llive/hms/video/sdk/models/HMSNotifications$ServerError;)V", "getError", "()Llive/hms/video/sdk/models/HMSNotifications$ServerError;", "getStartedAt", "()Ljava/lang/Long;", "Ljava/lang/Long;", "component1", "component2", "copy", "(Ljava/lang/Long;Llive/hms/video/sdk/models/HMSNotifications$ServerError;)Llive/hms/video/sdk/models/HMSNotifications$RtmpUpdatedNotification$Start;", "equals", "", "other", "", "hashCode", "", "toString", "", "lib_release"})
        public static final class Start
        extends RtmpUpdatedNotification {
            @SerializedName(value="started_at")
            @Nullable
            private final Long startedAt;
            @SerializedName(value="error")
            @Nullable
            private final ServerError error;

            public Start(@Nullable Long startedAt, @Nullable ServerError error) {
                super(null);
                this.startedAt = startedAt;
                this.error = error;
            }

            @Nullable
            public final Long getStartedAt() {
                return this.startedAt;
            }

            @Nullable
            public final ServerError getError() {
                return this.error;
            }

            @Nullable
            public final Long component1() {
                return this.startedAt;
            }

            @Nullable
            public final ServerError component2() {
                return this.error;
            }

            @NotNull
            public final Start copy(@Nullable Long startedAt, @Nullable ServerError error) {
                return new Start(startedAt, error);
            }

            public static /* synthetic */ Start copy$default(Start start2, Long l, ServerError serverError, int n, Object object) {
                if ((n & 1) != 0) {
                    l = start2.startedAt;
                }
                if ((n & 2) != 0) {
                    serverError = start2.error;
                }
                return start2.copy(l, serverError);
            }

            @NotNull
            public String toString() {
                return "Start(startedAt=" + this.startedAt + ", error=" + this.error + ')';
            }

            public int hashCode() {
                int result2 = this.startedAt == null ? 0 : ((Object)this.startedAt).hashCode();
                result2 = result2 * 31 + (this.error == null ? 0 : this.error.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Start)) {
                    return false;
                }
                Start start2 = (Start)other;
                if (!Intrinsics.areEqual((Object)this.startedAt, (Object)start2.startedAt)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.error, (Object)start2.error);
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J&\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$RtmpUpdatedNotification$Stop;", "Llive/hms/video/sdk/models/HMSNotifications$RtmpUpdatedNotification;", "stoppedAt", "", "error", "Llive/hms/video/sdk/models/HMSNotifications$ServerError;", "(Ljava/lang/Long;Llive/hms/video/sdk/models/HMSNotifications$ServerError;)V", "getError", "()Llive/hms/video/sdk/models/HMSNotifications$ServerError;", "getStoppedAt", "()Ljava/lang/Long;", "Ljava/lang/Long;", "component1", "component2", "copy", "(Ljava/lang/Long;Llive/hms/video/sdk/models/HMSNotifications$ServerError;)Llive/hms/video/sdk/models/HMSNotifications$RtmpUpdatedNotification$Stop;", "equals", "", "other", "", "hashCode", "", "toString", "", "lib_release"})
        public static final class Stop
        extends RtmpUpdatedNotification {
            @SerializedName(value="stopped_at")
            @Nullable
            private final Long stoppedAt;
            @SerializedName(value="error")
            @Nullable
            private final ServerError error;

            public Stop(@Nullable Long stoppedAt, @Nullable ServerError error) {
                super(null);
                this.stoppedAt = stoppedAt;
                this.error = error;
            }

            @Nullable
            public final Long getStoppedAt() {
                return this.stoppedAt;
            }

            @Nullable
            public final ServerError getError() {
                return this.error;
            }

            @Nullable
            public final Long component1() {
                return this.stoppedAt;
            }

            @Nullable
            public final ServerError component2() {
                return this.error;
            }

            @NotNull
            public final Stop copy(@Nullable Long stoppedAt, @Nullable ServerError error) {
                return new Stop(stoppedAt, error);
            }

            public static /* synthetic */ Stop copy$default(Stop stop, Long l, ServerError serverError, int n, Object object) {
                if ((n & 1) != 0) {
                    l = stop.stoppedAt;
                }
                if ((n & 2) != 0) {
                    serverError = stop.error;
                }
                return stop.copy(l, serverError);
            }

            @NotNull
            public String toString() {
                return "Stop(stoppedAt=" + this.stoppedAt + ", error=" + this.error + ')';
            }

            public int hashCode() {
                int result2 = this.stoppedAt == null ? 0 : ((Object)this.stoppedAt).hashCode();
                result2 = result2 * 31 + (this.error == null ? 0 : this.error.hashCode());
                return result2;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Stop)) {
                    return false;
                }
                Stop stop = (Stop)other;
                if (!Intrinsics.areEqual((Object)this.stoppedAt, (Object)stop.stoppedAt)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.error, (Object)stop.error);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B1\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0011\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0019\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\t\u0010\u001b\u001a\u00020\nH\u00c6\u0003J=\u0010\u001c\u001a\u00020\u00002\u0010\b\u0002\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\n2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0018\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0018\u0010\u0007\u001a\u0004\u0018\u00010\b8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R&\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u0006$"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$HLSStateChangeNotification;", "Llive/hms/video/sdk/models/HMSNotifications;", "variants", "Ljava/util/ArrayList;", "Llive/hms/video/sdk/models/HMSHLSVariant;", "hlsStartRecording", "Llive/hms/video/sdk/models/HMSNotifications$HlsStartRecording;", "serverError", "Llive/hms/video/sdk/models/HMSNotifications$ServerError;", "started", "", "(Ljava/util/ArrayList;Llive/hms/video/sdk/models/HMSNotifications$HlsStartRecording;Llive/hms/video/sdk/models/HMSNotifications$ServerError;Z)V", "getHlsStartRecording", "()Llive/hms/video/sdk/models/HMSNotifications$HlsStartRecording;", "getServerError", "()Llive/hms/video/sdk/models/HMSNotifications$ServerError;", "getStarted", "()Z", "setStarted", "(Z)V", "getVariants", "()Ljava/util/ArrayList;", "setVariants", "(Ljava/util/ArrayList;)V", "component1", "component2", "component3", "component4", "copy", "equals", "other", "", "hashCode", "", "toString", "", "lib_release"})
    public static final class HLSStateChangeNotification
    extends HMSNotifications {
        @SerializedName(value="variants")
        @Nullable
        private ArrayList<HMSHLSVariant> variants;
        @SerializedName(value="hls_recording")
        @Nullable
        private final HlsStartRecording hlsStartRecording;
        @SerializedName(value="error")
        @Nullable
        private final ServerError serverError;
        private boolean started;

        public HLSStateChangeNotification(@Nullable ArrayList<HMSHLSVariant> variants, @Nullable HlsStartRecording hlsStartRecording, @Nullable ServerError serverError, boolean started) {
            super(null);
            this.variants = variants;
            this.hlsStartRecording = hlsStartRecording;
            this.serverError = serverError;
            this.started = started;
        }

        @Nullable
        public final ArrayList<HMSHLSVariant> getVariants() {
            return this.variants;
        }

        public final void setVariants(@Nullable ArrayList<HMSHLSVariant> arrayList) {
            this.variants = arrayList;
        }

        @Nullable
        public final HlsStartRecording getHlsStartRecording() {
            return this.hlsStartRecording;
        }

        @Nullable
        public final ServerError getServerError() {
            return this.serverError;
        }

        public final boolean getStarted() {
            return this.started;
        }

        public final void setStarted(boolean bl) {
            this.started = bl;
        }

        @Nullable
        public final ArrayList<HMSHLSVariant> component1() {
            return this.variants;
        }

        @Nullable
        public final HlsStartRecording component2() {
            return this.hlsStartRecording;
        }

        @Nullable
        public final ServerError component3() {
            return this.serverError;
        }

        public final boolean component4() {
            return this.started;
        }

        @NotNull
        public final HLSStateChangeNotification copy(@Nullable ArrayList<HMSHLSVariant> variants, @Nullable HlsStartRecording hlsStartRecording, @Nullable ServerError serverError, boolean started) {
            return new HLSStateChangeNotification(variants, hlsStartRecording, serverError, started);
        }

        public static /* synthetic */ HLSStateChangeNotification copy$default(HLSStateChangeNotification hLSStateChangeNotification, ArrayList arrayList, HlsStartRecording hlsStartRecording, ServerError serverError, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                arrayList = hLSStateChangeNotification.variants;
            }
            if ((n & 2) != 0) {
                hlsStartRecording = hLSStateChangeNotification.hlsStartRecording;
            }
            if ((n & 4) != 0) {
                serverError = hLSStateChangeNotification.serverError;
            }
            if ((n & 8) != 0) {
                bl = hLSStateChangeNotification.started;
            }
            return hLSStateChangeNotification.copy(arrayList, hlsStartRecording, serverError, bl);
        }

        @NotNull
        public String toString() {
            return "HLSStateChangeNotification(variants=" + this.variants + ", hlsStartRecording=" + this.hlsStartRecording + ", serverError=" + this.serverError + ", started=" + this.started + ')';
        }

        public int hashCode() {
            int result2 = this.variants == null ? 0 : this.variants.hashCode();
            result2 = result2 * 31 + (this.hlsStartRecording == null ? 0 : this.hlsStartRecording.hashCode());
            result2 = result2 * 31 + (this.serverError == null ? 0 : this.serverError.hashCode());
            int n = this.started ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HLSStateChangeNotification)) {
                return false;
            }
            HLSStateChangeNotification hLSStateChangeNotification = (HLSStateChangeNotification)other;
            if (!Intrinsics.areEqual(this.variants, hLSStateChangeNotification.variants)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.hlsStartRecording, (Object)hLSStateChangeNotification.hlsStartRecording)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.serverError, (Object)hLSStateChangeNotification.serverError)) {
                return false;
            }
            return this.started == hLSStateChangeNotification.started;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0012"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$HlsStartRecording;", "", "vod", "", "singleFilePerLayer", "(ZZ)V", "getSingleFilePerLayer", "()Z", "getVod", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "lib_release"})
    public static final class HlsStartRecording {
        @SerializedName(value="hls_vod")
        private final boolean vod;
        @SerializedName(value="single_file_per_layer")
        private final boolean singleFilePerLayer;

        public HlsStartRecording(boolean vod, boolean singleFilePerLayer) {
            this.vod = vod;
            this.singleFilePerLayer = singleFilePerLayer;
        }

        public final boolean getVod() {
            return this.vod;
        }

        public final boolean getSingleFilePerLayer() {
            return this.singleFilePerLayer;
        }

        public final boolean component1() {
            return this.vod;
        }

        public final boolean component2() {
            return this.singleFilePerLayer;
        }

        @NotNull
        public final HlsStartRecording copy(boolean vod, boolean singleFilePerLayer) {
            return new HlsStartRecording(vod, singleFilePerLayer);
        }

        public static /* synthetic */ HlsStartRecording copy$default(HlsStartRecording hlsStartRecording, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                bl = hlsStartRecording.vod;
            }
            if ((n & 2) != 0) {
                bl2 = hlsStartRecording.singleFilePerLayer;
            }
            return hlsStartRecording.copy(bl, bl2);
        }

        @NotNull
        public String toString() {
            return "HlsStartRecording(vod=" + this.vod + ", singleFilePerLayer=" + this.singleFilePerLayer + ')';
        }

        public int hashCode() {
            int n;
            int result2;
            int n2 = this.vod ? 1 : 0;
            if (n2 != 0) {
                n2 = result2 = 1;
            }
            if ((n = this.singleFilePerLayer) != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof HlsStartRecording)) {
                return false;
            }
            HlsStartRecording hlsStartRecording = (HlsStartRecording)other;
            if (this.vod != hlsStartRecording.vod) {
                return false;
            }
            return this.singleFilePerLayer == hlsStartRecording.singleFilePerLayer;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\bJ\u000b\u0010\r\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J&\u0010\u000e\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u000fJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010\u0014\u001a\u00020\u0015J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001R\u001a\u0010\u0002\u001a\u0004\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$ServerError;", "", "code", "", "message", "", "(Ljava/lang/Integer;Ljava/lang/String;)V", "getCode", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getMessage", "()Ljava/lang/String;", "component1", "component2", "copy", "(Ljava/lang/Integer;Ljava/lang/String;)Llive/hms/video/sdk/models/HMSNotifications$ServerError;", "equals", "", "other", "hashCode", "toHmsException", "Llive/hms/video/error/HMSException;", "toString", "lib_release"})
    public static final class ServerError {
        @SerializedName(value="code")
        @Nullable
        private final Integer code;
        @SerializedName(value="message")
        @Nullable
        private final String message;

        public ServerError(@Nullable Integer code, @Nullable String message) {
            this.code = code;
            this.message = message;
        }

        @Nullable
        public final Integer getCode() {
            return this.code;
        }

        @Nullable
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final HMSException toHmsException() {
            Object object = this.code;
            int n = object == null ? 0 : (Integer)object;
            String string = this.message;
            object = string == null ? "" : string;
            string = ErrorFactory.Action.NONE.toString();
            String string2 = this.message;
            String string3 = string2 == null ? "" : string2;
            return new HMSException(n, "Server Error", string, (String)object, string3, null, false, null, 224, null);
        }

        @Nullable
        public final Integer component1() {
            return this.code;
        }

        @Nullable
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final ServerError copy(@Nullable Integer code, @Nullable String message) {
            return new ServerError(code, message);
        }

        public static /* synthetic */ ServerError copy$default(ServerError serverError, Integer n, String string, int n2, Object object) {
            if ((n2 & 1) != 0) {
                n = serverError.code;
            }
            if ((n2 & 2) != 0) {
                string = serverError.message;
            }
            return serverError.copy(n, string);
        }

        @NotNull
        public String toString() {
            return "ServerError(code=" + this.code + ", message=" + this.message + ')';
        }

        public int hashCode() {
            int result2 = this.code == null ? 0 : ((Object)this.code).hashCode();
            result2 = result2 * 31 + (this.message == null ? 0 : this.message.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ServerError)) {
                return false;
            }
            ServerError serverError = (ServerError)other;
            if (!Intrinsics.areEqual((Object)this.code, (Object)serverError.code)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)serverError.message);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0080\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0006J\u0017\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003H\u00c6\u0003J!\u0010\n\u001a\u00020\u00002\u0016\b\u0002\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0004H\u00d6\u0001R$\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Llive/hms/video/sdk/models/HMSNotifications$OnTrackLayerUpdate;", "Llive/hms/video/sdk/models/HMSNotifications;", "tracks", "", "", "Llive/hms/video/sdk/models/TrackForLayerUpdate;", "(Ljava/util/Map;)V", "getTracks", "()Ljava/util/Map;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "lib_release"})
    public static final class OnTrackLayerUpdate
    extends HMSNotifications {
        @SerializedName(value="tracks")
        @Nullable
        private final Map<String, TrackForLayerUpdate> tracks;

        public OnTrackLayerUpdate(@Nullable Map<String, TrackForLayerUpdate> tracks) {
            super(null);
            this.tracks = tracks;
        }

        @Nullable
        public final Map<String, TrackForLayerUpdate> getTracks() {
            return this.tracks;
        }

        @Nullable
        public final Map<String, TrackForLayerUpdate> component1() {
            return this.tracks;
        }

        @NotNull
        public final OnTrackLayerUpdate copy(@Nullable Map<String, TrackForLayerUpdate> tracks) {
            return new OnTrackLayerUpdate(tracks);
        }

        public static /* synthetic */ OnTrackLayerUpdate copy$default(OnTrackLayerUpdate onTrackLayerUpdate, Map map2, int n, Object object) {
            if ((n & 1) != 0) {
                map2 = onTrackLayerUpdate.tracks;
            }
            return onTrackLayerUpdate.copy(map2);
        }

        @NotNull
        public String toString() {
            return "OnTrackLayerUpdate(tracks=" + this.tracks + ')';
        }

        public int hashCode() {
            return this.tracks == null ? 0 : ((Object)this.tracks).hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof OnTrackLayerUpdate)) {
                return false;
            }
            OnTrackLayerUpdate onTrackLayerUpdate = (OnTrackLayerUpdate)other;
            return Intrinsics.areEqual(this.tracks, onTrackLayerUpdate.tracks);
        }
    }
}

