/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.signal.init;

import java.io.IOException;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.factories.OkHttpFactory;
import live.hms.video.signal.init.InitConfig;
import live.hms.video.utils.GsonUtils;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.HMSUtils;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u00042\b\b\u0002\u0010\t\u001a\u00020\u0004H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\nJ\"\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\b\u0002\u0010\b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\r"}, d2={"Llive/hms/video/signal/init/InitService;", "", "()V", "TAG", "", "fetchInitConfig", "Llive/hms/video/signal/init/InitConfig;", "token", "region", "endpoint", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "makeInitRequest", "Lokhttp3/Request;", "lib_release"})
public final class InitService {
    @NotNull
    public static final InitService INSTANCE = new InitService();
    @NotNull
    private static final String TAG = "InitService";

    private InitService() {
    }

    private final Request makeInitRequest(String endpoint, String token, String region) {
        String agentUrlEncoded = HMSUtils.INSTANCE.getAgentUrlEncoded();
        String url = endpoint + "?user_agent=" + agentUrlEncoded;
        CharSequence charSequence = region;
        if ((charSequence = (CharSequence)((Object)StringsKt.trim((CharSequence)charSequence)).toString()).length() > 0) {
            charSequence = region;
            url = url + "&region=" + ((Object)StringsKt.trim((CharSequence)charSequence)).toString();
        }
        Request request = new Request.Builder().url(url).addHeader("Authorization", Intrinsics.stringPlus((String)"Bearer ", (Object)token)).addHeader("Accept-Type", "application/json").build();
        HMSLogger.d(TAG, Intrinsics.stringPlus((String)"makeInitRequest: request=", (Object)request));
        return request;
    }

    static /* synthetic */ Request makeInitRequest$default(InitService initService, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "";
        }
        return initService.makeInitRequest(string, string2, string3);
    }

    @Nullable
    public final Object fetchInitConfig(@NotNull String token, @NotNull String region, @NotNull String endpoint, @NotNull Continuation<? super InitConfig> $completion) {
        Request request = this.makeInitRequest(endpoint, token, region);
        CompletableDeferred deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
        OkHttpFactory.INSTANCE.getClient().newCall(request).enqueue(new Callback((CompletableDeferred<InitConfig>)deferred){
            final /* synthetic */ CompletableDeferred<InitConfig> $deferred;
            {
                this.$deferred = $deferred;
            }

            public void onFailure(@NotNull Call call2, @NotNull IOException e) {
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                HMSLogger.INSTANCE.e("InitService", Intrinsics.stringPlus((String)"fetchInitConfig: ", (Object)e.getMessage()), e);
                String string = e.getMessage();
                HMSException ex = ErrorFactory.InitAPIErrors.EndpointUnreachable$default(ErrorFactory.InitAPIErrors.INSTANCE, ErrorFactory.Action.INIT, string == null ? "" : string, e, null, 8, null);
                this.$deferred.completeExceptionally((Throwable)ex);
            }

            public void onResponse(@NotNull Call call2, @NotNull Response response) {
                String string;
                Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                HMSLogger.d("InitService", Intrinsics.stringPlus((String)"fetchInitConfig: response=", (Object)response));
                if (response.code() != 200) {
                    HMSException ex = ErrorFactory.InitAPIErrors.HTTPError$default(ErrorFactory.InitAPIErrors.INSTANCE, response.code(), ErrorFactory.Action.INIT, Intrinsics.stringPlus((String)"Received ", (Object)response.message()), null, null, 24, null);
                    this.$deferred.completeExceptionally((Throwable)ex);
                    return;
                }
                ResponseBody responseBody = response.body();
                String body = responseBody == null ? "" : ((string = responseBody.string()) == null ? "" : string);
                try {
                    InitConfig config = (InitConfig)GsonUtils.INSTANCE.getGson().fromJson(body, InitConfig.class);
                    HMSLogger.d("InitService", Intrinsics.stringPlus((String)"fetchInitConfig: config=", (Object)config));
                    Intrinsics.checkNotNullExpressionValue((Object)config, (String)"config");
                    this.$deferred.complete((Object)config);
                }
                catch (Exception e) {
                    String string2 = e.getMessage();
                    HMSException ex = ErrorFactory.GenericErrors.JsonParsingFailed$default(ErrorFactory.GenericErrors.INSTANCE, ErrorFactory.Action.INIT, body, string2 == null ? "" : string2, e, null, 16, null);
                    HMSLogger.INSTANCE.e("InitService", Intrinsics.stringPlus((String)"fetchInitConfig: ", (Object)ex.getMessage()), ex);
                    this.$deferred.completeExceptionally((Throwable)ex);
                }
            }
        });
        return deferred.await($completion);
    }

    public static /* synthetic */ Object fetchInitConfig$default(InitService initService, String string, String string2, String string3, Continuation continuation, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "https://prod-init.100ms.live/init";
        }
        return initService.fetchInitConfig(string, string2, string3, (Continuation<? super InitConfig>)continuation);
    }
}

