/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.plugin.video;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSAction;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.plugin.video.HMSVideoPlugin;
import live.hms.video.plugin.video.HMSVideoPluginAnalytics;
import live.hms.video.plugin.video.HMSVideoPluginType;
import live.hms.video.sdk.HMSActionResultListener;
import live.hms.video.sdk.HMSPluginResultListener;
import live.hms.video.sdk.ProcessTimeVariables;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.VideoFrame;
import org.webrtc.VideoProcessor;
import org.webrtc.VideoSink;
import org.webrtc.VideoSource;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u0000 :2\u00020\u0001:\u0001:B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\nJ \u0010*\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001b2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\nH\u0002J\u0016\u0010+\u001a\u00020%2\u0006\u0010,\u001a\u00020\u00112\u0006\u0010-\u001a\u00020\u001eJ\u0010\u0010.\u001a\u00020\u000e2\u0006\u0010,\u001a\u00020\u0011H\u0002J\u0006\u0010/\u001a\u00020%J\u0016\u00100\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u0015j\b\u0012\u0004\u0012\u00020\u001b`\u0016J\u0010\u00101\u001a\u00020%2\b\u00102\u001a\u0004\u0018\u000103J\u0012\u00104\u001a\u00020%2\b\u00102\u001a\u0004\u0018\u000103H\u0002J\u000e\u00105\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001bJ\u0010\u00106\u001a\u00020%2\u0006\u0010,\u001a\u00020\u0011H\u0002J\u000e\u00107\u001a\u00020%2\u0006\u00108\u001a\u00020\nJ\b\u00109\u001a\u00020%H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n0\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n0\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0015j\b\u0012\u0004\u0012\u00020\u0011`\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00180\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0018`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n0\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\n`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001a\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001b0\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001b`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u0012\u0012\u0004\u0012\u00020\u001b0\u0015j\b\u0012\u0004\u0012\u00020\u001b`\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u001d\u001a\u001e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001e0\u0010j\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u001e`\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006;"}, d2={"Llive/hms/video/plugin/video/HMSVideoPluginsManager;", "", "source", "Lorg/webrtc/VideoSource;", "eventsService", "Llive/hms/video/events/AnalyticsEventsService;", "(Lorg/webrtc/VideoSource;Llive/hms/video/events/AnalyticsEventsService;)V", "analytics", "Llive/hms/video/plugin/video/HMSVideoPluginAnalytics;", "inputFrameRate", "", "localSink", "Lorg/webrtc/VideoSink;", "pluginAddInProgress", "", "pluginNumFramesSkipped", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "pluginNumFramesToSkip", "plugins", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "pluginsAvgProcessingTime", "", "pluginsFrameRateList", "pluginsMap", "Llive/hms/video/plugin/video/HMSVideoPlugin;", "pluginsObjectList", "pluginsProcessingTimeExceedsSafeLimitCount", "", "setProcessor", "getSource", "()Lorg/webrtc/VideoSource;", "setSource", "(Lorg/webrtc/VideoSource;)V", "addPlugin", "", "plugin", "resultListener", "Llive/hms/video/sdk/HMSActionResultListener;", "pluginFrameRate", "addPluginInternal", "checkIfPluginFpsChangeNeeded", "name", "timeTakenWithML", "checkIfSkipRequired", "clean", "getPlugins", "pluginsProcessing", "frame", "Lorg/webrtc/VideoFrame;", "processFramesThroughPlugins", "removePlugin", "removePluginEntry", "setInputFps", "inputFps", "setVideoProcessor", "Companion", "lib_release"})
public final class HMSVideoPluginsManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private VideoSource source;
    private boolean setProcessor;
    @Nullable
    private VideoSink localSink;
    private int inputFrameRate;
    @NotNull
    private ArrayList<String> plugins;
    @NotNull
    private HashMap<String, HMSVideoPlugin> pluginsMap;
    @NotNull
    private ArrayList<HMSVideoPlugin> pluginsObjectList;
    @NotNull
    private HashMap<String, Double> pluginsAvgProcessingTime;
    @NotNull
    private HashMap<String, Long> pluginsProcessingTimeExceedsSafeLimitCount;
    @NotNull
    private HashMap<String, Integer> pluginsFrameRateList;
    @NotNull
    private HMSVideoPluginAnalytics analytics;
    private boolean pluginAddInProgress;
    @NotNull
    private HashMap<String, Integer> pluginNumFramesToSkip;
    @NotNull
    private HashMap<String, Integer> pluginNumFramesSkipped;
    @NotNull
    public static final String TAG = "HMSVideoPluginsManager";
    public static final int MAX_CONSEQUENT_TIME_VALUE = 30;

    public HMSVideoPluginsManager(@NotNull VideoSource source, @NotNull AnalyticsEventsService eventsService) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)eventsService, (String)"eventsService");
        this.source = source;
        this.plugins = new ArrayList();
        this.pluginsMap = new HashMap();
        this.pluginsObjectList = new ArrayList();
        this.pluginsAvgProcessingTime = new HashMap();
        this.pluginsProcessingTimeExceedsSafeLimitCount = new HashMap();
        this.pluginsFrameRateList = new HashMap();
        this.analytics = new HMSVideoPluginAnalytics(eventsService);
        this.pluginNumFramesToSkip = new HashMap();
        this.pluginNumFramesSkipped = new HashMap();
    }

    @NotNull
    public final VideoSource getSource() {
        return this.source;
    }

    public final void setSource(@NotNull VideoSource videoSource) {
        Intrinsics.checkNotNullParameter((Object)videoSource, (String)"<set-?>");
        this.source = videoSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPlugin(@NotNull HMSVideoPlugin plugin, @NotNull HMSActionResultListener resultListener, int pluginFrameRate) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        Intrinsics.checkNotNullParameter((Object)resultListener, (String)"resultListener");
        if (this.pluginAddInProgress) {
            String name = plugin.getName();
            CharSequence charSequence = name;
            if (charSequence.length() == 0) {
                HMSLogger.INSTANCE.w(TAG, "no name provided by the plugin");
                return;
            }
            HMSException err = ErrorFactory.MediaPluginErrors.INSTANCE.AddAlreadyInProgress(HMSAction.VIDEO_PLUGINS, "Add Plugin is already in Progress");
            this.analytics.failure(name, err);
            HMSLogger.INSTANCE.w(TAG, "can't add another plugin when previous add is in progress");
        }
        this.pluginAddInProgress = true;
        try {
            this.addPluginInternal(plugin, resultListener, pluginFrameRate);
        }
        catch (HMSException err) {
            throw err;
        }
        finally {
            this.pluginAddInProgress = false;
        }
    }

    private final void setVideoProcessor() {
        this.source.setVideoProcessor(new VideoProcessor(this){
            final /* synthetic */ HMSVideoPluginsManager this$0;
            {
                this.this$0 = $receiver;
            }

            public void onCapturerStarted(boolean p0) {
            }

            public void onCapturerStopped() {
            }

            public void onFrameCaptured(@Nullable VideoFrame frame) {
                if (HMSVideoPluginsManager.access$getPlugins$p(this.this$0).size() > 0) {
                    this.this$0.pluginsProcessing(frame);
                } else {
                    VideoSink videoSink = HMSVideoPluginsManager.access$getLocalSink$p(this.this$0);
                    if (videoSink != null) {
                        videoSink.onFrame(frame);
                    }
                }
            }

            public void setSink(@Nullable VideoSink sink) {
                HMSVideoPluginsManager.access$setLocalSink$p(this.this$0, sink);
                HMSLogger.d("HMSVideoPluginsManager", "set local sink");
            }
        });
    }

    private final void addPluginInternal(HMSVideoPlugin plugin, HMSActionResultListener resultListener, int pluginFrameRate) {
        Object object;
        Map map2;
        String name = plugin.getName();
        CharSequence charSequence = name;
        if (charSequence.length() == 0) {
            HMSLogger.INSTANCE.w(TAG, "no name provided by the plugin");
            return;
        }
        if (this.pluginsMap.containsKey(name)) {
            HMSLogger.INSTANCE.w(TAG, "plugin - " + plugin.getName() + " already added.");
            return;
        }
        int numFramesToSkip = 0;
        if (pluginFrameRate > 0) {
            HMSLogger.INSTANCE.i(TAG, "adding plugin " + plugin.getName() + " with framerate " + pluginFrameRate);
            map2 = this.pluginsFrameRateList;
            object = pluginFrameRate;
            map2.put(name, object);
            if (pluginFrameRate < this.inputFrameRate) {
                double d = (double)this.inputFrameRate / (double)pluginFrameRate - 1.0;
                numFramesToSkip = (int)Math.ceil(d);
            }
            this.analytics.added(name, this.inputFrameRate, pluginFrameRate);
        } else {
            map2 = this.pluginsFrameRateList;
            object = 0;
            map2.put(name, object);
            HMSLogger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"adding plugin ", (Object)plugin.getName()));
            this.analytics.added(name, this.inputFrameRate, null);
        }
        HMSLogger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"numFrames to skip processing ", (Object)numFramesToSkip));
        map2 = this.pluginNumFramesToSkip;
        object = numFramesToSkip;
        map2.put(name, object);
        map2 = this.pluginNumFramesSkipped;
        object = numFramesToSkip;
        map2.put(name, object);
        map2 = this.pluginsAvgProcessingTime;
        object = 0.0;
        map2.put(name, object);
        map2 = this.pluginsProcessingTimeExceedsSafeLimitCount;
        object = 0L;
        map2.put(name, object);
        if (!plugin.isSupported()) {
            HMSException err = ErrorFactory.MediaPluginErrors.INSTANCE.PlatformNotSupported(HMSAction.VIDEO_PLUGINS, "platform not supported");
            this.analytics.failure(name, err);
            HMSLogger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"Platform/Resolution is not supported for plugin - ", (Object)plugin.getName()));
            throw err;
        }
        try {
            Function0 lambda2 = (Function0)new Function0<Unit>(plugin){
                final /* synthetic */ HMSVideoPlugin $plugin;
                {
                    this.$plugin = $plugin;
                    super(0);
                }

                public final void invoke() {
                    this.$plugin.init();
                }
            };
            this.analytics.initWithTime(name, (Function0<Unit>)lambda2);
            this.plugins.add(name);
            this.pluginsObjectList.add(plugin);
            object = this.pluginsMap;
            object.put(name, plugin);
            if (!this.setProcessor) {
                HMSLogger.d(TAG, "setting video processor");
                this.setVideoProcessor();
                HMSLogger.d(TAG, Intrinsics.stringPlus((String)"source set on processor ", (Object)this.source));
                this.setProcessor = true;
            }
            resultListener.onSuccess();
        }
        catch (HMSException err) {
            HMSLogger.INSTANCE.e(TAG, "failed to add plugin", err);
            this.removePlugin(plugin);
            throw err;
        }
    }

    public final void pluginsProcessing(@Nullable VideoFrame frame) {
        try {
            this.processFramesThroughPlugins(frame);
        }
        catch (HMSException err) {
            HMSLogger.INSTANCE.e(TAG, "error in plugins loop", err);
            throw err;
        }
    }

    private final void processFramesThroughPlugins(VideoFrame frame) {
        for (String name : this.plugins) {
            HMSVideoPlugin hMSVideoPlugin;
            HMSVideoPlugin hMSVideoPlugin2 = this.pluginsMap.get(name);
            if (hMSVideoPlugin2 == null) continue;
            HMSVideoPlugin plugin = hMSVideoPlugin = hMSVideoPlugin2;
            try {
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                boolean skipProcessing = this.checkIfSkipRequired(name);
                if (plugin.getPluginType() == HMSVideoPluginType.TRANSFORM) {
                    VideoFrame videoFrame = frame;
                    Intrinsics.checkNotNull((Object)videoFrame);
                    plugin.processVideoFrame(videoFrame, new HMSPluginResultListener(this, name){
                        final /* synthetic */ HMSVideoPluginsManager this$0;
                        final /* synthetic */ String $name;
                        {
                            this.this$0 = $receiver;
                            this.$name = $name;
                        }

                        public void onOutputResult(@Nullable VideoFrame output) {
                            VideoFrame.Buffer buffer;
                            VideoSink videoSink = HMSVideoPluginsManager.access$getLocalSink$p(this.this$0);
                            if (videoSink != null) {
                                videoSink.onFrame(output);
                            }
                            videoSink = output;
                            if (videoSink != null && (buffer = videoSink.getBuffer()) != null) {
                                buffer.release();
                            }
                        }

                        public void onTimeTaken(@NotNull ProcessTimeVariables timeObject) {
                            Intrinsics.checkNotNullParameter((Object)timeObject, (String)"timeObject");
                            HMSVideoPluginAnalytics hMSVideoPluginAnalytics = HMSVideoPluginsManager.access$getAnalytics$p(this.this$0);
                            String string = this.$name;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                            hMSVideoPluginAnalytics.processTime(string, timeObject.getTimeTakenWithML(), timeObject.getTimeTakenWithoutML());
                            HMSLogger.INSTANCE.v("HMSVideoPluginsManager", "Total time taken by processing frame with ML " + timeObject.getTimeTakenWithML() + "ms");
                            HMSLogger.INSTANCE.v("HMSVideoPluginsManager", "Total time taken by processing frame without ML " + timeObject.getTimeTakenWithoutML() + "ms");
                            string = this.$name;
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                            this.this$0.checkIfPluginFpsChangeNeeded(string, timeObject.getTimeTakenWithML());
                        }
                    }, skipProcessing);
                    continue;
                }
                if (plugin.getPluginType() != HMSVideoPluginType.ANALYZE || skipProcessing) continue;
                Function0 processFn2 = (Function0)new Function0<Unit>(plugin, frame){
                    final /* synthetic */ HMSVideoPlugin $plugin;
                    final /* synthetic */ VideoFrame $frame;
                    {
                        this.$plugin = $plugin;
                        this.$frame = $frame;
                        super(0);
                    }

                    public final void invoke() {
                        VideoFrame videoFrame = this.$frame;
                        Intrinsics.checkNotNull((Object)videoFrame);
                        this.$plugin.processVideoFrame(videoFrame, null, false);
                    }
                };
                this.analytics.processWithTime(name, (Function0<Unit>)processFn2);
                VideoSink videoSink = this.localSink;
                if (videoSink == null) continue;
                videoSink.onFrame(frame);
            }
            catch (HMSException err) {
                HMSLogger.INSTANCE.e(TAG, Intrinsics.stringPlus((String)"error in processing plugin ", (Object)name), err);
                HMSException e = ErrorFactory.MediaPluginErrors.INSTANCE.ProcessingFailed(HMSAction.VIDEO_PLUGINS, Intrinsics.stringPlus((String)"Failed during processing of plugin", (Object)err.getMessage()));
                HMSLogger.e("HMSVideoPluginAnalytics", err.toString());
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                this.analytics.failure(name, err);
                this.removePlugin(plugin);
                throw err;
            }
        }
    }

    public final void removePlugin(@NotNull HMSVideoPlugin plugin) {
        Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
        String name = plugin.getName();
        if (!this.pluginsMap.containsKey(name)) {
            HMSLogger.INSTANCE.w(TAG, "plugin - " + name + " not found to remove.");
            return;
        }
        HMSLogger.INSTANCE.i(TAG, Intrinsics.stringPlus((String)"removing plugin ", (Object)name));
        this.pluginsObjectList.remove(plugin);
        this.removePluginEntry(name);
        if (this.plugins.size() == 0) {
            HMSLogger.INSTANCE.i(TAG, "No plugins left, stopping processing");
        }
        plugin.stop();
        this.analytics.removed(name);
    }

    @NotNull
    public final ArrayList<HMSVideoPlugin> getPlugins() {
        return this.pluginsObjectList;
    }

    public final void checkIfPluginFpsChangeNeeded(@NotNull String name, long timeTakenWithML) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (timeTakenWithML > 0L) {
            if (Intrinsics.areEqual((Double)this.pluginsAvgProcessingTime.get(name), (double)0.0)) {
                Map map2 = this.pluginsAvgProcessingTime;
                Double d = timeTakenWithML;
                map2.put(name, d);
            } else if (this.pluginsFrameRateList.containsKey(name)) {
                IntRange intRange = new IntRange(11, 15);
                Integer n = this.pluginsFrameRateList.get(name);
                if (n != null && intRange.contains(n.intValue())) {
                    double d = timeTakenWithML;
                    Double d2 = this.pluginsAvgProcessingTime.get(name);
                    Intrinsics.checkNotNull((Object)d2);
                    Object object = d2;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pluginsAvgProcessingTime[name]!!");
                    double avgTime = (d + ((Number)object).doubleValue()) / 2.0;
                    object = this.pluginsAvgProcessingTime;
                    Number number = avgTime;
                    object.put(name, number);
                    if (avgTime > 100.0 && this.pluginsProcessingTimeExceedsSafeLimitCount.containsKey(name)) {
                        object = this.pluginsProcessingTimeExceedsSafeLimitCount;
                        Long l = this.pluginsProcessingTimeExceedsSafeLimitCount.get(name);
                        Intrinsics.checkNotNull((Object)l);
                        number = ((Number)l).longValue() + 1L;
                        object.put(name, number);
                        Long l2 = this.pluginsProcessingTimeExceedsSafeLimitCount.get(name);
                        Intrinsics.checkNotNull((Object)l2);
                        object = l2;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pluginsProcessingTimeExceedsSafeLimitCount[name]!!");
                        if (((Number)object).longValue() > 30L) {
                            HMSLogger.INSTANCE.i(TAG, "Reducing the plugin Frame Rate to 10");
                            object = this.pluginsFrameRateList;
                            number = 10;
                            object.put(name, number);
                            double d3 = this.inputFrameRate;
                            Integer n2 = this.pluginsFrameRateList.get(name);
                            Intrinsics.checkNotNull((Object)n2);
                            number = n2;
                            Intrinsics.checkNotNullExpressionValue((Object)number, (String)"pluginsFrameRateList[name]!!");
                            double d4 = d3 / ((Number)number).doubleValue() - 1.0;
                            int numFramesToSkip = (int)Math.ceil(d4);
                            Map map3 = this.pluginNumFramesToSkip;
                            Integer n3 = numFramesToSkip;
                            map3.put(name, n3);
                            map3 = this.pluginNumFramesSkipped;
                            n3 = numFramesToSkip;
                            map3.put(name, n3);
                        }
                    } else {
                        object = this.pluginsProcessingTimeExceedsSafeLimitCount;
                        number = 0L;
                        object.put(name, number);
                    }
                }
            }
        }
    }

    public final void clean() {
        Object object = this.pluginsMap;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            Object object2 = object = iterator.next();
            String name = (String)object2.getKey();
            Object object3 = object;
            HMSVideoPlugin plugin = (HMSVideoPlugin)object3.getValue();
            this.removePlugin(plugin);
            this.analytics.clean(name);
        }
        this.pluginsMap.clear();
        this.pluginNumFramesSkipped.clear();
        this.pluginNumFramesToSkip.clear();
        this.plugins.clear();
        this.pluginsObjectList.clear();
        this.pluginsAvgProcessingTime.clear();
        this.pluginsProcessingTimeExceedsSafeLimitCount.clear();
        this.pluginsFrameRateList.clear();
        this.setProcessor = false;
        this.source.setVideoProcessor(null);
    }

    public final void setInputFps(int inputFps) {
        this.inputFrameRate = inputFps;
    }

    private final void removePluginEntry(String name) {
        this.plugins.remove(name);
        this.pluginsMap.remove(name);
        this.pluginNumFramesToSkip.remove(name);
        this.pluginNumFramesSkipped.remove(name);
        this.pluginsAvgProcessingTime.remove(name);
        this.pluginsProcessingTimeExceedsSafeLimitCount.remove(name);
        this.pluginsFrameRateList.remove(name);
    }

    private final boolean checkIfSkipRequired(String name) {
        boolean skip = false;
        Integer n = this.pluginNumFramesSkipped.get(name);
        Intrinsics.checkNotNull((Object)n);
        Object object = n;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pluginNumFramesSkipped[name]!!");
        int n2 = ((Number)object).intValue();
        Integer n3 = this.pluginNumFramesToSkip.get(name);
        Intrinsics.checkNotNull((Object)n3);
        object = n3;
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pluginNumFramesToSkip[name]!!");
        if (n2 < ((Number)object).intValue()) {
            object = this.pluginNumFramesSkipped;
            Integer n4 = this.pluginNumFramesSkipped.get(name);
            Intrinsics.checkNotNull((Object)n4);
            Integer n5 = ((Number)n4).intValue() + 1;
            object.put(name, n5);
            skip = true;
        } else {
            skip = false;
            object = this.pluginNumFramesSkipped;
            Integer n6 = 0;
            object.put(name, n6);
        }
        return skip;
    }

    public static final /* synthetic */ ArrayList access$getPlugins$p(HMSVideoPluginsManager $this) {
        return $this.plugins;
    }

    public static final /* synthetic */ VideoSink access$getLocalSink$p(HMSVideoPluginsManager $this) {
        return $this.localSink;
    }

    public static final /* synthetic */ void access$setLocalSink$p(HMSVideoPluginsManager $this, VideoSink videoSink) {
        $this.localSink = videoSink;
    }

    public static final /* synthetic */ HMSVideoPluginAnalytics access$getAnalytics$p(HMSVideoPluginsManager $this) {
        return $this.analytics;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Llive/hms/video/plugin/video/HMSVideoPluginsManager$Companion;", "", "()V", "MAX_CONSEQUENT_TIME_VALUE", "", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

