/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.settings;

import androidx.annotation.IntRange;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.events.IAnalyticsPropertiesProvider;
import live.hms.video.media.codec.HMSVideoCodec;
import live.hms.video.media.settings.HMSVideoResolution;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001e\u001fB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u0017\u001a\u00020\u0018J$\u0010\u0019\u001a\u001e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c0\u001aj\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c`\u001dH\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006 "}, d2={"Llive/hms/video/media/settings/HMSVideoTrackSettings;", "Llive/hms/video/events/IAnalyticsPropertiesProvider;", "resolution", "Llive/hms/video/media/settings/HMSVideoResolution;", "codec", "Llive/hms/video/media/codec/HMSVideoCodec;", "maxFrameRate", "", "maxBitRate", "cameraFacing", "Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;", "(Llive/hms/video/media/settings/HMSVideoResolution;Llive/hms/video/media/codec/HMSVideoCodec;IILlive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;)V", "getCameraFacing", "()Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;", "setCameraFacing", "(Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;)V", "getCodec", "()Llive/hms/video/media/codec/HMSVideoCodec;", "getMaxBitRate", "()I", "getMaxFrameRate", "getResolution", "()Llive/hms/video/media/settings/HMSVideoResolution;", "builder", "Llive/hms/video/media/settings/HMSVideoTrackSettings$Builder;", "toAnalyticsProperties", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "Builder", "CameraFacing", "lib_release"})
public final class HMSVideoTrackSettings
implements IAnalyticsPropertiesProvider {
    @NotNull
    private final HMSVideoResolution resolution;
    @NotNull
    private final HMSVideoCodec codec;
    private final int maxFrameRate;
    private final int maxBitRate;
    @NotNull
    private CameraFacing cameraFacing;

    private HMSVideoTrackSettings(HMSVideoResolution resolution, HMSVideoCodec codec, int maxFrameRate, int maxBitRate, CameraFacing cameraFacing) {
        this.resolution = resolution;
        this.codec = codec;
        this.maxFrameRate = maxFrameRate;
        this.maxBitRate = maxBitRate;
        this.cameraFacing = cameraFacing;
    }

    @NotNull
    public final HMSVideoResolution getResolution() {
        return this.resolution;
    }

    @NotNull
    public final HMSVideoCodec getCodec() {
        return this.codec;
    }

    public final int getMaxFrameRate() {
        return this.maxFrameRate;
    }

    public final int getMaxBitRate() {
        return this.maxBitRate;
    }

    @NotNull
    public final CameraFacing getCameraFacing() {
        return this.cameraFacing;
    }

    public final void setCameraFacing(@NotNull CameraFacing cameraFacing) {
        Intrinsics.checkNotNullParameter((Object)((Object)cameraFacing), (String)"<set-?>");
        this.cameraFacing = cameraFacing;
    }

    @Override
    @NotNull
    public HashMap<String, Object> toAnalyticsProperties() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"width", (Object)this.resolution.getWidth()), TuplesKt.to((Object)"height", (Object)this.resolution.getHeight()), TuplesKt.to((Object)"video_bitrate", (Object)this.maxBitRate), TuplesKt.to((Object)"framerate", (Object)this.maxFrameRate), TuplesKt.to((Object)"video_codec", (Object)((Object)this.codec))};
        return MapsKt.hashMapOf((Pair[])pairArray);
    }

    @NotNull
    public final Builder builder() {
        return new Builder().resolution(this.resolution).codec(this.codec).maxFrameRate(this.maxFrameRate).maxBitrate(this.maxBitRate).cameraFacing(this.cameraFacing);
    }

    public /* synthetic */ HMSVideoTrackSettings(HMSVideoResolution resolution, HMSVideoCodec codec, int maxFrameRate, int maxBitRate, CameraFacing cameraFacing, DefaultConstructorMarker $constructor_marker) {
        this(resolution, codec, maxFrameRate, maxBitRate, cameraFacing);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;", "", "(Ljava/lang/String;I)V", "FRONT", "BACK", "lib_release"})
    public static final class CameraFacing
    extends Enum<CameraFacing> {
        public static final /* enum */ CameraFacing FRONT = new CameraFacing();
        public static final /* enum */ CameraFacing BACK = new CameraFacing();
        private static final /* synthetic */ CameraFacing[] $VALUES;

        public static CameraFacing[] values() {
            return (CameraFacing[])$VALUES.clone();
        }

        public static CameraFacing valueOf(String value) {
            return Enum.valueOf(CameraFacing.class, value);
        }

        static {
            $VALUES = cameraFacingArray = new CameraFacing[]{CameraFacing.FRONT, CameraFacing.BACK};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u000f\u001a\u00020\u00002\b\b\u0001\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u00020\u00002\b\b\u0001\u0010\t\u001a\u00020\bJ\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Llive/hms/video/media/settings/HMSVideoTrackSettings$Builder;", "", "()V", "cameraFacing", "Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;", "codec", "Llive/hms/video/media/codec/HMSVideoCodec;", "maxBitRate", "", "maxFrameRate", "resolution", "Llive/hms/video/media/settings/HMSVideoResolution;", "build", "Llive/hms/video/media/settings/HMSVideoTrackSettings;", "facing", "maxBitrate", "lib_release"})
    public static final class Builder {
        @NotNull
        private HMSVideoResolution resolution = new HMSVideoResolution(320, 180);
        @NotNull
        private HMSVideoCodec codec = HMSVideoCodec.VP8;
        private int maxFrameRate = 24;
        private int maxBitRate = 150000;
        @NotNull
        private CameraFacing cameraFacing = CameraFacing.FRONT;

        @NotNull
        public final Builder resolution(@NotNull HMSVideoResolution resolution) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)resolution, (String)"resolution");
            Builder $this$resolution_u24lambda_u2d0 = builder = this;
            boolean bl = false;
            $this$resolution_u24lambda_u2d0.resolution = resolution;
            return builder;
        }

        @NotNull
        public final Builder codec(@NotNull HMSVideoCodec codec) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)codec), (String)"codec");
            Builder $this$codec_u24lambda_u2d1 = builder = this;
            boolean bl = false;
            $this$codec_u24lambda_u2d1.codec = codec;
            return builder;
        }

        @NotNull
        public final Builder maxFrameRate(@IntRange(from=1L) int maxFrameRate) {
            Builder builder;
            Builder $this$maxFrameRate_u24lambda_u2d2 = builder = this;
            boolean bl = false;
            $this$maxFrameRate_u24lambda_u2d2.maxFrameRate = maxFrameRate;
            return builder;
        }

        @NotNull
        public final Builder maxBitrate(@IntRange(from=1L) int maxBitRate) {
            Builder builder;
            Builder $this$maxBitrate_u24lambda_u2d3 = builder = this;
            boolean bl = false;
            $this$maxBitrate_u24lambda_u2d3.maxBitRate = maxBitRate;
            return builder;
        }

        @NotNull
        public final Builder cameraFacing(@NotNull CameraFacing facing) {
            Builder builder;
            Intrinsics.checkNotNullParameter((Object)((Object)facing), (String)"facing");
            Builder $this$cameraFacing_u24lambda_u2d4 = builder = this;
            boolean bl = false;
            $this$cameraFacing_u24lambda_u2d4.cameraFacing = facing;
            return builder;
        }

        @NotNull
        public final HMSVideoTrackSettings build() {
            return new HMSVideoTrackSettings(this.resolution, this.codec, this.maxFrameRate, this.maxBitRate, this.cameraFacing, null);
        }
    }
}

