/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.audio;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.util.List;
import java.util.Set;
import live.hms.video.audio.BluetoothErrorType;
import live.hms.video.audio.BluetoothErrors;
import live.hms.video.audio.HMSAudioManager;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.ThreadUtils;

class HMSBluetoothManager {
    private static final String TAG = "HMSBluetoothManager";
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 4000;
    private static final int MAX_SCO_CONNECTION_ATTEMPTS = 2;
    private final Context HMSContext;
    private final HMSAudioManager hmsAudioManager;
    @Nullable
    private final AudioManager audioManager;
    private final Handler handler;
    int scoConnectionAttempts;
    private State bluetoothState;
    private final BluetoothProfile.ServiceListener bluetoothServiceListener;
    @Nullable
    private BluetoothAdapter bluetoothAdapter;
    @Nullable
    private BluetoothHeadset bluetoothHeadset;
    @Nullable
    private BluetoothDevice bluetoothDevice;
    private final BroadcastReceiver bluetoothHeadsetReceiver;
    private final Runnable bluetoothTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            HMSBluetoothManager.this.bluetoothTimeout();
        }
    };

    static HMSBluetoothManager create(Context context, HMSAudioManager audioManager) {
        HMSLogger.d(TAG, "create" + ThreadUtils.getThreadInfo());
        return new HMSBluetoothManager(context, audioManager);
    }

    @MainThread
    protected HMSBluetoothManager(Context context, HMSAudioManager audioManager) {
        HMSLogger.d(TAG, "ctor");
        this.HMSContext = context;
        this.hmsAudioManager = audioManager;
        this.audioManager = this.getAudioManager(context);
        this.bluetoothState = State.UNINITIALIZED;
        this.bluetoothServiceListener = new BluetoothServiceListener();
        this.bluetoothHeadsetReceiver = new BluetoothHeadsetBroadcastReceiver();
        this.handler = new Handler(Looper.getMainLooper());
    }

    @MainThread
    public State getState() {
        return this.bluetoothState;
    }

    @MainThread
    public void start(BluetoothErrors bluetoothErrors) {
        HMSLogger.d(TAG, "start");
        boolean noBluetoothPermission = !this.hasPermission(this.HMSContext, "android.permission.BLUETOOTH");
        boolean noBluetoothConnectPermissionOn12 = this.isDeviceAndroid12AndAbove() && !this.hasAndroid12Permissions(this.HMSContext);
        BluetoothErrorType error = null;
        if (noBluetoothPermission) {
            error = BluetoothErrorType.NO_BLUETOOTH_PERMISSON;
        } else if (noBluetoothConnectPermissionOn12) {
            error = BluetoothErrorType.NO_BLUETOOTH_CONNECT_PERMISSION;
        }
        if (error != null) {
            Log.w((String)TAG, (String)("Process (pid=" + Process.myPid() + ") lacks either BLUETOOTH permission or BLUETOOTH_CONNECT permission (required on android 12). Bluetooth was not initialized. To use bluetooth headsets, please grant those permissions."));
            bluetoothErrors.onBluetoothError(error);
            return;
        }
        if (this.bluetoothState != State.UNINITIALIZED) {
            Log.w((String)TAG, (String)"Invalid BT state");
            return;
        }
        this.bluetoothHeadset = null;
        this.bluetoothDevice = null;
        this.scoConnectionAttempts = 0;
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.bluetoothAdapter == null) {
            Log.w((String)TAG, (String)"Device does not support Bluetooth");
            return;
        }
        if (!this.audioManager.isBluetoothScoAvailableOffCall()) {
            Log.e((String)TAG, (String)"Bluetooth SCO audio is not available off call");
            return;
        }
        this.logBluetoothAdapterInfo(this.bluetoothAdapter);
        if (!this.getBluetoothProfileProxy(this.HMSContext, this.bluetoothServiceListener, 1)) {
            Log.e((String)TAG, (String)"BluetoothAdapter.getProfileProxy(HEADSET) failed");
            return;
        }
        IntentFilter bluetoothHeadsetFilter = new IntentFilter();
        bluetoothHeadsetFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        bluetoothHeadsetFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        this.registerReceiver(this.bluetoothHeadsetReceiver, bluetoothHeadsetFilter);
        HMSLogger.d(TAG, "HEADSET profile state: " + this.stateToString(this.bluetoothAdapter.getProfileConnectionState(1)));
        HMSLogger.d(TAG, "Bluetooth proxy for headset profile has started");
        this.bluetoothState = State.HEADSET_UNAVAILABLE;
        HMSLogger.d(TAG, "start done: BT state=" + (Object)((Object)this.bluetoothState));
    }

    @MainThread
    public void stop() {
        HMSLogger.d(TAG, "stop: BT state=" + (Object)((Object)this.bluetoothState));
        if (this.bluetoothAdapter == null) {
            return;
        }
        this.stopScoAudio();
        if (this.bluetoothState == State.UNINITIALIZED) {
            return;
        }
        this.unregisterReceiver(this.bluetoothHeadsetReceiver);
        this.cancelTimer();
        if (this.bluetoothHeadset != null) {
            this.bluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.bluetoothHeadset);
            this.bluetoothHeadset = null;
        }
        this.bluetoothAdapter = null;
        this.bluetoothDevice = null;
        this.bluetoothState = State.UNINITIALIZED;
        HMSLogger.d(TAG, "stop done: BT state=" + (Object)((Object)this.bluetoothState));
    }

    @MainThread
    public boolean startScoAudio() {
        HMSLogger.d(TAG, "startSco: BT state=" + (Object)((Object)this.bluetoothState) + ", attempts: " + this.scoConnectionAttempts + ", SCO is on: " + this.isScoOn());
        if (this.scoConnectionAttempts >= 2) {
            HMSLogger.e(TAG, "BT SCO connection fails - no more attempts");
            return false;
        }
        if (this.bluetoothState != State.HEADSET_AVAILABLE) {
            HMSLogger.e(TAG, "BT SCO connection fails - no headset available");
            return false;
        }
        Log.d((String)TAG, (String)"Starting Bluetooth SCO and waits for ACTION_AUDIO_STATE_CHANGED...");
        this.bluetoothState = State.SCO_CONNECTING;
        this.audioManager.startBluetoothSco();
        this.audioManager.setBluetoothScoOn(true);
        ++this.scoConnectionAttempts;
        this.startTimer();
        Log.d((String)TAG, (String)("startScoAudio done: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn()));
        return true;
    }

    @MainThread
    public void stopScoAudio() {
        Log.d((String)TAG, (String)("stopScoAudio: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn()));
        if (this.bluetoothState != State.SCO_CONNECTING && this.bluetoothState != State.SCO_CONNECTED) {
            return;
        }
        this.cancelTimer();
        this.audioManager.stopBluetoothSco();
        this.audioManager.setBluetoothScoOn(false);
        this.bluetoothState = State.SCO_DISCONNECTING;
        Log.d((String)TAG, (String)("stopScoAudio done: BT state=" + (Object)((Object)this.bluetoothState) + ", SCO is on: " + this.isScoOn()));
    }

    public void updateDevice() {
        if (this.bluetoothState == State.UNINITIALIZED || this.bluetoothHeadset == null) {
            return;
        }
        Log.d((String)TAG, (String)"updateDevice");
        List devices = this.bluetoothHeadset.getConnectedDevices();
        if (devices.isEmpty()) {
            this.bluetoothDevice = null;
            this.bluetoothState = State.HEADSET_UNAVAILABLE;
            Log.d((String)TAG, (String)"No connected bluetooth headset");
        } else {
            this.bluetoothDevice = (BluetoothDevice)devices.get(0);
            this.bluetoothState = State.HEADSET_AVAILABLE;
            Log.d((String)TAG, (String)("Connected bluetooth headset: name=" + this.bluetoothDevice.getName() + ", state=" + this.stateToString(this.bluetoothHeadset.getConnectionState(this.bluetoothDevice)) + ", SCO audio=" + this.bluetoothHeadset.isAudioConnected(this.bluetoothDevice)));
        }
        Log.d((String)TAG, (String)("updateDevice done: BT state=" + (Object)((Object)this.bluetoothState)));
    }

    @Nullable
    protected AudioManager getAudioManager(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    protected void registerReceiver(BroadcastReceiver receiver, IntentFilter filter2) {
        this.HMSContext.registerReceiver(receiver, filter2);
    }

    protected void unregisterReceiver(BroadcastReceiver receiver) {
        this.HMSContext.unregisterReceiver(receiver);
    }

    protected boolean getBluetoothProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        return this.bluetoothAdapter.getProfileProxy(context, listener, profile);
    }

    @RequiresApi(api=23)
    protected boolean hasAndroid12Permissions(Context context) {
        return context.checkSelfPermission("android.permission.BLUETOOTH_CONNECT") == 0;
    }

    protected boolean isDeviceAndroid12AndAbove() {
        return Build.VERSION.SDK_INT > 30;
    }

    protected boolean hasPermission(Context context, String permission2) {
        return this.HMSContext.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    @SuppressLint(value={"HardwareIds"})
    protected void logBluetoothAdapterInfo(BluetoothAdapter localAdapter) {
        Log.d((String)TAG, (String)("BluetoothAdapter: enabled=" + localAdapter.isEnabled() + ", state=" + this.stateToString(localAdapter.getState()) + ", name=" + localAdapter.getName() + ", address=" + localAdapter.getAddress()));
        Set pairedDevices = localAdapter.getBondedDevices();
        if (!pairedDevices.isEmpty()) {
            Log.d((String)TAG, (String)"paired devices:");
            for (BluetoothDevice device : pairedDevices) {
                Log.d((String)TAG, (String)(" name=" + device.getName() + ", address=" + device.getAddress()));
            }
        }
    }

    @MainThread
    private void updateAudioDeviceState() {
        Log.d((String)TAG, (String)"updateAudioDeviceState");
        this.hmsAudioManager.updateAudioDeviceState();
    }

    @MainThread
    private void startTimer() {
        Log.d((String)TAG, (String)"startTimer");
        this.handler.postDelayed(this.bluetoothTimeoutRunnable, 4000L);
    }

    @MainThread
    private void cancelTimer() {
        Log.d((String)TAG, (String)"cancelTimer");
        this.handler.removeCallbacks(this.bluetoothTimeoutRunnable);
    }

    @MainThread
    private void bluetoothTimeout() {
        if (this.bluetoothState == State.UNINITIALIZED || this.bluetoothHeadset == null) {
            return;
        }
        Log.d((String)TAG, (String)("bluetoothTimeout: BT state=" + (Object)((Object)this.bluetoothState) + ", attempts: " + this.scoConnectionAttempts + ", SCO is on: " + this.isScoOn()));
        if (this.bluetoothState != State.SCO_CONNECTING) {
            return;
        }
        boolean scoConnected = false;
        List devices = this.bluetoothHeadset.getConnectedDevices();
        if (devices.size() > 0) {
            this.bluetoothDevice = (BluetoothDevice)devices.get(0);
            if (this.bluetoothHeadset.isAudioConnected(this.bluetoothDevice)) {
                Log.d((String)TAG, (String)("SCO connected with " + this.bluetoothDevice.getName()));
                scoConnected = true;
            } else {
                Log.d((String)TAG, (String)("SCO is not connected with " + this.bluetoothDevice.getName()));
            }
        }
        if (scoConnected) {
            this.bluetoothState = State.SCO_CONNECTED;
            this.scoConnectionAttempts = 0;
        } else {
            Log.w((String)TAG, (String)"BT failed to connect after timeout");
            this.stopScoAudio();
        }
        this.updateAudioDeviceState();
        Log.d((String)TAG, (String)("bluetoothTimeout done: BT state=" + (Object)((Object)this.bluetoothState)));
    }

    private boolean isScoOn() {
        return this.audioManager.isBluetoothScoOn();
    }

    private String stateToString(int state2) {
        switch (state2) {
            case 0: {
                return "DISCONNECTED";
            }
            case 2: {
                return "CONNECTED";
            }
            case 1: {
                return "CONNECTING";
            }
            case 3: {
                return "DISCONNECTING";
            }
            case 10: {
                return "OFF";
            }
            case 12: {
                return "ON";
            }
            case 13: {
                return "TURNING_OFF";
            }
            case 11: {
                return "TURNING_ON";
            }
        }
        return "INVALID";
    }

    private class BluetoothHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private BluetoothHeadsetBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (HMSBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            String action = intent.getAction();
            if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                int state2 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                Log.d((String)HMSBluetoothManager.TAG, (String)("BluetoothHeadsetBroadcastReceiver.onReceive: a=ACTION_CONNECTION_STATE_CHANGED, s=" + HMSBluetoothManager.this.stateToString(state2) + ", sb=" + this.isInitialStickyBroadcast() + ", BT state: " + (Object)((Object)HMSBluetoothManager.this.bluetoothState)));
                if (state2 == 2) {
                    HMSBluetoothManager.this.scoConnectionAttempts = 0;
                    HMSBluetoothManager.this.updateAudioDeviceState();
                } else if (state2 != 1 && state2 != 3 && state2 == 0) {
                    HMSBluetoothManager.this.stopScoAudio();
                    HMSBluetoothManager.this.updateAudioDeviceState();
                }
            } else if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                int state3 = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 10);
                Log.d((String)HMSBluetoothManager.TAG, (String)("BluetoothHeadsetBroadcastReceiver.onReceive: a=ACTION_AUDIO_STATE_CHANGED, s=" + HMSBluetoothManager.this.stateToString(state3) + ", sb=" + this.isInitialStickyBroadcast() + ", BT state: " + (Object)((Object)HMSBluetoothManager.this.bluetoothState)));
                if (state3 == 12) {
                    HMSBluetoothManager.this.cancelTimer();
                    if (HMSBluetoothManager.this.bluetoothState == State.SCO_CONNECTING) {
                        HMSLogger.d(HMSBluetoothManager.TAG, "+++ Bluetooth audio SCO is now connected");
                        HMSBluetoothManager.this.bluetoothState = State.SCO_CONNECTED;
                        HMSBluetoothManager.this.scoConnectionAttempts = 0;
                        HMSBluetoothManager.this.updateAudioDeviceState();
                    } else {
                        Log.w((String)HMSBluetoothManager.TAG, (String)"Unexpected state BluetoothHeadset.STATE_AUDIO_CONNECTED");
                    }
                } else if (state3 == 11) {
                    Log.d((String)HMSBluetoothManager.TAG, (String)"+++ Bluetooth audio SCO is now connecting...");
                } else if (state3 == 10) {
                    Log.d((String)HMSBluetoothManager.TAG, (String)("+++ Bluetooth audio SCO is now disconnectedCurrent state is: " + (Object)((Object)HMSBluetoothManager.this.getState())));
                    HMSBluetoothManager.this.bluetoothState = State.SCO_DISCONNECTING;
                    if (this.isInitialStickyBroadcast()) {
                        Log.d((String)HMSBluetoothManager.TAG, (String)"Ignore STATE_AUDIO_DISCONNECTED initial sticky broadcast.");
                        return;
                    }
                    HMSBluetoothManager.this.updateAudioDeviceState();
                }
            }
            HMSLogger.d(HMSBluetoothManager.TAG, "onReceive done: BT state=" + (Object)((Object)HMSBluetoothManager.this.bluetoothState));
        }
    }

    private class BluetoothServiceListener
    implements BluetoothProfile.ServiceListener {
        private BluetoothServiceListener() {
        }

        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            if (profile != 1 || HMSBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            HMSLogger.d(HMSBluetoothManager.TAG, "BluetoothServiceListener.onServiceConnected: BT state=" + (Object)((Object)HMSBluetoothManager.this.bluetoothState));
            HMSBluetoothManager.this.bluetoothHeadset = (BluetoothHeadset)proxy;
            HMSBluetoothManager.this.updateAudioDeviceState();
            HMSLogger.d(HMSBluetoothManager.TAG, "onServiceConnected done: BT state=" + (Object)((Object)HMSBluetoothManager.this.bluetoothState));
        }

        public void onServiceDisconnected(int profile) {
            if (profile != 1 || HMSBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            HMSLogger.d(HMSBluetoothManager.TAG, "BluetoothServiceListener.onServiceDisconnected: BT state=" + (Object)((Object)HMSBluetoothManager.this.bluetoothState));
            HMSBluetoothManager.this.stopScoAudio();
            HMSBluetoothManager.this.bluetoothHeadset = null;
            HMSBluetoothManager.this.bluetoothDevice = null;
            HMSBluetoothManager.this.bluetoothState = State.HEADSET_UNAVAILABLE;
            HMSBluetoothManager.this.updateAudioDeviceState();
            HMSLogger.d(HMSBluetoothManager.TAG, "onServiceDisconnected done: BT state=" + (Object)((Object)HMSBluetoothManager.this.bluetoothState));
        }
    }

    public static enum State {
        UNINITIALIZED,
        ERROR,
        HEADSET_UNAVAILABLE,
        HEADSET_AVAILABLE,
        SCO_DISCONNECTING,
        SCO_CONNECTING,
        SCO_CONNECTED;

    }
}

