/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.utils;

import android.util.Base64;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.SerializedName;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import live.hms.video.error.ErrorFactory;
import live.hms.video.utils.GsonUtils;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Llive/hms/video/utils/AuthTokenUtils;", "", "()V", "TAG", "", "getJWTPayload", "Llive/hms/video/utils/AuthTokenUtils$AuthToken;", "token", "AuthToken", "lib_release"})
public final class AuthTokenUtils {
    @NotNull
    public static final AuthTokenUtils INSTANCE = new AuthTokenUtils();
    @NotNull
    private static final String TAG = "AuthTokenUtils";

    private AuthTokenUtils() {
    }

    @NotNull
    public final AuthToken getJWTPayload(@NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        HMSLogger.d(TAG, Intrinsics.stringPlus((String)"getJWTPayload: token=", (Object)token));
        CharSequence charSequence = token;
        if (charSequence.length() == 0) {
            throw ErrorFactory.InitAPIErrors.InvalidTokenFormat$default(ErrorFactory.InitAPIErrors.INSTANCE, ErrorFactory.Action.INIT, "Token cannot be an empty string", null, null, 12, null);
        }
        String[] stringArray = new String[]{"."};
        List parts = StringsKt.split$default((CharSequence)token, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (parts.size() != 3) {
            ErrorFactory.InitAPIErrors.InvalidTokenFormat$default(ErrorFactory.InitAPIErrors.INSTANCE, ErrorFactory.Action.INIT, "Expected 3 '.' separate fields - header, payload and signature respectively", null, null, 12, null);
        }
        try {
            byte[] payloadBytes = Base64.decode((String)((String)parts.get(1)), (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)payloadBytes, (String)"payloadBytes");
            Object object = payloadBytes;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            String payloadStr = new String((byte[])object, charset);
            object = GsonUtils.INSTANCE.getGson().fromJson(payloadStr, AuthToken.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"GsonUtils.gson.fromJson(payloadStr, AuthToken::class.java)");
            return (AuthToken)object;
        }
        catch (JsonSyntaxException ex) {
            HMSLogger.INSTANCE.e(TAG, "Error parsing json", ex);
            throw ErrorFactory.InitAPIErrors.InvalidTokenFormat$default(ErrorFactory.InitAPIErrors.INSTANCE, ErrorFactory.Action.INIT, "Token is missing room id", null, null, 12, null);
        }
        catch (Exception ex) {
            HMSLogger.INSTANCE.e(TAG, "Error not parsing json", ex);
            String string = ex.getMessage();
            throw ErrorFactory.InitAPIErrors.InvalidTokenFormat$default(ErrorFactory.InitAPIErrors.INSTANCE, ErrorFactory.Action.INIT, string == null ? "" : string, null, null, 12, null);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0016\u0010\u0005\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0016\u0010\u0004\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0015"}, d2={"Llive/hms/video/utils/AuthTokenUtils$AuthToken;", "", "roomId", "", "userId", "role", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getRole", "()Ljava/lang/String;", "getRoomId", "getUserId", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "lib_release"})
    public static final class AuthToken {
        @SerializedName(value="room_id")
        @NotNull
        private final String roomId;
        @SerializedName(value="user_id")
        @NotNull
        private final String userId;
        @SerializedName(value="role")
        @NotNull
        private final String role;

        public AuthToken(@NotNull String roomId, @NotNull String userId, @NotNull String role) {
            Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            this.roomId = roomId;
            this.userId = userId;
            this.role = role;
        }

        @NotNull
        public final String getRoomId() {
            return this.roomId;
        }

        @NotNull
        public final String getUserId() {
            return this.userId;
        }

        @NotNull
        public final String getRole() {
            return this.role;
        }

        @NotNull
        public final String component1() {
            return this.roomId;
        }

        @NotNull
        public final String component2() {
            return this.userId;
        }

        @NotNull
        public final String component3() {
            return this.role;
        }

        @NotNull
        public final AuthToken copy(@NotNull String roomId, @NotNull String userId, @NotNull String role) {
            Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
            Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
            Intrinsics.checkNotNullParameter((Object)role, (String)"role");
            return new AuthToken(roomId, userId, role);
        }

        public static /* synthetic */ AuthToken copy$default(AuthToken authToken, String string, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = authToken.roomId;
            }
            if ((n & 2) != 0) {
                string2 = authToken.userId;
            }
            if ((n & 4) != 0) {
                string3 = authToken.role;
            }
            return authToken.copy(string, string2, string3);
        }

        @NotNull
        public String toString() {
            return "AuthToken(roomId=" + this.roomId + ", userId=" + this.userId + ", role=" + this.role + ')';
        }

        public int hashCode() {
            int result2 = this.roomId.hashCode();
            result2 = result2 * 31 + this.userId.hashCode();
            result2 = result2 * 31 + this.role.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AuthToken)) {
                return false;
            }
            AuthToken authToken = (AuthToken)other;
            if (!Intrinsics.areEqual((Object)this.roomId, (Object)authToken.roomId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.userId, (Object)authToken.userId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.role, (Object)authToken.role);
        }
    }
}

