/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.streams;

import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import live.hms.video.connection.publish.HMSPublishConnection;
import live.hms.video.media.streams.HMSMediaStream;
import live.hms.video.media.tracks.HMSLocalAudioTrack;
import live.hms.video.media.tracks.HMSLocalVideoTrack;
import live.hms.video.media.tracks.HMSTrack;
import live.hms.video.media.tracks.HMSTrackType;
import live.hms.video.utils.HMSLogger;
import org.jetbrains.annotations.NotNull;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.RtpParameters;
import org.webrtc.RtpSender;
import org.webrtc.RtpTransceiver;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Llive/hms/video/media/streams/HMSLocalStream;", "Llive/hms/video/media/streams/HMSMediaStream;", "nativeStream", "Lorg/webrtc/MediaStream;", "(Lorg/webrtc/MediaStream;)V", "addTransceiver", "Lorg/webrtc/RtpTransceiver;", "connection", "Llive/hms/video/connection/publish/HMSPublishConnection;", "track", "Llive/hms/video/media/tracks/HMSTrack;", "removeSender", "", "Companion", "lib_release"})
public final class HMSLocalStream
extends HMSMediaStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "HMSLocalStream";

    public HMSLocalStream(@NotNull MediaStream nativeStream) {
        Intrinsics.checkNotNullParameter((Object)nativeStream, (String)"nativeStream");
        super(nativeStream);
    }

    @NotNull
    public final RtpTransceiver addTransceiver(@NotNull HMSPublishConnection connection, @NotNull HMSTrack track) {
        List list;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        if (track.getType() == HMSTrackType.VIDEO) {
            RtpParameters.Encoding videoEncoding = new RtpParameters.Encoding(null, true, null);
            videoEncoding.bitratePriority = 1.0;
            videoEncoding.maxBitrateBps = ((HMSLocalVideoTrack)track).getSettings().getMaxBitRate() * 1000;
            videoEncoding.maxFramerate = ((HMSLocalVideoTrack)track).getSettings().getMaxFrameRate();
            list = CollectionsKt.listOf((Object)videoEncoding);
        } else {
            RtpParameters.Encoding audioEncoding = new RtpParameters.Encoding(null, true, null);
            audioEncoding.bitratePriority = 2.0;
            audioEncoding.maxBitrateBps = ((HMSLocalAudioTrack)track).getSettings().getMaxBitrate() * 1000;
            list = CollectionsKt.listOf((Object)audioEncoding);
        }
        List sendEncodings = list;
        RtpTransceiver.RtpTransceiverInit init = new RtpTransceiver.RtpTransceiverInit(RtpTransceiver.RtpTransceiverDirection.SEND_ONLY, CollectionsKt.listOf((Object)this.getNativeStream().getId()), sendEncodings);
        RtpTransceiver transceiver = connection.addTransceiver(track.getNativeTrack$lib_release(), init);
        HMSLogger.d(TAG, "[streamId=" + this.getNativeStream().getId() + "] publishTrack trackId=" + track.getTrackId() + " kind=" + (Object)((Object)track.getType()) + " sendEncodings=" + sendEncodings + ", Added transceiver: mid=" + transceiver.getMid());
        return transceiver;
    }

    public final void removeSender(@NotNull HMSPublishConnection connection, @NotNull HMSTrack track) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)track, (String)"track");
        Iterable $this$forEach$iv = connection.getSenders();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RtpSender sender = (RtpSender)element$iv;
            boolean bl = false;
            sender.getParameters();
            MediaStreamTrack senderTrack = sender.track();
            if (senderTrack == null || !senderTrack.id().equals(track.getNativeTrack$lib_release().id())) continue;
            connection.removeTrack(sender);
            boolean removedLocalReference = this.getTracks().remove(track);
            if (!removedLocalReference) {
                throw new IllegalStateException("Cannot find " + track + " in locally stored tracks");
            }
            return;
        }
        HMSLogger.e(TAG, Intrinsics.stringPlus((String)"Cannot find sender track in streamId=", (Object)this.getId()));
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Llive/hms/video/media/streams/HMSLocalStream$Companion;", "", "()V", "TAG", "", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

