/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.media.tracks;

import android.content.Context;
import android.util.AndroidException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableDeferred;
import kotlinx.coroutines.CompletableDeferredKt;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import live.hms.video.media.tracks.HMSCapturer;
import live.hms.video.media.tracks.HMSVideoCapturer;
import live.hms.video.sdk.HMSActionResultListener;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.HmsCameraEnumerator;
import live.hms.video.utils.SharedEglContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;
import org.webrtc.Size;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoSource;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 32\u00020\u0001:\u00013B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001eH\u0002J\u0018\u0010!\u001a\n \"*\u0004\u0018\u00010\u000e0\u000e2\b\b\u0002\u0010#\u001a\u00020\u0010J\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\u001c0\u001eJ\u0006\u0010%\u001a\u00020\u0018J\u001b\u0010&\u001a\u00020\u001a2\u0006\u0010'\u001a\u00020\u0007H\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0004\b(\u0010)J\b\u0010*\u001a\u00020\u001aH\u0016J\b\u0010+\u001a\u00020\u001aH\u0016J#\u0010,\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020\u000e2\b\u0010.\u001a\u0004\u0018\u00010/H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J#\u0010,\u001a\u00020\u001a2\u0006\u0010#\u001a\u00020\u00102\b\u0010.\u001a\u0004\u0018\u00010/H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00101J\u001b\u0010,\u001a\u00020\u001a2\b\u0010.\u001a\u0004\u0018\u00010/H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00064"}, d2={"Llive/hms/video/media/tracks/HMSVideoCapturer;", "Llive/hms/video/media/tracks/HMSCapturer;", "context", "Landroid/content/Context;", "source", "Lorg/webrtc/VideoSource;", "settings", "Llive/hms/video/media/settings/HMSVideoTrackSettings;", "analyticsEventsService", "Llive/hms/video/events/AnalyticsEventsService;", "(Landroid/content/Context;Lorg/webrtc/VideoSource;Llive/hms/video/media/settings/HMSVideoTrackSettings;Llive/hms/video/events/AnalyticsEventsService;)V", "capturer", "Lorg/webrtc/CameraVideoCapturer;", "currentCameraDeviceId", "", "currentCameraFace", "Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;", "enumerator", "Lorg/webrtc/CameraEnumerator;", "getSource", "()Lorg/webrtc/VideoSource;", "setSource", "(Lorg/webrtc/VideoSource;)V", "surTexture", "Lorg/webrtc/SurfaceTextureHelper;", "changeInputFps", "", "fps", "", "getClosestSizeAndFps", "Lkotlin/Pair;", "Lorg/webrtc/Size;", "Lorg/webrtc/CameraEnumerationAndroid$CaptureFormat$FramerateRange;", "getDeviceId", "kotlin.jvm.PlatformType", "face", "getInputResolution", "getSurfaceTexture", "setSettings", "newSettings", "setSettings$lib_release", "(Llive/hms/video/media/settings/HMSVideoTrackSettings;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "start", "stop", "switchCamera", "deviceId", "onAction", "Llive/hms/video/sdk/HMSActionResultListener;", "(Ljava/lang/String;Llive/hms/video/sdk/HMSActionResultListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Llive/hms/video/media/settings/HMSVideoTrackSettings$CameraFacing;Llive/hms/video/sdk/HMSActionResultListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "(Llive/hms/video/sdk/HMSActionResultListener;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "lib_release"})
public final class HMSVideoCapturer
implements HMSCapturer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private VideoSource source;
    @NotNull
    private HMSVideoTrackSettings settings;
    @NotNull
    private final AnalyticsEventsService analyticsEventsService;
    @NotNull
    private final CameraVideoCapturer capturer;
    @NotNull
    private final SurfaceTextureHelper surTexture;
    @NotNull
    private final CameraEnumerator enumerator;
    @NotNull
    private String currentCameraDeviceId;
    @NotNull
    private HMSVideoTrackSettings.CameraFacing currentCameraFace;
    @NotNull
    public static final String TAG = "HMSVideoCapturer";
    @NotNull
    private static final String LOCAL_CAMERA_CAPTURER_THREAD = "local-camera-capturer-thread";

    public HMSVideoCapturer(@NotNull Context context, @NotNull VideoSource source, @NotNull HMSVideoTrackSettings settings, @NotNull AnalyticsEventsService analyticsEventsService) {
        HMSVideoTrackSettings.CameraFacing cameraFacing;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService, (String)"analyticsEventsService");
        this.source = source;
        this.settings = settings;
        this.analyticsEventsService = analyticsEventsService;
        Object object = SurfaceTextureHelper.create((String)LOCAL_CAMERA_CAPTURER_THREAD, (EglBase.Context)SharedEglContext.INSTANCE.getContext());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"create(\n    LOCAL_CAMERA_CAPTURER_THREAD,\n    SharedEglContext.context\n  )");
        this.surTexture = object;
        this.enumerator = Camera2Enumerator.isSupported((Context)context) ? (CameraEnumerator)new HmsCameraEnumerator(context) : (CameraEnumerator)new Camera1Enumerator(false);
        object = HMSVideoCapturer.getDeviceId$default(this, null, 1, null);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDeviceId()");
        this.currentCameraDeviceId = object;
        boolean bl = this.enumerator.isFrontFacing(this.currentCameraDeviceId);
        if (bl) {
            cameraFacing = HMSVideoTrackSettings.CameraFacing.FRONT;
        } else if (!bl) {
            cameraFacing = HMSVideoTrackSettings.CameraFacing.BACK;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        this.currentCameraFace = cameraFacing;
        CameraVideoCapturer cameraVideoCapturer = this.enumerator.createCapturer(this.currentCameraDeviceId, new CameraVideoCapturer.CameraEventsHandler(){
            @NotNull
            private final String logPrefix;
            {
                this.logPrefix = "DeviceName=" + currentCameraDeviceId + " CameraVideoCapturer.CameraEventsHandler.";
            }

            @NotNull
            public final String getLogPrefix() {
                return this.logPrefix;
            }

            public void onCameraError(@Nullable String errorDescription) {
                HMSLogger.e(HMSVideoCapturer.TAG, this.logPrefix + "onCameraError: " + errorDescription);
            }

            public void onCameraDisconnected() {
                HMSLogger.d(HMSVideoCapturer.TAG, Intrinsics.stringPlus((String)this.logPrefix, (Object)"onCameraDisconnected"));
            }

            public void onCameraFreezed(@Nullable String errorDescription) {
                HMSLogger.d(HMSVideoCapturer.TAG, this.logPrefix + "onCameraFreezed: " + errorDescription);
            }

            public void onCameraOpening(@Nullable String cameraName) {
                HMSLogger.d(HMSVideoCapturer.TAG, this.logPrefix + "onCameraOpening: " + cameraName);
            }

            public void onFirstFrameAvailable() {
                HMSLogger.d(HMSVideoCapturer.TAG, Intrinsics.stringPlus((String)this.logPrefix, (Object)"onFirstFrameAvailable"));
            }

            public void onCameraClosed() {
                HMSLogger.d(HMSVideoCapturer.TAG, Intrinsics.stringPlus((String)this.logPrefix, (Object)"onCameraClosed"));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)cameraVideoCapturer, (String)"enumerator.createCapturer(\n      currentCameraDeviceId,\n      object : CameraVideoCapturer.CameraEventsHandler {\n        val logPrefix = \"DeviceName=$currentCameraDeviceId CameraVideoCapturer.CameraEventsHandler.\"\n\n        override fun onCameraError(errorDescription: String?) {\n          // TODO: Raise an error?\n          HMSLogger.e(TAG, \"${logPrefix}onCameraError: $errorDescription\")\n        }\n\n        override fun onCameraDisconnected() {\n          HMSLogger.d(TAG, \"${logPrefix}onCameraDisconnected\")\n        }\n\n        override fun onCameraFreezed(errorDescription: String?) {\n          HMSLogger.d(TAG, \"${logPrefix}onCameraFreezed: $errorDescription\")\n        }\n\n        override fun onCameraOpening(cameraName: String?) {\n          HMSLogger.d(TAG, \"${logPrefix}onCameraOpening: $cameraName\")\n        }\n\n        override fun onFirstFrameAvailable() {\n          HMSLogger.d(TAG, \"${logPrefix}onFirstFrameAvailable\")\n        }\n\n        override fun onCameraClosed() {\n          HMSLogger.d(TAG, \"${logPrefix}onCameraClosed\")\n        }\n      })");
        this.capturer = cameraVideoCapturer;
        this.capturer.initialize(this.surTexture, context, this.source.getCapturerObserver());
    }

    @NotNull
    public final VideoSource getSource() {
        return this.source;
    }

    public final void setSource(@NotNull VideoSource videoSource) {
        Intrinsics.checkNotNullParameter((Object)videoSource, (String)"<set-?>");
        this.source = videoSource;
    }

    @Nullable
    public final Object setSettings$lib_release(@NotNull HMSVideoTrackSettings newSettings, @NotNull Continuation<? super Unit> $completion) {
        HMSVideoTrackSettings previousSettings = this.settings;
        this.settings = newSettings;
        if (!Intrinsics.areEqual((Object)newSettings.getResolution(), (Object)previousSettings.getResolution()) || newSettings.getMaxFrameRate() != previousSettings.getMaxFrameRate()) {
            Pair<Size, CameraEnumerationAndroid.CaptureFormat.FramerateRange> config = this.getClosestSizeAndFps();
            Size size = (Size)config.getFirst();
            CameraEnumerationAndroid.CaptureFormat.FramerateRange fpsRange = (CameraEnumerationAndroid.CaptureFormat.FramerateRange)config.getSecond();
            this.capturer.changeCaptureFormat(size.width, size.height, fpsRange.max);
        }
        if (newSettings.getCameraFacing() != previousSettings.getCameraFacing()) {
            Object object = this.switchCamera(newSettings.getCameraFacing(), null, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object switchCamera(@Nullable HMSActionResultListener onAction, @NotNull Continuation<? super Unit> $completion) {
        HMSVideoTrackSettings.CameraFacing cameraFacing;
        HMSVideoTrackSettings.CameraFacing cameraFacing2 = this.currentCameraFace;
        int n = WhenMappings.$EnumSwitchMapping$0[cameraFacing2.ordinal()];
        switch (n) {
            case 1: {
                cameraFacing = HMSVideoTrackSettings.CameraFacing.BACK;
                break;
            }
            case 2: {
                cameraFacing = HMSVideoTrackSettings.CameraFacing.FRONT;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        HMSVideoTrackSettings.CameraFacing newFace = cameraFacing;
        Object object = this.switchCamera(newFace, onAction, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object switchCamera(@NotNull HMSVideoTrackSettings.CameraFacing var1_1, @Nullable HMSActionResultListener var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof switchCamera.2)) ** GOTO lbl-1000
        var6_4 = var3_3;
        if ((var6_4.label & -2147483648) != 0) {
            var6_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                final /* synthetic */ HMSVideoCapturer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.switchCamera((HMSVideoTrackSettings.CameraFacing)null, (HMSActionResultListener)null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                deviceId = this.getDeviceId(face);
                Intrinsics.checkNotNullExpressionValue((Object)deviceId, (String)"deviceId");
                $continuation.L$0 = this;
                $continuation.L$1 = face;
                $continuation.L$2 = deviceId;
                $continuation.label = 1;
                v0 = this.switchCamera(deviceId, (HMSActionResultListener)onAction, (Continuation<? super Unit>)$continuation);
                if (v0 == var7_6) {
                    return var7_6;
                }
                ** GOTO lbl28
            }
            case 1: {
                deviceId = (String)$continuation.L$2;
                face = (HMSVideoTrackSettings.CameraFacing)$continuation.L$1;
                this = (HMSVideoCapturer)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                this.currentCameraFace = face;
                Intrinsics.checkNotNullExpressionValue((Object)deviceId, (String)"deviceId");
                this.currentCameraDeviceId = deviceId;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object switchCamera(@NotNull String var1_1, @Nullable HMSActionResultListener var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof switchCamera.3)) ** GOTO lbl-1000
        var7_4 = var3_3;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var3_3){
                /* synthetic */ Object result;
                final /* synthetic */ HMSVideoCapturer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.switchCamera((String)null, (HMSActionResultListener)null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (Intrinsics.areEqual((Object)deviceId, (Object)this.currentCameraDeviceId)) {
                    HMSLogger.INSTANCE.w("HMSVideoCapturer", "switchCamera: Ignoring request to switch from " + this.currentCameraDeviceId + " -> " + (String)deviceId);
                    return Unit.INSTANCE;
                }
                deferred = CompletableDeferredKt.CompletableDeferred$default(null, (int)1, null);
                this.capturer.switchCamera(new CameraVideoCapturer.CameraSwitchHandler((HMSActionResultListener)onAction, (CompletableDeferred<String>)deferred){
                    final /* synthetic */ HMSActionResultListener $onAction;
                    final /* synthetic */ CompletableDeferred<String> $deferred;
                    {
                        this.$onAction = $onAction;
                        this.$deferred = $deferred;
                    }

                    public void onCameraSwitchDone(boolean isFrontCamera) {
                        HMSActionResultListener hMSActionResultListener = this.$onAction;
                        if (hMSActionResultListener != null) {
                            hMSActionResultListener.onSuccess();
                        }
                        this.$deferred.complete(null);
                    }

                    public void onCameraSwitchError(@NotNull String errorDescription) {
                        Intrinsics.checkNotNullParameter((Object)errorDescription, (String)"errorDescription");
                        HMSActionResultListener hMSActionResultListener = this.$onAction;
                        if (hMSActionResultListener != null) {
                            hMSActionResultListener.onError(ErrorFactory.TracksErrors.GenericTrack$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, errorDescription, null, null, 12, null));
                        }
                        this.$deferred.complete((Object)errorDescription);
                    }
                }, (String)deviceId);
                $continuation.label = 1;
                v0 = deferred.await((Continuation)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl25
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl25:
                // 2 sources

                if ((error = (String)v0) != null) {
                    HMSLogger.e("HMSVideoCapturer", Intrinsics.stringPlus((String)"Implement onAction to be made aware of these. ", (Object)error));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    public void start() {
        Pair<Size, CameraEnumerationAndroid.CaptureFormat.FramerateRange> config = this.getClosestSizeAndFps();
        Size size = (Size)config.getFirst();
        CameraEnumerationAndroid.CaptureFormat.FramerateRange fpsRange = (CameraEnumerationAndroid.CaptureFormat.FramerateRange)config.getSecond();
        this.capturer.startCapture(size.width, size.height, fpsRange.max);
    }

    @Override
    public void stop() {
        this.capturer.stopCapture();
    }

    public final String getDeviceId(@NotNull HMSVideoTrackSettings.CameraFacing face) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)face), (String)"face");
        try {
            Object element$iv;
            block8: {
                object = this.enumerator.getDeviceNames();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"enumerator.deviceNames");
                Object[] $this$first$iv = object;
                boolean $i$f$first = false;
                Object[] objectArray = $this$first$iv;
                int n = 0;
                int n2 = objectArray.length;
                while (n < n2) {
                    boolean bl;
                    element$iv = objectArray[n];
                    ++n;
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    HMSVideoTrackSettings.CameraFacing cameraFacing = face;
                    int n3 = WhenMappings.$EnumSwitchMapping$0[cameraFacing.ordinal()];
                    switch (n3) {
                        case 1: {
                            bl = this.enumerator.isFrontFacing(it);
                            break;
                        }
                        case 2: {
                            bl = this.enumerator.isBackFacing(it);
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    if (!bl) continue;
                    break block8;
                }
                throw new NoSuchElementException("Array contains no element matching the predicate.");
            }
            object = (String)element$iv;
        }
        catch (NoSuchElementException e) {
            HMSException videoPublishException = ErrorFactory.TracksErrors.CantAccessCaptureDevice$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, "camera", "No camera device found for " + (Object)((Object)face) + " among " + Arrays.toString(this.enumerator.getDeviceNames()), false, null, null, 56, null);
            this.analyticsEventsService.queue(AnalyticsEventFactory.INSTANCE.videoPublishFail(videoPublishException)).flush();
            throw videoPublishException;
        }
        catch (AndroidException e) {
            HMSException cameraCaptureException = ErrorFactory.TracksErrors.CantAccessCaptureDevice$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, "camera", String.valueOf(e.getMessage()), false, null, null, 48, null);
            this.analyticsEventsService.queue(AnalyticsEventFactory.INSTANCE.videoPublishFail(cameraCaptureException)).flush();
            throw cameraCaptureException;
        }
        return object;
    }

    public static /* synthetic */ String getDeviceId$default(HMSVideoCapturer hMSVideoCapturer, HMSVideoTrackSettings.CameraFacing cameraFacing, int n, Object object) {
        if ((n & 1) != 0) {
            cameraFacing = hMSVideoCapturer.settings.getCameraFacing();
        }
        return hMSVideoCapturer.getDeviceId(cameraFacing);
    }

    private final Pair<Size, CameraEnumerationAndroid.CaptureFormat.FramerateRange> getClosestSizeAndFps() {
        ArrayList<Size> sizes = new ArrayList<Size>();
        ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange> fpsRanges = new ArrayList<CameraEnumerationAndroid.CaptureFormat.FramerateRange>();
        List list = this.enumerator.getSupportedFormats(this.currentCameraDeviceId);
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"enumerator.getSupportedFormats(currentCameraDeviceId)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CameraEnumerationAndroid.CaptureFormat format = (CameraEnumerationAndroid.CaptureFormat)element$iv;
            boolean bl = false;
            sizes.add(new Size(format.width, format.height));
            fpsRanges.add(new CameraEnumerationAndroid.CaptureFormat.FramerateRange(format.framerate.min, format.framerate.max));
        }
        if (sizes.isEmpty() || fpsRanges.isEmpty()) {
            HMSException videoPublishException = ErrorFactory.TracksErrors.CantAccessCaptureDevice$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, "camera", "Camera occupied. Sizes was " + sizes + " and fpsRanges are " + fpsRanges + " both must be non-empty.", false, null, null, 56, null);
            this.analyticsEventsService.queue(AnalyticsEventFactory.INSTANCE.videoPublishFail(videoPublishException)).flush();
            throw videoPublishException;
        }
        HMSLogger.d(TAG, "[Device=" + this.currentCameraDeviceId + "] Supported Sizes: " + sizes);
        HMSLogger.d(TAG, "[Device=" + this.currentCameraDeviceId + "] Supported FrameRate Ranges: " + fpsRanges);
        Size closestSize = CameraEnumerationAndroid.getClosestSupportedSize((List)sizes, (int)this.settings.getResolution().getWidth(), (int)this.settings.getResolution().getHeight());
        CameraEnumerationAndroid.CaptureFormat.FramerateRange closesFpsRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange((List)fpsRanges, (int)this.settings.getMaxFrameRate());
        HMSLogger.d(TAG, "[Device=" + this.currentCameraDeviceId + "] Using Size=" + closestSize + " FrameRate Range=" + closesFpsRange);
        return new Pair((Object)closestSize, (Object)closesFpsRange);
    }

    @NotNull
    public final SurfaceTextureHelper getSurfaceTexture() {
        return this.surTexture;
    }

    @NotNull
    public final Pair<Size, Integer> getInputResolution() {
        return new Pair((Object)new Size(this.settings.getResolution().getWidth(), this.settings.getResolution().getHeight()), (Object)this.settings.getMaxFrameRate());
    }

    public final void changeInputFps(int fps) {
        this.capturer.changeCaptureFormat(this.settings.getResolution().getWidth(), this.settings.getResolution().getHeight(), fps);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Llive/hms/video/media/tracks/HMSVideoCapturer$Companion;", "", "()V", "LOCAL_CAMERA_CAPTURER_THREAD", "", "TAG", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HMSVideoTrackSettings.CameraFacing.values().length];
            nArray[HMSVideoTrackSettings.CameraFacing.FRONT.ordinal()] = 1;
            nArray[HMSVideoTrackSettings.CameraFacing.BACK.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

