/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.services;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationCompat;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import live.hms.video.media.settings.HMSVideoTrackSettings;
import live.hms.video.utils.HMSCoroutineScope;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.HMSUtils;
import live.hms.video.utils.SharedEglContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.CapturerObserver;
import org.webrtc.EglBase;
import org.webrtc.ScreenCapturerAndroid;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSource;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 &2\u00020\u0001:\u0002&'B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0014H\u0003J\u0012\u0010\u0018\u001a\u00020\u00102\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\"\u0010\u001c\u001a\u00020\u00122\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u0012H\u0016J \u0010\u001f\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010\u001a2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u0006\u0010%\u001a\u00020\u0014R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Llive/hms/video/services/HMSScreenCaptureService;", "Landroid/app/Service;", "()V", "TAG", "", "kotlin.jvm.PlatformType", "capturer", "Lorg/webrtc/ScreenCapturerAndroid;", "customerNotification", "Landroid/app/Notification;", "endFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "", "getEndFlow", "()Lkotlinx/coroutines/flow/MutableSharedFlow;", "mBinder", "Landroid/os/IBinder;", "oldOrientation", "", "checkForOrientationChange", "", "frame", "Lorg/webrtc/VideoFrame;", "createNotificationChannel", "onBind", "intent", "Landroid/content/Intent;", "onDestroy", "onStartCommand", "flags", "startId", "startCapture", "mediaProjectionPermissionResultData", "hmsVideoTrackSettings", "Llive/hms/video/media/settings/HMSVideoTrackSettings;", "source", "Lorg/webrtc/VideoSource;", "stopCapturer", "Companion", "LocalBinder", "lib_release"})
public final class HMSScreenCaptureService
extends Service {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final String TAG = HMSScreenCaptureService.class.getSimpleName();
    private ScreenCapturerAndroid capturer;
    @NotNull
    private final IBinder mBinder = (IBinder)new LocalBinder();
    @Nullable
    private Notification customerNotification;
    @NotNull
    private final MutableSharedFlow<Boolean> endFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)0, null, (int)7, null);
    private int oldOrientation;
    private static final int SERVICE_ID = 123;
    @NotNull
    private static final String NOTIFICATION_CHANNEL_ID = "ScreenCapture channel";
    @NotNull
    public static final String ACTION_START = "AudioCaptureService:Start";
    @NotNull
    public static final String ACTION_STOP = "AudioCaptureService:Stop";
    @NotNull
    public static final String LOCAL_SCREEN_CAPTURER_THREAD = "local-screen-capturer-thread";
    @NotNull
    public static final String PERMISSION_RESULT_DATA = "permission_result_data";
    @NotNull
    public static final String SCREEN_WIDTH = "screen_width";
    @NotNull
    public static final String SCREEN_HEIGHT = "screen_height";

    @NotNull
    public final MutableSharedFlow<Boolean> getEndFlow() {
        return this.endFlow;
    }

    @RequiresApi(value=26)
    private final void createNotificationChannel() {
        String string;
        Notification notification = this.customerNotification;
        NotificationChannel serviceChannel = new NotificationChannel(notification == null ? NOTIFICATION_CHANNEL_ID : ((string = notification.getChannelId()) == null ? NOTIFICATION_CHANNEL_ID : string), (CharSequence)"Screen Capture Service Channel", 3);
        NotificationManager manager = (NotificationManager)this.getApplicationContext().getSystemService(NotificationManager.class);
        manager.createNotificationChannel(serviceChannel);
    }

    public final void startCapture(@Nullable Intent mediaProjectionPermissionResultData, @NotNull HMSVideoTrackSettings hmsVideoTrackSettings, @NotNull VideoSource source) {
        Intrinsics.checkNotNullParameter((Object)hmsVideoTrackSettings, (String)"hmsVideoTrackSettings");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        ScreenCapturerAndroid screenCapturerAndroid = this.capturer = new ScreenCapturerAndroid(mediaProjectionPermissionResultData, new MediaProjection.Callback(){

            public void onStop() {
                HMSLogger.e("HMSScreenCapturer", "onstop of screen capturer");
            }
        });
        if (screenCapturerAndroid == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"capturer");
            throw null;
        }
        screenCapturerAndroid.initialize(SurfaceTextureHelper.create((String)LOCAL_SCREEN_CAPTURER_THREAD, (EglBase.Context)SharedEglContext.INSTANCE.getContext()), this.getApplicationContext(), new CapturerObserver(source, this){
            final /* synthetic */ VideoSource $source;
            final /* synthetic */ HMSScreenCaptureService this$0;
            {
                this.$source = $source;
                this.this$0 = $receiver;
            }

            public void onCapturerStarted(boolean success) {
                this.$source.getCapturerObserver().onCapturerStarted(success);
            }

            public void onCapturerStopped() {
                this.$source.getCapturerObserver().onCapturerStopped();
            }

            public void onFrameCaptured(@Nullable VideoFrame frame) {
                this.$source.getCapturerObserver().onFrameCaptured(frame);
                VideoFrame videoFrame = frame;
                if (videoFrame != null) {
                    VideoFrame videoFrame2 = videoFrame;
                    HMSScreenCaptureService hMSScreenCaptureService = this.this$0;
                    VideoFrame it = videoFrame2;
                    boolean bl = false;
                    HMSScreenCaptureService.access$checkForOrientationChange(hMSScreenCaptureService, it);
                }
            }
        });
        screenCapturerAndroid = this.capturer;
        if (screenCapturerAndroid == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"capturer");
            throw null;
        }
        screenCapturerAndroid.startCapture(hmsVideoTrackSettings.getResolution().getWidth(), hmsVideoTrackSettings.getResolution().getHeight(), 30);
    }

    private final void checkForOrientationChange(VideoFrame frame) {
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
        int currentOrientation = HMSUtils.INSTANCE.getOrientation(context);
        if (HMSUtils.INSTANCE.hasOrientationChange(currentOrientation, this.oldOrientation)) {
            this.oldOrientation = currentOrientation;
            context = this.capturer;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"capturer");
                throw null;
            }
            context.changeCaptureFormat(frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), 30);
        }
    }

    public final void stopCapturer() {
        ScreenCapturerAndroid screenCapturerAndroid = this.capturer;
        if (screenCapturerAndroid == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"capturer");
            throw null;
        }
        screenCapturerAndroid.stopCapture();
        this.stopSelf();
    }

    @NotNull
    public IBinder onBind(@Nullable Intent intent) {
        Object object;
        Object object2 = intent;
        this.customerNotification = object2 == null ? null : (Notification)object2.getParcelableExtra("hms_screenshare_notification_extra");
        object2 = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"TAG");
        HMSLogger.INSTANCE.v((String)object2, Intrinsics.stringPlus((String)"Is customer intent null? ", (Object)(this.customerNotification == null ? 1 : 0)));
        if (Build.VERSION.SDK_INT >= 26) {
            this.createNotificationChannel();
        }
        if ((object2 = this.customerNotification) == null) {
            Notification notification = new NotificationCompat.Builder((Context)this, NOTIFICATION_CHANNEL_ID).setContentTitle((CharSequence)"Service running in background").setContentText((CharSequence)"Screen Capture is running in background").build();
            Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"Builder(this, NOTIFICATION_CHANNEL_ID)\n                .setContentTitle(\"Service running in background\")\n                .setContentText(\"Screen Capture is running in background\")\n                .build()");
            object = notification;
        } else {
            object = object2;
        }
        this.startForeground(123, (Notification)object);
        return this.mBinder;
    }

    public void onDestroy() {
        String string = this.TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        HMSLogger.INSTANCE.v(string, "Being destroyed from the service");
        string = this.capturer;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"capturer");
            throw null;
        }
        string.stopCapture();
        super.onDestroy();
    }

    public int onStartCommand(@Nullable Intent intent, int flags, int startId) {
        int i = super.onStartCommand(intent, flags, startId);
        Intent intent2 = intent;
        if (Intrinsics.areEqual((Object)(intent2 == null ? null : intent2.getAction()), (Object)ACTION_STOP)) {
            BuildersKt.launch$default((CoroutineScope)HMSCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ HMSScreenCaptureService this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.getEndFlow().emit((Object)Boxing.boxBoolean((boolean)true), (Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        return i;
    }

    public static final /* synthetic */ void access$checkForOrientationChange(HMSScreenCaptureService $this, VideoFrame frame) {
        $this.checkForOrientationChange(frame);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Llive/hms/video/services/HMSScreenCaptureService$LocalBinder;", "Landroid/os/Binder;", "(Llive/hms/video/services/HMSScreenCaptureService;)V", "service", "Llive/hms/video/services/HMSScreenCaptureService;", "getService", "()Llive/hms/video/services/HMSScreenCaptureService;", "lib_release"})
    public final class LocalBinder
    extends Binder {
        public LocalBinder() {
            Intrinsics.checkNotNullParameter((Object)((Object)HMSScreenCaptureService.this), (String)"this$0");
        }

        @NotNull
        public final HMSScreenCaptureService getService() {
            return HMSScreenCaptureService.this;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Llive/hms/video/services/HMSScreenCaptureService$Companion;", "", "()V", "ACTION_START", "", "ACTION_STOP", "LOCAL_SCREEN_CAPTURER_THREAD", "NOTIFICATION_CHANNEL_ID", "PERMISSION_RESULT_DATA", "SCREEN_HEIGHT", "SCREEN_WIDTH", "SERVICE_ID", "", "getStopScreenSharePendingIntent", "Landroid/app/PendingIntent;", "context", "Landroid/content/Context;", "lib_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PendingIntent getStopScreenSharePendingIntent(@NotNull Context context) {
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intent $this$getStopScreenSharePendingIntent_u24lambda_u2d0 = intent = new Intent(context, HMSScreenCaptureService.class);
            boolean bl = false;
            $this$getStopScreenSharePendingIntent_u24lambda_u2d0.setAction(HMSScreenCaptureService.ACTION_STOP);
            Intent stopSelf = intent;
            PendingIntent pendingIntent = Build.VERSION.SDK_INT >= 31 ? PendingIntent.getService((Context)context, (int)123, (Intent)stopSelf, (int)0x4000000) : PendingIntent.getBroadcast((Context)context, (int)123, (Intent)stopSelf, (int)0x8000000);
            Intrinsics.checkNotNullExpressionValue((Object)pendingIntent, (String)"pendingIntent");
            return pendingIntent;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

