/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.factories;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import live.hms.video.error.ErrorFactory;
import live.hms.video.error.HMSException;
import live.hms.video.events.AnalyticsEvent;
import live.hms.video.events.AnalyticsEventFactory;
import live.hms.video.events.AnalyticsEventsService;
import live.hms.video.factories.HMSNetworkMonitor;
import live.hms.video.factories.HMSVideoEncoderFactory;
import live.hms.video.media.settings.HMSAudioTrackSettings;
import live.hms.video.media.settings.HMSTrackSettings;
import live.hms.video.utils.HMSLogger;
import live.hms.video.utils.SharedEglContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.webrtc.DefaultVideoDecoderFactory;
import org.webrtc.Logging;
import org.webrtc.NetworkChangeDetector;
import org.webrtc.NetworkMonitor;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.VideoCodecInfo;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+2\u0006\u0010\n\u001a\u00020\tJ\u0010\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010-\u001a\u00020'2\u0006\u0010.\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R+\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR+\u0010\u0012\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u00118F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R+\u0010\u0019\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\u00188F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u0010\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR+\u0010 \u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\u001f8F@BX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010\u0010\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u0006/"}, d2={"Llive/hms/video/factories/HMSPeerConnectionFactory;", "", "()V", "PREF_AEC_EVENT_DEFAULT", "", "PREF_AEC_EVENT_KEY", "", "TAG", "<set-?>", "Llive/hms/video/events/AnalyticsEventsService;", "analyticsEventsService", "getAnalyticsEventsService", "()Llive/hms/video/events/AnalyticsEventsService;", "setAnalyticsEventsService", "(Llive/hms/video/events/AnalyticsEventsService;)V", "analyticsEventsService$delegate", "Lkotlin/properties/ReadWriteProperty;", "Lorg/webrtc/PeerConnectionFactory;", "factory", "getFactory", "()Lorg/webrtc/PeerConnectionFactory;", "setFactory", "(Lorg/webrtc/PeerConnectionFactory;)V", "factory$delegate", "Lorg/webrtc/VideoDecoderFactory;", "videoDecoderFactory", "getVideoDecoderFactory", "()Lorg/webrtc/VideoDecoderFactory;", "setVideoDecoderFactory", "(Lorg/webrtc/VideoDecoderFactory;)V", "videoDecoderFactory$delegate", "Lorg/webrtc/VideoEncoderFactory;", "videoEncoderFactory", "getVideoEncoderFactory", "()Lorg/webrtc/VideoEncoderFactory;", "setVideoEncoderFactory", "(Lorg/webrtc/VideoEncoderFactory;)V", "videoEncoderFactory$delegate", "initialize", "", "context", "Landroid/content/Context;", "hmsTrackSettings", "Llive/hms/video/media/settings/HMSTrackSettings;", "sendAECAnalytics", "sendMicCaptureFailedEvent", "errorMessage", "lib_release"})
public final class HMSPeerConnectionFactory {
    @NotNull
    public static final HMSPeerConnectionFactory INSTANCE;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private static final String TAG = "HMSPeerConnectionFactory";
    @NotNull
    private static final String PREF_AEC_EVENT_KEY = "aec_event";
    private static final boolean PREF_AEC_EVENT_DEFAULT = false;
    @NotNull
    private static final ReadWriteProperty videoEncoderFactory$delegate;
    @NotNull
    private static final ReadWriteProperty videoDecoderFactory$delegate;
    @NotNull
    private static final ReadWriteProperty factory$delegate;
    @NotNull
    private static final ReadWriteProperty analyticsEventsService$delegate;

    private HMSPeerConnectionFactory() {
    }

    @NotNull
    public final VideoEncoderFactory getVideoEncoderFactory() {
        return (VideoEncoderFactory)videoEncoderFactory$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final void setVideoEncoderFactory(VideoEncoderFactory videoEncoderFactory) {
        videoEncoderFactory$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)videoEncoderFactory);
    }

    @NotNull
    public final VideoDecoderFactory getVideoDecoderFactory() {
        return (VideoDecoderFactory)videoDecoderFactory$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final void setVideoDecoderFactory(VideoDecoderFactory videoDecoderFactory) {
        videoDecoderFactory$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)videoDecoderFactory);
    }

    @NotNull
    public final PeerConnectionFactory getFactory() {
        return (PeerConnectionFactory)factory$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    private final void setFactory(PeerConnectionFactory peerConnectionFactory) {
        factory$delegate.setValue((Object)this, $$delegatedProperties[2], (Object)peerConnectionFactory);
    }

    private final AnalyticsEventsService getAnalyticsEventsService() {
        return (AnalyticsEventsService)analyticsEventsService$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    private final void setAnalyticsEventsService(AnalyticsEventsService analyticsEventsService) {
        analyticsEventsService$delegate.setValue((Object)this, $$delegatedProperties[3], (Object)analyticsEventsService);
    }

    public final void initialize(@NotNull Context context, @NotNull HMSTrackSettings hmsTrackSettings, @NotNull AnalyticsEventsService analyticsEventsService) {
        boolean bl;
        String string;
        VideoCodecInfo it;
        Collection<String> collection;
        Object[] $this$mapTo$iv$iv;
        Object[] $this$map$iv;
        PeerConnectionFactory.InitializationOptions.Builder builder;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)hmsTrackSettings, (String)"hmsTrackSettings");
        Intrinsics.checkNotNullParameter((Object)analyticsEventsService, (String)"analyticsEventsService");
        PeerConnectionFactory.InitializationOptions.Builder $this$initialize_u24lambda_u2d1 = builder = PeerConnectionFactory.InitializationOptions.builder((Context)context);
        boolean bl2 = false;
        $this$initialize_u24lambda_u2d1.setFieldTrials("WebRTC-H264HighProfile/Enabled/WebRTC-MediaCodecVideoEncoder-AutomaticResize/Enabled/WebRTC-UseDifferentiatedCellularCosts/Enabled/");
        $this$initialize_u24lambda_u2d1.setInjectableLogger(HMSPeerConnectionFactory::initialize$lambda-1$lambda-0, Logging.Severity.LS_VERBOSE);
        PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)builder.createInitializationOptions());
        NetworkMonitor.getInstance().setNetworkChangeDetectorFactory(HMSPeerConnectionFactory::initialize$lambda-2);
        this.setAnalyticsEventsService(analyticsEventsService);
        PeerConnectionFactory.InitializationOptions.Builder $this$initialize_u24lambda_u2d5 = $this$initialize_u24lambda_u2d1 = PeerConnectionFactory.builder();
        boolean bl3 = false;
        PeerConnectionFactory.Options options = new PeerConnectionFactory.Options();
        $this$initialize_u24lambda_u2d5.setOptions(options);
        INSTANCE.setVideoEncoderFactory((VideoEncoderFactory)new HMSVideoEncoderFactory(SharedEglContext.INSTANCE.getContext(), true, true));
        INSTANCE.setVideoDecoderFactory((VideoDecoderFactory)new DefaultVideoDecoderFactory(SharedEglContext.INSTANCE.getContext()));
        Object[] objectArray = INSTANCE.getVideoEncoderFactory().getSupportedCodecs();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"videoEncoderFactory.supportedCodecs");
        objectArray = objectArray;
        String string2 = "Encoder supported Codecs: ";
        String string3 = TAG;
        boolean $i$f$map = false;
        void var13_16 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        for (VideoCodecInfo item$iv$iv : $this$mapTo$iv$iv) {
            VideoCodecInfo videoCodecInfo = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl4 = false;
            string = it.name;
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        HMSLogger.d(string3, Intrinsics.stringPlus((String)string2, (Object)collection));
        $this$map$iv = INSTANCE.getVideoDecoderFactory().getSupportedCodecs();
        Intrinsics.checkNotNullExpressionValue((Object)$this$map$iv, (String)"videoDecoderFactory.supportedCodecs");
        $this$map$iv = $this$map$iv;
        string2 = "Decoder supported Codecs: ";
        string3 = TAG;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.length);
        $i$f$mapTo = false;
        for (VideoCodecInfo item$iv$iv : $this$mapTo$iv$iv) {
            it = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl5 = false;
            string = it.name;
            collection.add(string);
        }
        collection = (List)destination$iv$iv;
        HMSLogger.d(string3, Intrinsics.stringPlus((String)string2, collection));
        $this$initialize_u24lambda_u2d5.setVideoEncoderFactory(INSTANCE.getVideoEncoderFactory());
        $this$initialize_u24lambda_u2d5.setVideoDecoderFactory(INSTANCE.getVideoDecoderFactory());
        PeerConnectionFactory.InitializationOptions.Builder builder2 = $this$initialize_u24lambda_u2d1;
        JavaAudioDeviceModule.AudioRecordErrorCallback audioRecordErrorCallback2 = new JavaAudioDeviceModule.AudioRecordErrorCallback(){

            public void onWebRtcAudioRecordInitError(@Nullable String errorMessage) {
                String errorMessage2 = Intrinsics.stringPlus((String)"audioRecordErrorCallback:: onWebRtcAudioRecordInitError:: ", (Object)errorMessage);
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(HMSPeerConnectionFactory.INSTANCE, errorMessage2);
            }

            public void onWebRtcAudioRecordStartError(@Nullable JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, @Nullable String errorMessage) {
                String errorMessage2 = "audioRecordErrorCallback:: onWebRtcAudioRecordStartError:: " + errorCode + " ==> " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(HMSPeerConnectionFactory.INSTANCE, errorMessage2);
            }

            public void onWebRtcAudioRecordError(@Nullable String errorMessage) {
                String errorMessage2 = Intrinsics.stringPlus((String)"audioRecordErrorCallback:: onWebRtcAudioRecordError:: ", (Object)errorMessage);
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(HMSPeerConnectionFactory.INSTANCE, errorMessage2);
            }
        };
        JavaAudioDeviceModule.AudioTrackErrorCallback audioTrackErrorCallback2 = new JavaAudioDeviceModule.AudioTrackErrorCallback(){

            public void onWebRtcAudioTrackInitError(@Nullable String errorMessage) {
                String errorMessage2 = Intrinsics.stringPlus((String)"audioTrackErrorCallback:: onWebRtcAudioRecordInitError:: ", (Object)errorMessage);
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(HMSPeerConnectionFactory.INSTANCE, errorMessage2);
            }

            public void onWebRtcAudioTrackStartError(@Nullable JavaAudioDeviceModule.AudioTrackStartErrorCode errorCode, @Nullable String errorMessage) {
                String errorMessage2 = "audioTrackErrorCallback:: onWebRtcAudioRecordStartError:: " + errorCode + " ==> " + errorMessage;
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(HMSPeerConnectionFactory.INSTANCE, errorMessage2);
            }

            public void onWebRtcAudioTrackError(@Nullable String errorMessage) {
                String errorMessage2 = Intrinsics.stringPlus((String)"audioTrackErrorCallback:: onWebRtcAudioRecordError:: ", (Object)errorMessage);
                HMSLogger.e("HMSPeerConnectionFactory", errorMessage2);
                HMSPeerConnectionFactory.access$sendMicCaptureFailedEvent(HMSPeerConnectionFactory.INSTANCE, errorMessage2);
            }
        };
        HMSAudioTrackSettings hMSAudioTrackSettings = hmsTrackSettings.getAudioSettings();
        JavaAudioDeviceModule javaAudioDeviceModule2 = JavaAudioDeviceModule.builder((Context)context).setUseHardwareAcousticEchoCanceler(hMSAudioTrackSettings == null ? true : (bl = hMSAudioTrackSettings.getUseHardwareAcousticEchoCanceler())).setAudioRecordErrorCallback(audioRecordErrorCallback2).setAudioTrackErrorCallback(audioTrackErrorCallback2).setAudioRecordStateCallback(new JavaAudioDeviceModule.AudioRecordStateCallback(){

            public void onWebRtcAudioRecordStart() {
                HMSLogger.INSTANCE.v("HMSPeerConnectionFactory", "~~ onWebRtcAudioRecordStart ~~");
            }

            public void onWebRtcAudioRecordStop() {
                HMSLogger.INSTANCE.v("HMSPeerConnectionFactory", "~~ onWebRtcAudioRecordStop ~~");
            }
        }).createAudioDeviceModule();
        hMSAudioTrackSettings = builder2.setAudioDeviceModule((AudioDeviceModule)javaAudioDeviceModule2).createPeerConnectionFactory();
        Intrinsics.checkNotNullExpressionValue((Object)hMSAudioTrackSettings, (String)"builder.setAudioDeviceModule(javaAudioDeviceModule)\n      .createPeerConnectionFactory()");
        this.setFactory((PeerConnectionFactory)hMSAudioTrackSettings);
        this.sendAECAnalytics(context);
    }

    private final void sendAECAnalytics(Context context) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        boolean isAECEventSent = sharedPreferences.getBoolean(PREF_AEC_EVENT_KEY, false);
        if (!isAECEventSent) {
            boolean isHardwareAECSupported = JavaAudioDeviceModule.isBuiltInAcousticEchoCancelerSupported();
            AnalyticsEvent analyticsEvent = AnalyticsEventFactory.INSTANCE.audioEchoCancellation(isHardwareAECSupported);
            this.getAnalyticsEventsService().queue(analyticsEvent);
            sharedPreferences.edit().putBoolean(PREF_AEC_EVENT_KEY, true).apply();
        }
    }

    private final void sendMicCaptureFailedEvent(String errorMessage) {
        HMSException hmsException = ErrorFactory.TracksErrors.MicCaptureFailed$default(ErrorFactory.TracksErrors.INSTANCE, ErrorFactory.Action.TRACK, errorMessage, null, null, 12, null);
        AnalyticsEvent analyticsEvent = AnalyticsEventFactory.INSTANCE.audioPublishFail(hmsException);
        this.getAnalyticsEventsService().queue(analyticsEvent);
    }

    private static final void initialize$lambda-1$lambda-0(String message, Logging.Severity severity, String tag) {
        Intrinsics.checkNotNullExpressionValue((Object)severity, (String)"severity");
        Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"tag");
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"message");
        HMSLogger.INSTANCE.webRTCLog$lib_release(severity, tag, message);
    }

    private static final NetworkChangeDetector initialize$lambda-2(NetworkChangeDetector.Observer observer, Context ctx) {
        return new HMSNetworkMonitor(observer, ctx);
    }

    public static final /* synthetic */ void access$sendMicCaptureFailedEvent(HMSPeerConnectionFactory $this, String errorMessage) {
        $this.sendMicCaptureFailedEvent(errorMessage);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HMSPeerConnectionFactory.class), "videoEncoderFactory", "getVideoEncoderFactory()Lorg/webrtc/VideoEncoderFactory;"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HMSPeerConnectionFactory.class), "videoDecoderFactory", "getVideoDecoderFactory()Lorg/webrtc/VideoDecoderFactory;"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HMSPeerConnectionFactory.class), "factory", "getFactory()Lorg/webrtc/PeerConnectionFactory;"))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(HMSPeerConnectionFactory.class), "analyticsEventsService", "getAnalyticsEventsService()Llive/hms/video/events/AnalyticsEventsService;")))};
        $$delegatedProperties = kPropertyArray;
        INSTANCE = new HMSPeerConnectionFactory();
        videoEncoderFactory$delegate = Delegates.INSTANCE.notNull();
        videoDecoderFactory$delegate = Delegates.INSTANCE.notNull();
        factory$delegate = Delegates.INSTANCE.notNull();
        analyticsEventsService$delegate = Delegates.INSTANCE.notNull();
    }
}

