/*
 * Decompiled with CFR 0.152.
 */
package live.hms.video.database.dao;

import android.database.Cursor;
import android.os.CancellationSignal;
import androidx.room.CoroutinesRoom;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import live.hms.video.database.converters.TypeConverter;
import live.hms.video.database.dao.AnalyticsEventsDao;
import live.hms.video.database.entity.AnalyticsEntityModel;

public final class AnalyticsEventsDao_Impl
implements AnalyticsEventsDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<AnalyticsEntityModel> __insertionAdapterOfAnalyticsEntityModel;
    private final EntityDeletionOrUpdateAdapter<AnalyticsEntityModel> __deletionAdapterOfAnalyticsEntityModel;
    private final EntityDeletionOrUpdateAdapter<AnalyticsEntityModel> __updateAdapterOfAnalyticsEntityModel;
    private final SharedSQLiteStatement __preparedStmtOfDeleteLogById;

    public AnalyticsEventsDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfAnalyticsEntityModel = new EntityInsertionAdapter<AnalyticsEntityModel>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `analytics_table` (`timestamp`,`eventId`,`payload`,`eventName`,`sessionId`,`peerId`,`token`) VALUES (?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, AnalyticsEntityModel value) {
                stmt.bindLong(1, value.getTimestamp());
                if (value.getEventId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getEventId());
                }
                String _tmp = TypeConverter.mapToString(value.getPayload());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                if (value.getEventName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getEventName());
                }
                if (value.getSessionId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSessionId());
                }
                if (value.getPeerId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getPeerId());
                }
                if (value.getToken() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getToken());
                }
            }
        };
        this.__deletionAdapterOfAnalyticsEntityModel = new EntityDeletionOrUpdateAdapter<AnalyticsEntityModel>(__db){

            public String createQuery() {
                return "DELETE FROM `analytics_table` WHERE `eventId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AnalyticsEntityModel value) {
                if (value.getEventId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getEventId());
                }
            }
        };
        this.__updateAdapterOfAnalyticsEntityModel = new EntityDeletionOrUpdateAdapter<AnalyticsEntityModel>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `analytics_table` SET `timestamp` = ?,`eventId` = ?,`payload` = ?,`eventName` = ?,`sessionId` = ?,`peerId` = ?,`token` = ? WHERE `eventId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, AnalyticsEntityModel value) {
                stmt.bindLong(1, value.getTimestamp());
                if (value.getEventId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getEventId());
                }
                String _tmp = TypeConverter.mapToString(value.getPayload());
                if (_tmp == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, _tmp);
                }
                if (value.getEventName() == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, value.getEventName());
                }
                if (value.getSessionId() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getSessionId());
                }
                if (value.getPeerId() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getPeerId());
                }
                if (value.getToken() == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, value.getToken());
                }
                if (value.getEventId() == null) {
                    stmt.bindNull(8);
                } else {
                    stmt.bindString(8, value.getEventId());
                }
            }
        };
        this.__preparedStmtOfDeleteLogById = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "Delete FROM analytics_table WHERE eventId = ?";
                return "Delete FROM analytics_table WHERE eventId = ?";
            }
        };
    }

    @Override
    public Object addEvent(final AnalyticsEntityModel analyticsModel, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AnalyticsEventsDao_Impl.this.__db.beginTransaction();
                try {
                    AnalyticsEventsDao_Impl.this.__insertionAdapterOfAnalyticsEntityModel.insert((Object)analyticsModel);
                    AnalyticsEventsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AnalyticsEventsDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object deleteLog(final AnalyticsEntityModel analyticsModel, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AnalyticsEventsDao_Impl.this.__db.beginTransaction();
                try {
                    AnalyticsEventsDao_Impl.this.__deletionAdapterOfAnalyticsEntityModel.handle((Object)analyticsModel);
                    AnalyticsEventsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AnalyticsEventsDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object updateLog(final AnalyticsEntityModel analyticsModel, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            @Override
            public Unit call() throws Exception {
                AnalyticsEventsDao_Impl.this.__db.beginTransaction();
                try {
                    AnalyticsEventsDao_Impl.this.__updateAdapterOfAnalyticsEntityModel.handle((Object)analyticsModel);
                    AnalyticsEventsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AnalyticsEventsDao_Impl.this.__db.endTransaction();
                }
            }
        }, continuation);
    }

    @Override
    public Object deleteLogById(final String eventId, Continuation<? super Unit> continuation) {
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)true, (Callable)new Callable<Unit>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Unit call() throws Exception {
                SupportSQLiteStatement _stmt = AnalyticsEventsDao_Impl.this.__preparedStmtOfDeleteLogById.acquire();
                int _argIndex = 1;
                if (eventId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, eventId);
                }
                AnalyticsEventsDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    AnalyticsEventsDao_Impl.this.__db.setTransactionSuccessful();
                    Unit unit = Unit.INSTANCE;
                    return unit;
                }
                finally {
                    AnalyticsEventsDao_Impl.this.__db.endTransaction();
                    AnalyticsEventsDao_Impl.this.__preparedStmtOfDeleteLogById.release(_stmt);
                }
            }
        }, continuation);
    }

    @Override
    public Object getEvent(Continuation<? super AnalyticsEntityModel> continuation) {
        String _sql = "Select * FROM analytics_table LIMIT 1";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * FROM analytics_table LIMIT 1", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<AnalyticsEntityModel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public AnalyticsEntityModel call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AnalyticsEventsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    AnalyticsEntityModel _result;
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eventId");
                    int _cursorIndexOfPayload = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"payload");
                    int _cursorIndexOfEventName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eventName");
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    int _cursorIndexOfPeerId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"peerId");
                    int _cursorIndexOfToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"token");
                    if (_cursor.moveToFirst()) {
                        _result = new AnalyticsEntityModel();
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _result.setTimestamp(_tmpTimestamp);
                        String _tmpEventId = _cursor.isNull(_cursorIndexOfEventId) ? null : _cursor.getString(_cursorIndexOfEventId);
                        _result.setEventId(_tmpEventId);
                        String _tmp = _cursor.isNull(_cursorIndexOfPayload) ? null : _cursor.getString(_cursorIndexOfPayload);
                        HashMap<String, Object> _tmpPayload = TypeConverter.toHashMap(_tmp);
                        _result.setPayload(_tmpPayload);
                        String _tmpEventName = _cursor.isNull(_cursorIndexOfEventName) ? null : _cursor.getString(_cursorIndexOfEventName);
                        _result.setEventName(_tmpEventName);
                        String _tmpSessionId = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                        _result.setSessionId(_tmpSessionId);
                        String _tmpPeerId = _cursor.isNull(_cursorIndexOfPeerId) ? null : _cursor.getString(_cursorIndexOfPeerId);
                        _result.setPeerId(_tmpPeerId);
                        String _tmpToken = _cursor.isNull(_cursorIndexOfToken) ? null : _cursor.getString(_cursorIndexOfToken);
                        _result.setToken(_tmpToken);
                    } else {
                        _result = null;
                    }
                    AnalyticsEntityModel analyticsEntityModel = _result;
                    return analyticsEntityModel;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    @Override
    public Object getAllEvents(Continuation<? super List<AnalyticsEntityModel>> continuation) {
        String _sql = "Select * FROM analytics_table";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"Select * FROM analytics_table", (int)0);
        CancellationSignal _cancellationSignal = DBUtil.createCancellationSignal();
        return CoroutinesRoom.execute((RoomDatabase)this.__db, (boolean)false, (CancellationSignal)_cancellationSignal, (Callable)new Callable<List<AnalyticsEntityModel>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<AnalyticsEntityModel> call() throws Exception {
                Cursor _cursor = DBUtil.query((RoomDatabase)AnalyticsEventsDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
                try {
                    int _cursorIndexOfTimestamp = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"timestamp");
                    int _cursorIndexOfEventId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eventId");
                    int _cursorIndexOfPayload = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"payload");
                    int _cursorIndexOfEventName = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"eventName");
                    int _cursorIndexOfSessionId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"sessionId");
                    int _cursorIndexOfPeerId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"peerId");
                    int _cursorIndexOfToken = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"token");
                    ArrayList<AnalyticsEntityModel> _result = new ArrayList<AnalyticsEntityModel>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        AnalyticsEntityModel _item = new AnalyticsEntityModel();
                        long _tmpTimestamp = _cursor.getLong(_cursorIndexOfTimestamp);
                        _item.setTimestamp(_tmpTimestamp);
                        String _tmpEventId = _cursor.isNull(_cursorIndexOfEventId) ? null : _cursor.getString(_cursorIndexOfEventId);
                        _item.setEventId(_tmpEventId);
                        String _tmp = _cursor.isNull(_cursorIndexOfPayload) ? null : _cursor.getString(_cursorIndexOfPayload);
                        HashMap<String, Object> _tmpPayload = TypeConverter.toHashMap(_tmp);
                        _item.setPayload(_tmpPayload);
                        String _tmpEventName = _cursor.isNull(_cursorIndexOfEventName) ? null : _cursor.getString(_cursorIndexOfEventName);
                        _item.setEventName(_tmpEventName);
                        String _tmpSessionId = _cursor.isNull(_cursorIndexOfSessionId) ? null : _cursor.getString(_cursorIndexOfSessionId);
                        _item.setSessionId(_tmpSessionId);
                        String _tmpPeerId = _cursor.isNull(_cursorIndexOfPeerId) ? null : _cursor.getString(_cursorIndexOfPeerId);
                        _item.setPeerId(_tmpPeerId);
                        String _tmpToken = _cursor.isNull(_cursorIndexOfToken) ? null : _cursor.getString(_cursorIndexOfToken);
                        _item.setToken(_tmpToken);
                        _result.add(_item);
                    }
                    ArrayList<AnalyticsEntityModel> arrayList = _result;
                    return arrayList;
                }
                finally {
                    _cursor.close();
                    _statement.release();
                }
            }
        }, continuation);
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

