/*
 * Decompiled with CFR 0.152.
 */
package library.neetoffice.com.genericadapter.base;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import library.neetoffice.com.genericadapter.base.Filter;
import library.neetoffice.com.genericadapter.base.GenericAdapterInterface;
import library.neetoffice.com.genericadapter.base.ItemManager;

public abstract class GenericAdapter<E, T>
extends BaseAdapter
implements GenericAdapterInterface<E> {
    private final Context context;
    private final int layoutId;
    private final ItemManager<E> manager;

    public GenericAdapter(Context context, int layoutId) {
        this(context, new ArrayList(), layoutId);
    }

    public GenericAdapter(Context context, Collection<E> items, int layoutId) {
        this.context = context;
        this.layoutId = layoutId;
        this.manager = new ItemManager<E>(items);
    }

    public final Context getContext() {
        return this.context;
    }

    public final LayoutInflater getLayoutInflater() {
        return LayoutInflater.from((Context)this.context);
    }

    @Override
    public final void addAll(Collection<E> items) {
        this.manager.addAll(items);
        this.refresh();
    }

    @Override
    public final void setAll(Collection<E> items) {
        this.manager.setAll(items);
        this.refresh();
    }

    @Override
    public final void add(E item) {
        this.manager.add(item);
        this.refresh();
    }

    @Override
    public void add(int index, E item) {
        this.manager.add(index, item);
        this.refresh();
    }

    @Override
    public final void set(int index, E item) {
        this.manager.set(index, item);
        this.refresh();
    }

    @Override
    public final void remove(E item) {
        this.manager.remove(item);
        this.refresh();
    }

    @Override
    public final E remove(int position) {
        E e = this.manager.remove(position);
        this.refresh();
        return e;
    }

    @Override
    public final void clear() {
        this.manager.clear();
        this.refresh();
    }

    @Override
    public final void setFilter(Filter<E> filter) {
        this.manager.setFilter(filter);
        this.refresh();
    }

    @Override
    public void setSort(Comparator<E> sort) {
        this.manager.setSort(sort);
        this.refresh();
    }

    @Override
    public void refresh() {
        this.manager.refresh();
        this.notifyDataSetChanged();
    }

    @Override
    public final List<E> getItems() {
        return this.manager.getItems();
    }

    public int getCount() {
        return this.manager.getItemCount();
    }

    @Override
    public E getItem(int position) {
        return this.manager.getItem(position);
    }

    @Override
    public boolean isNoData() {
        return this.manager.isNoData();
    }

    @Override
    public void setNoDataViewEnable(boolean enable) {
        this.manager.setNoDataViewEnable(enable);
        this.refresh();
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        Object t = null;
        E e = this.getItem(position);
        if (e == null) {
            convertView = this.onCreateNoDataView(parent);
        } else if (convertView != null && convertView.getTag() != null) {
            t = convertView.getTag();
        } else {
            convertView = this.getLayoutInflater().inflate(this.layoutId, null, false);
            t = this.onCreateTag(convertView);
            convertView.setTag(t);
        }
        if (t != null && e != null) {
            this.onBind(t, e);
        }
        return convertView;
    }

    public View onCreateNoDataView(ViewGroup parent) {
        return new View(this.getContext());
    }

    public abstract T onCreateTag(View var1);

    public abstract void onBind(T var1, E var2);
}

