/*
 * Decompiled with CFR 0.152.
 */
package org.loadosophia.jmeter;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.zip.GZIPOutputStream;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.FilePartSource;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.IOUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.loadosophia.jmeter.LoadosophiaUploadResults;
import org.loadosophia.jmeter.StatusNotifierCallback;

public class LoadosophiaAPIClient {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String COLOR_NONE = "none";
    public static final String[] colors = new String[]{"none", "red", "green", "blue", "gray", "orange", "violet", "cyan", "black"};
    public static final String STATUS_DONE = "4";
    private final HttpClient httpClient = new HttpClient();
    private final StatusNotifierCallback notifier;
    private final String project;
    private final String address;
    private final String token;
    private final String colorFlag;
    private final String title;
    private static final int TIMEOUT = 5;

    public LoadosophiaAPIClient(StatusNotifierCallback informer, String aAddress, String aToken, String projectName, String aColorFlag, String aTitle) {
        this.project = projectName;
        this.address = aAddress;
        this.token = aToken;
        this.notifier = informer;
        this.colorFlag = aColorFlag;
        this.title = aTitle;
        this.httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(5000);
        this.httpClient.getHttpConnectionManager().getParams().setSoTimeout(5000);
    }

    public LoadosophiaUploadResults sendFiles(File targetFile, LinkedList<String> perfMonFiles) throws IOException {
        LoadosophiaUploadResults results = new LoadosophiaUploadResults();
        if (targetFile.length() == 0L) {
            throw new IOException("Cannot send empty file to BM.Sense");
        }
        log.info("Preparing files to send");
        LinkedList<Part> partsList = new LinkedList<Part>();
        partsList.add((Part)new StringPart("projectKey", this.project));
        partsList.add((Part)new FilePart("jtl_file", (PartSource)new FilePartSource(this.gzipFile(targetFile))));
        Iterator it = perfMonFiles.iterator();
        int index = 0;
        while (it.hasNext()) {
            File perfmonFile = new File((String)it.next());
            if (!perfmonFile.exists()) {
                log.warn("File not exists, skipped: " + perfmonFile.getAbsolutePath());
                continue;
            }
            partsList.add((Part)new FilePart("perfmon_" + index, (PartSource)new FilePartSource(this.gzipFile(perfmonFile))));
            ++index;
        }
        this.notifier.notifyAbout("Starting upload to BM.Sense");
        String[] fields = this.multipartPost(partsList, this.getUploaderURI(), 200);
        int queueID = Integer.parseInt(fields[0]);
        results.setQueueID(queueID);
        if (!this.title.trim().isEmpty() || !this.colorFlag.equals(COLOR_NONE)) {
            int testID = this.getTestByUpload(queueID);
            results.setTestID(testID);
            if (!this.title.trim().isEmpty()) {
                this.setTestTitle(testID, this.title.trim());
            }
            if (!this.colorFlag.equals(COLOR_NONE)) {
                this.setTestColor(testID, this.colorFlag);
            }
            results.setRedirectLink(this.address + "gui/" + testID + "/");
        } else {
            results.setRedirectLink(this.address + "api/file/status/" + queueID + "/?redirect=true");
        }
        return results;
    }

    public String startOnline() throws IOException {
        String uri = this.address + "api/active/receiver/start/";
        LinkedList<Part> partsList = new LinkedList<Part>();
        partsList.add((Part)new StringPart("token", this.token));
        partsList.add((Part)new StringPart("projectKey", this.project));
        partsList.add((Part)new StringPart("title", this.title));
        String[] res = this.multipartPost(partsList, uri, 201);
        JSONObject obj = JSONObject.fromObject(res[0]);
        return this.address + "gui/active/" + obj.optString("OnlineID", "N/A") + "/";
    }

    public void sendOnlineData(JSONArray data) throws IOException {
        String uri = this.address + "api/active/receiver/data/";
        LinkedList<Part> partsList = new LinkedList<Part>();
        String dataStr = data.toString();
        log.debug("Sending active test data: " + dataStr);
        partsList.add((Part)new StringPart("data", dataStr));
        this.multipartPost(partsList, uri, 202);
    }

    public void endOnline(String redirectLink) throws IOException {
        String uri = this.address + "api/active/receiver/stop/";
        LinkedList<Part> partsList = new LinkedList<Part>();
        partsList.add((Part)new StringPart("redirect", redirectLink));
        this.multipartPost(partsList, uri, 205);
    }

    private File gzipFile(File src) throws IOException {
        int len;
        String outFilename = src.getAbsolutePath() + ".gz";
        this.notifier.notifyAbout("Gzipping " + src.getAbsolutePath());
        GZIPOutputStream out = new GZIPOutputStream(new FileOutputStream(outFilename));
        FileInputStream in = new FileInputStream(src);
        byte[] buf = new byte[10240];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.finish();
        out.close();
        src.delete();
        return new File(outFilename);
    }

    private int getTestByUpload(int queueID) throws IOException {
        String[] status;
        do {
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Failed to get test ID");
            }
            status = this.getUploadStatus(queueID);
            if (status.length <= 2 || status[2].isEmpty()) continue;
            throw new RuntimeException("BM.Sense processing error: " + status[2]);
        } while (!status[1].equals(STATUS_DONE));
        return Integer.parseInt(status[0]);
    }

    private void setTestTitle(int testID, String trim) throws IOException {
        String uri = this.address + "api/test/edit/title/" + testID + "/?title=" + URLEncoder.encode(trim, "UTF-8");
        this.multipartPost(new LinkedList<Part>(), uri, 204);
    }

    private void setTestColor(int testID, String colorFlag) throws IOException {
        String uri = this.address + "api/test/edit/color/" + testID + "/?color=" + colorFlag;
        this.multipartPost(new LinkedList<Part>(), uri, 204);
    }

    private String getUploaderURI() {
        return this.address + "api/file/upload/?format=csv";
    }

    protected String[] getUploadStatus(int queueID) throws IOException {
        String uri = this.address + "api/file/status/" + queueID + "/?format=csv";
        return this.multipartPost(new LinkedList<Part>(), uri, 200);
    }

    protected String[] multipartPost(LinkedList<Part> parts, String URL2, int expectedSC) throws IOException {
        log.debug("Request POST: " + URL2);
        parts.add((Part)new StringPart("token", this.token));
        PostMethod postRequest = new PostMethod(URL2);
        MultipartRequestEntity multipartRequest = new MultipartRequestEntity(parts.toArray(new Part[parts.size()]), postRequest.getParams());
        postRequest.setRequestEntity((RequestEntity)multipartRequest);
        int result = this.httpClient.executeMethod((HttpMethod)postRequest);
        if (result != expectedSC) {
            String fname = File.createTempFile("error_", ".html").getAbsolutePath();
            this.notifier.notifyAbout("Saving server error response to: " + fname);
            FileOutputStream fos = new FileOutputStream(fname);
            FileChannel resultFile = fos.getChannel();
            resultFile.write(ByteBuffer.wrap(IOUtils.toByteArray((InputStream)postRequest.getResponseBodyAsStream())));
            resultFile.close();
            throw new HttpException("Request returned not " + expectedSC + " status code: " + result);
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)postRequest.getResponseBodyAsStream());
        if (bytes == null) {
            bytes = new byte[]{};
        }
        String response = new String(bytes);
        return response.trim().split(";");
    }
}

