/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon.metrics;

import java.util.Arrays;
import kg.apc.perfmon.metrics.AbstractPerfMonMetric;
import kg.apc.perfmon.metrics.MetricParamsSigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.Swap;

class SwapMetric
extends AbstractPerfMonMetric {
    public static final byte PAGE_IN = 0;
    public static final byte PAGE_OUT = 1;
    public static final byte FREE = 2;
    public static final byte TOTAL = 3;
    public static final byte USED = 4;
    public static final String[] types = new String[]{"pagein", "pageout", "free", "total", "used"};
    private int type = -1;
    private double prev = -1.0;
    private int dividingFactor = 1;

    public SwapMetric(SigarProxy aSigar, MetricParamsSigar params) {
        super(aSigar);
        if (params.type.length() == 0) {
            this.type = 4;
        } else {
            this.type = Arrays.asList(types).indexOf(params.type);
            if (this.type < 0) {
                throw new IllegalArgumentException("Unknown swap type: " + params.type);
            }
        }
        this.dividingFactor = this.getUnitDividingFactor(params.getUnit());
    }

    public void getValue(StringBuffer res) throws SigarException {
        Swap mem = this.sigarProxy.getSwap();
        int factor = 1;
        switch (this.type) {
            case 0: {
                double cur = mem.getPageIn();
                double val = this.prev != -1.0 ? cur - this.prev : 0.0;
                this.prev = cur;
                break;
            }
            case 1: {
                double cur = mem.getPageOut();
                double val = this.prev != -1.0 ? cur - this.prev : 0.0;
                this.prev = cur;
                break;
            }
            case 2: {
                double val = mem.getFree();
                factor = this.dividingFactor;
                break;
            }
            case 3: {
                double val = mem.getTotal();
                factor = this.dividingFactor;
                break;
            }
            case 4: {
                double val = mem.getUsed();
                factor = this.dividingFactor;
                break;
            }
            default: {
                throw new SigarException("Unknown swap type " + this.type);
            }
        }
        res.append(Double.toString(val /= (double)factor));
    }
}

