/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.perfmon.client;

import java.io.IOException;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import kg.apc.perfmon.client.Transport;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public abstract class AbstractTransport
implements Transport {
    private static final Logger log = LoggingManager.getLoggerForClass();
    protected final PipedOutputStream pos = new PipedOutputStream();
    protected final PipedInputStream pis = new PipedInputStream(this.pos);
    private String label;

    public String[] readMetrics() {
        String str = this.readln();
        return str.split("\t");
    }

    public void setInterval(long interval) {
        log.debug("Setting interval to " + interval);
        try {
            this.writeln("interval:" + interval);
        }
        catch (IOException ex) {
            log.error("Error setting interval", (Throwable)ex);
        }
    }

    public void shutdownAgent() {
        log.info("Shutting down the agent");
        try {
            this.writeln("shutdown");
        }
        catch (IOException ex) {
            log.error("Error shutting down", (Throwable)ex);
        }
    }

    public void startWithMetrics(String[] metricsArray) throws IOException {
        String cmd = "metrics:";
        for (int n = 0; n < metricsArray.length; ++n) {
            cmd = cmd + metricsArray[n].replace('\t', ' ') + "\t";
        }
        log.debug("Starting with metrics: " + cmd);
        this.writeln(cmd);
    }

    public void disconnect() {
        log.debug("Disconnecting from " + this.label);
        try {
            this.writeln("exit");
        }
        catch (IOException ex) {
            log.error("Error during exit", (Throwable)ex);
        }
    }

    public boolean test() {
        try {
            this.writeln("test");
        }
        catch (IOException ex) {
            log.error("Failed to send command", (Throwable)ex);
            return false;
        }
        return this.readln().startsWith("Yep");
    }

    protected String getNextLine(int newlineCount) throws IOException {
        if (newlineCount == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        while (this.pis.available() > 0) {
            int b = this.pis.read();
            if (b == -1) {
                return "";
            }
            if (b == 10 && --newlineCount == 0) {
                log.debug("Read lines: " + str.toString());
                String[] lines = str.toString().split("\n");
                return lines[lines.length - 1];
            }
            str.append((char)b);
        }
        return "";
    }

    public String getAddressLabel() {
        return this.label;
    }

    public void setAddressLabel(String label) {
        this.label = label;
    }
}

