/*
 * Decompiled with CFR 0.152.
 */
package com.blazemeter.jmeter.threads.concurrency;

import com.blazemeter.jmeter.threads.AbstractDynamicThreadGroup;
import com.blazemeter.jmeter.threads.concurrency.ConcurrencyThreadStarter;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.ListenerNotifier;
import org.apache.jorphan.collections.ListedHashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class ConcurrencyThreadGroup
extends AbstractDynamicThreadGroup {
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final int MIN_CHECK_TIME = 1000;

    @Override
    protected Thread getThreadStarter(int groupIndex, ListenerNotifier listenerNotifier, ListedHashTree testTree, StandardJMeterEngine engine) {
        return new ConcurrencyThreadStarter(groupIndex, listenerNotifier, testTree, engine, this);
    }

    public synchronized void waitThreadStopped() {
        if (!this.threads.isEmpty()) {
            try {
                ((Object)((Object)this)).wait(1000L);
            }
            catch (InterruptedException e) {
                log.debug("Interrupted", (Throwable)e);
            }
        }
    }

    public int getNumThreads() {
        return (int)Math.round(this.getTargetLevelAsDouble());
    }

    @Override
    public boolean isLimitReached() {
        return !this.running || !this.threadStarter.isAlive();
    }

    public void threadStarted(JMeterThread thread) {
        this.saveLogRecord("START", thread.getThreadName(), "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadFinished(JMeterThread thread) {
        super.threadFinished(thread);
        this.saveLogRecord("FINISH", thread.getThreadName(), "");
        ConcurrencyThreadGroup concurrencyThreadGroup = this;
        synchronized (concurrencyThreadGroup) {
            ((Object)((Object)this)).notifyAll();
        }
    }

    public long getConcurrency() {
        return this.threads.size();
    }

    public boolean tooMuchConcurrency() {
        return (double)this.threads.size() > this.getTargetLevelAsDouble();
    }
}

