/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository.plugins;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.apache.jmeter.save.SaveService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestPlanAnalyzer {
    private static final Logger log = LoggerFactory.getLogger(TestPlanAnalyzer.class);
    private static final byte[] XML_VERSION = "version=\"1.1\"".getBytes();

    public Set<String> analyze(String path) {
        log.debug("Analyze test plan: " + path);
        NodeList nodeList = this.getNodeListWithClassNames(path);
        if (nodeList != null) {
            HashSet<String> nonExistentClasses = new HashSet<String>();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NamedNodeMap attributes = node.getAttributes();
                this.checkAttributeAndAdd(attributes, "guiclass", nonExistentClasses);
                this.checkAttributeAndAdd(attributes, "testclass", nonExistentClasses);
            }
            return nonExistentClasses;
        }
        return Collections.emptySet();
    }

    private void checkAttributeAndAdd(NamedNodeMap attributes, String attributeName, Set<String> nonExistentClasses) {
        Node node = attributes.getNamedItem(attributeName);
        if (node != null && !TestPlanAnalyzer.isClassExists(node.getTextContent())) {
            nonExistentClasses.add(node.getTextContent());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readBytesFromFile(String filePath) {
        FileInputStream fileInputStream = null;
        byte[] bytesArray = null;
        try {
            File file = new File(filePath);
            bytesArray = new byte[(int)file.length()];
            fileInputStream = new FileInputStream(file);
            fileInputStream.read(bytesArray);
        }
        catch (IOException e) {
            log.warn("Failed read jmx file", (Throwable)e);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException e) {
                    log.warn("Failed close jmx file input stream", (Throwable)e);
                }
            }
        }
        return bytesArray;
    }

    private byte[] overrideXmlVersion(byte[] bytes) {
        int headerLength = 100;
        if (bytes != null && bytes.length > 100) {
            byte[] line = new byte[100];
            System.arraycopy(bytes, 0, line, 0, 100);
            String header = new String(line);
            int index = header.indexOf("version=");
            if (index != -1) {
                System.arraycopy(XML_VERSION, 0, bytes, index, XML_VERSION.length);
            } else {
                log.debug("Did not find XML version in test plan");
            }
        }
        return bytes;
    }

    private NodeList getNodeListWithClassNames(String path) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            byte[] bytes = this.overrideXmlVersion(TestPlanAnalyzer.readBytesFromFile(path));
            Document doc = bytes == null ? builder.parse(path) : builder.parse(new ByteArrayInputStream(bytes));
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            XPathExpression expr = xpath.compile("//*[@guiclass|@testclass]");
            return (NodeList)expr.evaluate(doc, XPathConstants.NODESET);
        }
        catch (Exception ex) {
            log.warn("Cannot parse file: " + path, (Throwable)ex);
            return null;
        }
    }

    public static boolean isClassExists(String className) {
        try {
            Class.forName(SaveService.aliasToClass((String)className));
            return true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            return false;
        }
    }
}

