/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.util.EscapeDialog;
import org.apache.jorphan.gui.ComponentUtil;
import org.jmeterplugins.repository.GenericCallback;
import org.jmeterplugins.repository.Plugin;
import org.jmeterplugins.repository.PluginCheckbox;
import org.jmeterplugins.repository.PluginIcon;
import org.jmeterplugins.repository.PluginManager;
import org.jmeterplugins.repository.PluginUpgradesList;
import org.jmeterplugins.repository.PluginsList;
import org.jmeterplugins.repository.exception.DownloadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManagerDialog
extends EscapeDialog
implements ActionListener,
ComponentListener,
HyperlinkListener {
    private static final long serialVersionUID = 888467568782611707L;
    private static final Logger log = LoggerFactory.getLogger(PluginManagerDialog.class);
    public static final Border SPACING = BorderFactory.createEmptyBorder(5, 5, 5, 5);
    private final PluginManager manager;
    private final JTextPane modifs = new JTextPane();
    private final JButton apply = new JButton("Apply Changes and Restart JMeter");
    private final PluginsList installed;
    private final PluginsList available;
    private final PluginUpgradesList upgrades;
    private final JSplitPane topAndDown = new JSplitPane(0);
    private final JLabel statusLabel = new JLabel("");
    private final JEditorPane failureLabel = new JEditorPane();
    private final JScrollPane failureScrollPane = new JScrollPane(this.failureLabel);
    private final ChangeListener cbNotifier;
    private final ChangeListener cbUpgradeNotifier;

    public PluginManagerDialog(PluginManager aManager) {
        super((Frame)null, "JMeter Plugins Manager", true);
        this.setLayout(new BorderLayout());
        this.addComponentListener(this);
        this.manager = aManager;
        Dimension size = new Dimension(1024, 768);
        this.setSize(size);
        this.setPreferredSize(size);
        this.setIconImage(PluginIcon.getPluginFrameIcon(this.manager.hasAnyUpdates(), (Window)((Object)this)));
        ComponentUtil.centerComponentInWindow((Component)((Object)this));
        this.failureLabel.setContentType("text/html");
        this.failureLabel.addHyperlinkListener(this);
        final GenericCallback<Object> statusRefresh = new GenericCallback<Object>(){

            @Override
            public void notify(Object ignored) {
                String changeText = PluginManagerDialog.this.manager.getChangesAsText();
                PluginManagerDialog.this.modifs.setText(changeText);
                PluginManagerDialog.this.apply.setEnabled(!changeText.isEmpty() && PluginManagerDialog.this.installed.isEnabled());
            }
        };
        this.cbNotifier = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof PluginCheckbox) {
                    PluginCheckbox checkbox = (PluginCheckbox)e.getSource();
                    Plugin plugin = checkbox.getPlugin();
                    PluginManagerDialog.this.manager.toggleInstalled(plugin, checkbox.isSelected());
                    statusRefresh.notify(this);
                }
            }
        };
        this.cbUpgradeNotifier = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                if (e.getSource() instanceof PluginCheckbox) {
                    PluginCheckbox checkbox = (PluginCheckbox)e.getSource();
                    Plugin plugin = checkbox.getPlugin();
                    if (checkbox.isSelected()) {
                        plugin.setCandidateVersion(checkbox.getPlugin().getMaxVersion());
                    } else {
                        plugin.setCandidateVersion(checkbox.getPlugin().getInstalledVersion());
                    }
                    statusRefresh.notify(this);
                }
            }
        };
        this.installed = new PluginsList(statusRefresh);
        this.available = new PluginsList(statusRefresh);
        this.upgrades = new PluginUpgradesList(statusRefresh);
        if (this.manager.hasPlugins()) {
            this.setPlugins();
        } else {
            this.loadPlugins();
        }
        this.topAndDown.setResizeWeight(0.75);
        this.topAndDown.setDividerSize(5);
        this.topAndDown.setTopComponent(this.getTabsPanel());
        this.topAndDown.setBottomComponent(this.getBottomPanel());
        this.add(this.topAndDown, "Center");
        statusRefresh.notify(this);
    }

    private void setPlugins() {
        this.installed.setPlugins(this.manager.getInstalledPlugins(), this.cbNotifier);
        this.available.setPlugins(this.manager.getAvailablePlugins(), this.cbNotifier);
        this.upgrades.setPlugins(this.manager.getUpgradablePlugins(), this.cbUpgradeNotifier);
    }

    private void loadPlugins() {
        if (!this.manager.hasPlugins()) {
            try {
                this.manager.load();
                this.setPlugins();
            }
            catch (Throwable e) {
                log.error("Failed to load plugins manager", e);
                ByteArrayOutputStream text = new ByteArrayOutputStream(4096);
                e.printStackTrace(new PrintStream(text));
                String msg = "<p>Failed to download plugins repository.<br/>";
                msg = msg + "One of the possible reasons is that you have proxy requirement for Internet connection.</p> Please read the instructions on this page: <a href=\"https://jmeter-plugins.org/wiki/PluginsManagerNetworkConfiguration/\">https://jmeter-plugins.org/wiki/PluginsManagerNetworkConfiguration/</a> <br><br>Error's technical details: <pre>" + text.toString() + "</pre><br>";
                this.failureLabel.setText("<html>" + msg + "</html>");
                this.failureLabel.setEditable(false);
                this.add(this.failureScrollPane, "Center");
                this.failureLabel.setCaretPosition(0);
            }
        }
    }

    private Component getTabsPanel() {
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.addTab("Installed Plugins", this.installed);
        tabbedPane.addTab("Available Plugins", this.available);
        tabbedPane.addTab("Upgrades", this.upgrades);
        return tabbedPane;
    }

    private JPanel getBottomPanel() {
        this.apply.setEnabled(false);
        this.modifs.setEditable(false);
        this.statusLabel.setFont(this.statusLabel.getFont().deriveFont(2));
        JPanel panel = new JPanel(new BorderLayout());
        JPanel modifsPanel = new JPanel(new BorderLayout());
        modifsPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getHeight() / 3));
        modifsPanel.setPreferredSize(new Dimension(this.getWidth(), this.getHeight() / 3));
        modifsPanel.setBorder(SPACING);
        modifsPanel.setBorder(BorderFactory.createTitledBorder("Review Changes"));
        this.modifs.setEditable(false);
        modifsPanel.add((Component)new JScrollPane(this.modifs), "Center");
        panel.add((Component)modifsPanel, "Center");
        JPanel btnPanel = new JPanel(new BorderLayout());
        btnPanel.setBorder(SPACING);
        btnPanel.add((Component)this.apply, "East");
        btnPanel.add((Component)this.statusLabel, "Center");
        panel.add((Component)btnPanel, "South");
        this.apply.addActionListener(this);
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.statusLabel.setForeground(Color.BLACK);
        this.enableComponents(false);
        new Thread(){

            @Override
            public void run() {
                GenericCallback<String> statusChanged = new GenericCallback<String>(){

                    @Override
                    public void notify(final String s) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                PluginManagerDialog.this.statusLabel.setText(s);
                                PluginManagerDialog.this.repaint();
                            }
                        });
                    }
                };
                try {
                    LinkedList<String> options = null;
                    String testPlan = GuiPackage.getInstance().getTestPlanFile();
                    if (testPlan != null) {
                        options = new LinkedList<String>();
                        options.add("-t");
                        options.add(testPlan);
                    }
                    PluginManagerDialog.this.manager.applyChanges(statusChanged, true, options);
                    ActionRouter.getInstance().actionPerformed(new ActionEvent(this, 0, "exit"));
                }
                catch (DownloadException ex) {
                    PluginManagerDialog.this.enableComponents(true);
                    PluginManagerDialog.this.statusLabel.setForeground(Color.RED);
                    statusChanged.notify("Failed to apply changes: " + ex.getMessage());
                }
                catch (Exception ex) {
                    PluginManagerDialog.this.statusLabel.setForeground(Color.RED);
                    statusChanged.notify("Failed to apply changes: " + ex.getMessage());
                    throw ex;
                }
            }
        }.start();
    }

    private void enableComponents(boolean enable) {
        this.installed.setEnabled(enable);
        this.available.setEnabled(enable);
        this.upgrades.setEnabled(enable);
        this.apply.setEnabled(enable);
    }

    @Override
    public void componentResized(ComponentEvent e) {
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent evt) {
        this.loadPlugins();
        this.topAndDown.setVisible(!this.manager.allPlugins.isEmpty());
        this.failureLabel.setVisible(this.manager.allPlugins.isEmpty());
        this.pack();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            PluginsList.openInBrowser(e.getURL().toString());
        }
    }
}

