/*
 * Decompiled with CFR 0.152.
 */
package org.jmeterplugins.repository;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.URLDecoder;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.util.JOrphanUtils;
import org.jmeterplugins.repository.Library;
import org.jmeterplugins.repository.Plugin;
import org.jmeterplugins.repository.PluginManager;
import org.jmeterplugins.repository.SafeDeleter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangesMaker {
    private static final Logger log = LoggerFactory.getLogger(ChangesMaker.class);
    private final Map<Plugin, Boolean> allPlugins;

    public ChangesMaker(Map<Plugin, Boolean> allPlugins) {
        this.allPlugins = allPlugins;
    }

    public ProcessBuilder getProcessBuilder(File moveFile, File installFile, File restartFile) throws IOException {
        ArrayList<String> command = new ArrayList<String>();
        command.add(SafeDeleter.getJVM());
        command.add("-classpath");
        command.add(URLDecoder.decode(this.getTempPmgrJAR().getPath(), "UTF-8"));
        command.add(SafeDeleter.class.getCanonicalName());
        command.add("--move-list");
        command.add(moveFile.getAbsolutePath());
        command.add("--install-list");
        command.add(installFile.getAbsolutePath());
        if (restartFile != null) {
            command.add("--restart-command");
            command.add(restartFile.getAbsolutePath());
        }
        log.debug("Command to execute: " + command);
        ProcessBuilder builder = new ProcessBuilder(command);
        File cleanerLog = File.createTempFile("jpgc-cleaner-", ".log");
        builder.redirectError(cleanerLog);
        builder.redirectOutput(cleanerLog);
        return builder;
    }

    private File getTempPmgrJAR() throws IOException {
        String jarPath = URLDecoder.decode(PluginManager.class.getProtectionDomain().getCodeSource().getLocation().getFile(), "UTF-8");
        if (!jarPath.endsWith(".jar")) {
            log.warn("Suspicious JAR path detected: " + jarPath);
        }
        File origJAR = new File(jarPath);
        File tempJAR = File.createTempFile(origJAR.getName(), ".jar");
        tempJAR.delete();
        Files.copy(origJAR.toPath(), tempJAR.toPath(), new CopyOption[0]);
        return tempJAR;
    }

    public File getRestartFile(LinkedList<String> additionalJMeterOptions) throws IOException {
        File file = File.createTempFile("jpgc-restart-", ".list");
        try (PrintWriter out = new PrintWriter(file);){
            out.print(SafeDeleter.getJVM() + "\n");
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            List<String> jvmArgs = runtimeMXBean.getInputArguments();
            for (String arg : jvmArgs) {
                out.print(arg + "\n");
            }
            out.print("-jar\n");
            out.print(this.getJMeterStartCommand(additionalJMeterOptions));
            File file2 = file;
            return file2;
        }
    }

    private String getJMeterStartCommand(LinkedList<String> additionalJMeterOptions) {
        StringBuilder cmd = new StringBuilder(JMeterUtils.getJMeterBinDir() + File.separator + "ApacheJMeter.jar\n");
        if (additionalJMeterOptions != null) {
            for (String option : additionalJMeterOptions) {
                cmd.append(option).append("\n");
            }
        }
        return cmd.toString();
    }

    public File getInstallFile(Set<Plugin> plugins, Set<Library.InstallationInfo> installLibs) throws IOException {
        File file = File.createTempFile("jpgc-installers-", ".list");
        try (PrintWriter out = new PrintWriter(file);){
            for (Plugin plugin : plugins) {
                String cls = plugin.getInstallerClass();
                if (cls == null) continue;
                log.debug("Plugin " + plugin + " has installer: " + cls);
                StringBuilder cp = new StringBuilder();
                Map<String, String> libs = plugin.getLibs(plugin.getCandidateVersion());
                for (String lib : libs.keySet()) {
                    Library.InstallationInfo libInfo = this.getLibForInstallLibs(lib, installLibs);
                    if (libInfo != null) {
                        cp.append(this.generateLibPath(libInfo.getDestinationFileName()));
                        cp.append(File.pathSeparator);
                        continue;
                    }
                    String installedPath = Plugin.getLibInstallPath(lib);
                    if (installedPath != null) {
                        cp.append(this.generateLibPath(installedPath));
                        cp.append(File.pathSeparator);
                        continue;
                    }
                    log.error("Library '" + lib + "' will not be installed!");
                }
                cp.append(plugin.getDestName());
                cp.append('\t');
                cp.append(cls);
                cp.append('\n');
                out.print(cp.toString());
            }
            File file2 = file;
            return file2;
        }
    }

    protected Library.InstallationInfo getLibForInstallLibs(String lib, Set<Library.InstallationInfo> installLibs) {
        for (Library.InstallationInfo info : installLibs) {
            if (!info.getName().equals(lib)) continue;
            return info;
        }
        return null;
    }

    protected String generateLibPath(String libName) throws UnsupportedEncodingException {
        String libPath = new File(JOrphanUtils.class.getProtectionDomain().getCodeSource().getLocation().getFile()).getParent();
        return URLDecoder.decode(libPath, "UTF-8") + File.separator + libName;
    }

    public File getMovementsFile(Set<Plugin> deletes, Set<Plugin> installs, Set<Library.InstallationInfo> installLibs, Set<String> libDeletions) throws IOException {
        File file = File.createTempFile("jpgc-jar-changes", ".list");
        try (PrintWriter out = new PrintWriter(file);){
            if (!deletes.isEmpty() || !libDeletions.isEmpty()) {
                String delTo;
                Object installed;
                File delDir = File.createTempFile("jpgc-deleted-jars-", "");
                delDir.delete();
                delDir.mkdir();
                log.info("Will move deleted JARs to directory " + delDir);
                for (Plugin plugin : deletes) {
                    installed = new File(plugin.getInstalledPath());
                    delTo = delDir + File.separator + ((File)installed).getName();
                    out.print(plugin.getInstalledPath() + "\t" + delTo + "\n");
                }
                for (String lib : libDeletions) {
                    for (Plugin plugin : this.allPlugins.keySet()) {
                        if (!plugin.isInstalled() || !plugin.getInstalledPath().equals(lib)) continue;
                        log.warn("Cannot delete " + lib + " since it is part of plugin " + plugin);
                        libDeletions.remove(lib);
                    }
                }
                for (String lib : libDeletions) {
                    installed = new File(lib);
                    delTo = delDir + File.separator + ((File)installed).getName();
                    out.print(lib + "\t" + delTo + "\n");
                }
            }
            for (Library.InstallationInfo libInfo : installLibs) {
                out.print(libInfo.getTmpPath() + "\t" + this.generateLibPath(libInfo.getDestinationFileName()) + "\n");
            }
            for (Plugin plugin : installs) {
                out.print(plugin.getTempName() + "\t" + plugin.getDestName() + "\n");
            }
            File file2 = file;
            return file2;
        }
    }
}

