/*
 * Decompiled with CFR 0.152.
 */
package com.atlantbh.jmeter.plugins.jsonutils.jsonpathextractor;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import net.minidev.json.JSONArray;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JSONPathExtractor
extends AbstractTestElement
implements PostProcessor {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 1L;
    public static final String JSONPATH = "JSONPATH";
    public static final String VAR = "VAR";
    public static final String DEFAULT = "DEFAULT";
    public static final String SUBJECT = "SUBJECT";
    public static final String SRC_VARNAME = "VARIABLE";
    public static final String SUBJECT_BODY = "BODY";
    public static final String SUBJECT_VARIABLE = "VAR";

    public String getJsonPath() {
        return this.getPropertyAsString(JSONPATH);
    }

    public void setJsonPath(String jsonPath) {
        this.setProperty(JSONPATH, jsonPath);
    }

    public String getVar() {
        return this.getPropertyAsString("VAR");
    }

    public void setVar(String var) {
        this.setProperty("VAR", var);
    }

    public void setDefaultValue(String defaultValue) {
        this.setProperty(DEFAULT, defaultValue);
    }

    public String getDefaultValue() {
        return this.getPropertyAsString(DEFAULT);
    }

    public void setSrcVariableName(String defaultValue) {
        this.setProperty(SRC_VARNAME, defaultValue);
    }

    public String getSrcVariableName() {
        return this.getPropertyAsString(SRC_VARNAME);
    }

    public void setSubject(String defaultValue) {
        this.setProperty(SUBJECT, defaultValue);
    }

    public String getSubject() {
        return this.getPropertyAsString(SUBJECT);
    }

    public void process() {
        JMeterContext context = this.getThreadContext();
        JMeterVariables vars = context.getVariables();
        SampleResult previousResult = context.getPreviousResult();
        String responseData = this.getSubject().equals("VAR") ? vars.get(this.getSrcVariableName()) : previousResult.getResponseDataAsString();
        try {
            Object jsonPathResult = JsonPath.read((String)responseData, (String)this.getJsonPath(), (Predicate[])new Predicate[0]);
            if (jsonPathResult instanceof JSONArray) {
                Object[] arr = ((JSONArray)jsonPathResult).toArray();
                if (arr.length == 0) {
                    throw new PathNotFoundException("Extracted array is empty");
                }
                vars.put(this.getVar(), jsonPathResult.toString());
                vars.put(this.getVar() + "_matchNr", String.valueOf(arr.length));
                int k = 1;
                while (vars.get(this.getVar() + "_" + k) != null) {
                    vars.remove(this.getVar() + "_" + k);
                    ++k;
                }
                for (int n = 0; n < arr.length; ++n) {
                    vars.put(this.getVar() + "_" + (n + 1), String.valueOf(arr[n]));
                }
            } else {
                vars.put(this.getVar(), String.valueOf(jsonPathResult));
            }
        }
        catch (Exception e) {
            log.warn("Extract failed", (Throwable)e);
            vars.put(this.getVar(), this.getDefaultValue());
        }
    }
}

