/*
 * Decompiled with CFR 0.152.
 */
package jsc.kit.wheel.base;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import jsc.kit.wheel.R;

public class WheelMaskView
extends View {
    private Paint paint = new Paint(1);
    private int top = 0;
    private int bottom = 0;
    private int lineColor = -1895825153;

    public WheelMaskView(Context context) {
        super(context);
        this.initAttr(context, null, 0);
    }

    public WheelMaskView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initAttr(context, attrs, 0);
    }

    public WheelMaskView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttr(context, attrs, defStyleAttr);
    }

    public void initAttr(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WheelMaskView, defStyleAttr, 0);
        this.lineColor = a.getColor(R.styleable.WheelMaskView_wheelMaskLineColor, -1895825153);
        a.recycle();
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setStrokeWidth(1.0f);
    }

    public void updateMask(int heightCount, int itemHeight) {
        if (heightCount > 0) {
            int centerIndex = heightCount / 2;
            this.top = centerIndex * itemHeight;
            this.bottom = this.top + itemHeight;
        } else {
            this.top = 0;
            this.bottom = 0;
        }
        this.invalidate();
    }

    public void setLineColor(@ColorInt int lineColor) {
        this.lineColor = lineColor;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        if (this.top > 0 && this.bottom > 0) {
            this.paint.setColor(this.lineColor);
            canvas.drawLine(0.0f, (float)this.top, (float)this.getWidth(), (float)this.top, this.paint);
            canvas.drawLine(0.0f, (float)this.bottom, (float)this.getWidth(), (float)this.bottom, this.paint);
        }
    }
}

