/*
 * Decompiled with CFR 0.152.
 */
package jsc.kit.wheel.base;

import android.content.Context;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import jsc.kit.wheel.base.IWheel;
import jsc.kit.wheel.base.IWheelViewSetting;
import jsc.kit.wheel.base.WheelMaskView;
import jsc.kit.wheel.base.WheelView;

public class WheelItemView
extends FrameLayout
implements IWheelViewSetting {
    private WheelView wheelView;
    private WheelMaskView wheelMaskView;

    public WheelItemView(@NonNull Context context) {
        super(context);
        this.initAttr(context, null, 0);
    }

    public WheelItemView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initAttr(context, attrs, 0);
    }

    public WheelItemView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttr(context, attrs, defStyleAttr);
    }

    private void initAttr(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this.wheelView = new WheelView(context, attrs, defStyleAttr);
        this.wheelMaskView = new WheelMaskView(context, attrs, defStyleAttr);
        this.addView(this.wheelView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
        this.addView(this.wheelMaskView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -2));
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        ViewGroup.LayoutParams params = this.wheelMaskView.getLayoutParams();
        params.height = this.wheelView.getMeasuredHeight();
        this.wheelMaskView.setLayoutParams(params);
        this.wheelMaskView.updateMask(this.wheelView.getShowCount(), this.wheelView.getItemHeight());
    }

    @Override
    public void setTextSize(float textSize) {
        this.wheelView.setTextSize(textSize);
    }

    @Override
    public void setTextColor(@ColorInt int textColor) {
        this.wheelView.setTextColor(textColor);
    }

    @Override
    public void setShowCount(int showCount) {
        this.wheelView.setShowCount(showCount);
    }

    @Override
    public void setTotalOffsetX(int totalOffsetX) {
        this.wheelView.setTotalOffsetX(totalOffsetX);
    }

    @Override
    public void setItemVerticalSpace(int itemVerticalSpace) {
        this.wheelView.setItemVerticalSpace(itemVerticalSpace);
    }

    @Override
    public void setItems(IWheel[] items) {
        this.wheelView.setItems(items);
    }

    @Override
    public int getSelectedIndex() {
        return this.wheelView.getSelectedIndex();
    }

    @Override
    public void setSelectedIndex(int targetIndexPosition) {
        this.setSelectedIndex(targetIndexPosition, true);
    }

    @Override
    public void setSelectedIndex(int targetIndexPosition, boolean withAnimation) {
        this.wheelView.setSelectedIndex(targetIndexPosition, withAnimation);
    }

    @Override
    public void setOnSelectedListener(WheelView.OnSelectedListener onSelectedListener) {
        this.wheelView.setOnSelectedListener(onSelectedListener);
    }

    public void setMaskLineColor(@ColorInt int color) {
        this.wheelMaskView.setLineColor(color);
    }

    @Override
    public boolean isScrolling() {
        return this.wheelView.isScrolling();
    }

    public WheelView getWheelView() {
        return this.wheelView;
    }

    public WheelMaskView getWheelMaskView() {
        return this.wheelMaskView;
    }
}

