/*
 * Decompiled with CFR 0.152.
 */
package jsc.kit.wheel.dialog;

import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;
import java.util.Date;
import jsc.kit.wheel.R;
import jsc.kit.wheel.base.WheelItemView;
import jsc.kit.wheel.base.WheelView;
import jsc.kit.wheel.dialog.DateItem;

public class DateTimeWheelDialog
extends Dialog {
    public static final int SHOW_YEAR = 0;
    public static final int SHOW_YEAR_MONTH = 1;
    public static final int SHOW_YEAR_MONTH_DAY = 2;
    public static final int SHOW_YEAR_MONTH_DAY_HOUR = 3;
    public static final int SHOW_YEAR_MONTH_DAY_HOUR_MINUTE = 4;
    private final String TAG = "DateTimeWheelDialog";
    private final int MIN_MONTH = 1;
    private final int MAX_MONTH = 12;
    private final int MIN_DAY = 1;
    private final int MIN_HOUR = 0;
    private final int MAX_HOUR = 23;
    private final int MIN_MINUTE = 0;
    private final int MAX_MINUTE = 59;
    private TextView tvTitle;
    private TextView tvCancel;
    private TextView tvOK;
    private CharSequence clickTipsWhenIsScrolling = "Scrolling, wait a minute.";
    private WheelItemView yearWheelItemView;
    private WheelItemView monthWheelItemView;
    private WheelItemView dayWheelItemView;
    private WheelItemView hourWheelItemView;
    private WheelItemView minuteWheelItemView;
    private DateItem[] yearItems;
    private DateItem[] monthItems;
    private DateItem[] dayItems;
    private DateItem[] hourItems;
    private DateItem[] minuteItems;
    private Calendar startCalendar = Calendar.getInstance();
    private Calendar endCalendar = Calendar.getInstance();
    private Calendar selectedCalendar = Calendar.getInstance();
    private OnClickCallBack cancelCallBack = null;
    private OnClickCallBack okCallBack = null;
    private boolean isViewInitialized = false;
    private boolean keepLastSelected = false;
    private int showConfig = 4;

    public DateTimeWheelDialog(@NonNull Context context) {
        this(context, R.style.WheelDialog);
    }

    private DateTimeWheelDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        if (this.getWindow() != null) {
            this.getWindow().setGravity(80);
            this.getWindow().setBackgroundDrawable(null);
            this.getWindow().getDecorView().setBackgroundColor(0);
        }
        this.setContentView(R.layout.wheel_dialog_base);
        this.initView();
    }

    private void initView() {
        this.isViewInitialized = true;
        LinearLayout lyPickerContainer = (LinearLayout)this.findViewById(R.id.wheel_id_picker_container);
        this.yearWheelItemView = new WheelItemView(lyPickerContainer.getContext());
        lyPickerContainer.addView((View)this.yearWheelItemView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.monthWheelItemView = new WheelItemView(lyPickerContainer.getContext());
        lyPickerContainer.addView((View)this.monthWheelItemView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.dayWheelItemView = new WheelItemView(lyPickerContainer.getContext());
        lyPickerContainer.addView((View)this.dayWheelItemView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.hourWheelItemView = new WheelItemView(lyPickerContainer.getContext());
        lyPickerContainer.addView((View)this.hourWheelItemView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.minuteWheelItemView = new WheelItemView(lyPickerContainer.getContext());
        lyPickerContainer.addView((View)this.minuteWheelItemView, (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(0, -2, 1.0f));
        this.tvTitle = (TextView)this.findViewById(R.id.wheel_id_title_bar_title);
        this.tvCancel = (TextView)this.findViewById(R.id.wheel_id_title_bar_cancel);
        this.tvOK = (TextView)this.findViewById(R.id.wheel_id_title_bar_ok);
        this.tvCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DateTimeWheelDialog.this.cancelCallBack == null) {
                    DateTimeWheelDialog.this.dismiss();
                    return;
                }
                if (!DateTimeWheelDialog.this.cancelCallBack.callBack(v, DateTimeWheelDialog.this.selectedCalendar.getTime())) {
                    DateTimeWheelDialog.this.dismiss();
                }
            }
        });
        this.tvOK.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (DateTimeWheelDialog.this.okCallBack == null) {
                    DateTimeWheelDialog.this.dismiss();
                    return;
                }
                if (DateTimeWheelDialog.this.isScrolling()) {
                    if (!TextUtils.isEmpty((CharSequence)DateTimeWheelDialog.this.clickTipsWhenIsScrolling)) {
                        Toast.makeText((Context)v.getContext(), (CharSequence)DateTimeWheelDialog.this.clickTipsWhenIsScrolling, (int)0).show();
                    }
                    return;
                }
                if (!DateTimeWheelDialog.this.okCallBack.callBack(v, DateTimeWheelDialog.this.selectedCalendar.getTime())) {
                    DateTimeWheelDialog.this.dismiss();
                }
            }
        });
    }

    public void show() {
        super.show();
        if (this.getWindow() != null) {
            this.getWindow().setLayout(-1, -2);
        }
    }

    public void setClickTipsWhenIsScrolling(CharSequence clickTipsWhenIsScrolling) {
        this.clickTipsWhenIsScrolling = clickTipsWhenIsScrolling;
    }

    public void setTitle(CharSequence title) {
        this.ensureIsViewInitialized();
        this.tvTitle.setText(title);
    }

    public void setOKButton(CharSequence ok, OnClickCallBack okCallBack) {
        this.ensureIsViewInitialized();
        this.tvOK.setText(ok);
        this.okCallBack = okCallBack;
    }

    public void setCancelButton(CharSequence cancel, OnClickCallBack cancelCallBack) {
        this.ensureIsViewInitialized();
        this.tvCancel.setText(cancel);
        this.cancelCallBack = cancelCallBack;
    }

    public void configShowUI(int config) {
        this.configShowUI(config, 0);
    }

    public void configShowUI(int showConfig, int totalOffsetX) {
        this.ensureIsViewInitialized();
        if (totalOffsetX == 0) {
            totalOffsetX = this.getContext().getResources().getDimensionPixelSize(R.dimen.wheel_picker_total_offset_x);
        }
        this.showConfig = showConfig;
        this.yearWheelItemView.setTotalOffsetX(0);
        this.monthWheelItemView.setTotalOffsetX(0);
        this.dayWheelItemView.setTotalOffsetX(0);
        this.hourWheelItemView.setTotalOffsetX(0);
        this.minuteWheelItemView.setTotalOffsetX(0);
        switch (showConfig) {
            case 0: {
                this.yearWheelItemView.setVisibility(0);
                this.monthWheelItemView.setVisibility(8);
                this.dayWheelItemView.setVisibility(8);
                this.hourWheelItemView.setVisibility(8);
                this.minuteWheelItemView.setVisibility(8);
                break;
            }
            case 1: {
                this.yearWheelItemView.setVisibility(0);
                this.monthWheelItemView.setVisibility(0);
                this.dayWheelItemView.setVisibility(8);
                this.hourWheelItemView.setVisibility(8);
                this.minuteWheelItemView.setVisibility(8);
                break;
            }
            case 2: {
                this.yearWheelItemView.setVisibility(0);
                this.monthWheelItemView.setVisibility(0);
                this.dayWheelItemView.setVisibility(0);
                this.hourWheelItemView.setVisibility(8);
                this.minuteWheelItemView.setVisibility(8);
                this.yearWheelItemView.setTotalOffsetX(totalOffsetX);
                this.dayWheelItemView.setTotalOffsetX(-totalOffsetX);
                break;
            }
            case 3: {
                this.yearWheelItemView.setVisibility(0);
                this.monthWheelItemView.setVisibility(0);
                this.dayWheelItemView.setVisibility(0);
                this.hourWheelItemView.setVisibility(0);
                this.minuteWheelItemView.setVisibility(8);
                this.yearWheelItemView.setTotalOffsetX(totalOffsetX);
                this.hourWheelItemView.setTotalOffsetX(-totalOffsetX);
                break;
            }
            case 4: {
                this.yearWheelItemView.setVisibility(0);
                this.monthWheelItemView.setVisibility(0);
                this.dayWheelItemView.setVisibility(0);
                this.hourWheelItemView.setVisibility(0);
                this.minuteWheelItemView.setVisibility(0);
                this.yearWheelItemView.setTotalOffsetX(totalOffsetX);
                this.minuteWheelItemView.setTotalOffsetX(-totalOffsetX);
            }
        }
    }

    public void setDateArea(@NonNull Date startDate, @NonNull Date endDate, boolean keepLastSelected) {
        this.ensureIsViewInitialized();
        if (startDate.after(endDate)) {
            throw new IllegalArgumentException("start date should be before end date");
        }
        this.startCalendar.setTime(startDate);
        this.endCalendar.setTime(endDate);
        this.selectedCalendar.setTimeInMillis(startDate.getTime());
        this.keepLastSelected = keepLastSelected;
        this.initAreaDate();
    }

    public void updateSelectedDate(@NonNull Date selectedDate) {
        this.ensureIsViewInitialized();
        if (selectedDate.before(this.startCalendar.getTime()) || selectedDate.after(this.endCalendar.getTime())) {
            throw new IllegalArgumentException("selected date must be between start date and end date");
        }
        this.selectedCalendar.setTime(selectedDate);
        this.initSelectedDate();
        this.initOnScrollListener();
    }

    private void initAreaDate() {
        int startYear = this.startCalendar.get(1);
        int endYear = this.endCalendar.get(1);
        int startMonth = this.startCalendar.get(2) + 1;
        int startDay = this.startCalendar.get(5);
        int startHour = this.startCalendar.get(11);
        int startMinute = this.startCalendar.get(12);
        this.yearItems = this.updateItems(0, startYear, endYear);
        this.monthItems = this.updateItems(1, startMonth, 12);
        int dayActualMaximum = this.startCalendar.getActualMaximum(5);
        this.dayItems = this.updateItems(2, startDay, dayActualMaximum);
        this.hourItems = this.updateItems(3, startHour, 23);
        this.minuteItems = this.updateItems(4, startMinute, 59);
        this.yearWheelItemView.setItems(this.yearItems);
        this.monthWheelItemView.setItems(this.monthItems);
        this.dayWheelItemView.setItems(this.dayItems);
        this.hourWheelItemView.setItems(this.hourItems);
        this.minuteWheelItemView.setItems(this.minuteItems);
    }

    private void initOnScrollListener() {
        this.yearWheelItemView.setOnSelectedListener(new WheelView.OnSelectedListener(){

            @Override
            public void onSelected(Context context, int selectedIndex) {
                DateTimeWheelDialog.this.selectedCalendar.set(1, DateTimeWheelDialog.this.yearItems[selectedIndex].getValue());
                if (DateTimeWheelDialog.this.showConfig > 0) {
                    DateTimeWheelDialog.this.onYearChanged();
                }
            }
        });
        this.monthWheelItemView.setOnSelectedListener(new WheelView.OnSelectedListener(){

            @Override
            public void onSelected(Context context, int selectedIndex) {
                DateTimeWheelDialog.this.selectedCalendar.set(2, DateTimeWheelDialog.this.monthItems[selectedIndex].getValue() - 1);
                if (DateTimeWheelDialog.this.showConfig > 1) {
                    DateTimeWheelDialog.this.onMonthChanged();
                }
            }
        });
        this.dayWheelItemView.setOnSelectedListener(new WheelView.OnSelectedListener(){

            @Override
            public void onSelected(Context context, int selectedIndex) {
                DateTimeWheelDialog.this.selectedCalendar.set(5, DateTimeWheelDialog.this.dayItems[selectedIndex].getValue());
                if (DateTimeWheelDialog.this.showConfig > 2) {
                    DateTimeWheelDialog.this.onDayChanged();
                }
            }
        });
        this.hourWheelItemView.setOnSelectedListener(new WheelView.OnSelectedListener(){

            @Override
            public void onSelected(Context context, int selectedIndex) {
                DateTimeWheelDialog.this.selectedCalendar.set(11, DateTimeWheelDialog.this.hourItems[selectedIndex].getValue());
                if (DateTimeWheelDialog.this.showConfig > 3) {
                    DateTimeWheelDialog.this.onHourChanged();
                }
            }
        });
        this.minuteWheelItemView.setOnSelectedListener(new WheelView.OnSelectedListener(){

            @Override
            public void onSelected(Context context, int selectedIndex) {
                DateTimeWheelDialog.this.selectedCalendar.set(12, DateTimeWheelDialog.this.minuteItems[selectedIndex].getValue());
            }
        });
    }

    private void initSelectedDate() {
        int year = this.selectedCalendar.get(1);
        int month = this.selectedCalendar.get(2);
        int day = this.selectedCalendar.get(5);
        int hour = this.selectedCalendar.get(11);
        int minute = this.selectedCalendar.get(12);
        int index = this.findSelectedIndexByValue(this.yearItems, year);
        this.yearWheelItemView.setSelectedIndex(index, false);
        index = this.findSelectedIndexByValue(this.monthItems, month);
        this.monthWheelItemView.setSelectedIndex(index, false);
        index = this.findSelectedIndexByValue(this.dayItems, day);
        this.dayWheelItemView.setSelectedIndex(index, false);
        index = this.findSelectedIndexByValue(this.hourItems, hour);
        this.hourWheelItemView.setSelectedIndex(index, false);
        index = this.findSelectedIndexByValue(this.minuteItems, minute);
        this.minuteWheelItemView.setSelectedIndex(index, false);
    }

    private void onYearChanged() {
        int endValue;
        int startValue;
        int startYear = this.startCalendar.get(1);
        int endYear = this.endCalendar.get(1);
        int selectedYear = this.selectedCalendar.get(1);
        int startMonth = this.startCalendar.get(2) + 1;
        int endMonth = this.endCalendar.get(2) + 1;
        int selectedMonth = this.selectedCalendar.get(2) + 1;
        int tempIndex = -1;
        int lastSelectedIndex = -1;
        if (this.isSameValue(selectedYear, startYear)) {
            startValue = startMonth;
            endValue = 12;
        } else if (this.isSameValue(selectedYear, endYear)) {
            startValue = 1;
            endValue = endMonth;
        } else {
            startValue = 1;
            endValue = 12;
        }
        this.monthItems = new DateItem[endValue - startValue + 1];
        for (int i = startValue; i <= endValue; ++i) {
            this.monthItems[++tempIndex] = new DateItem(1, i);
            if (!this.isSameValue(selectedMonth, i)) continue;
            lastSelectedIndex = tempIndex;
        }
        int newSelectedIndex = this.keepLastSelected ? (lastSelectedIndex == -1 ? 0 : lastSelectedIndex) : 0;
        this.monthWheelItemView.setItems(this.monthItems);
        this.monthWheelItemView.setSelectedIndex(newSelectedIndex);
    }

    private void onMonthChanged() {
        int endValue;
        int startValue;
        int startYear = this.startCalendar.get(1);
        int endYear = this.endCalendar.get(1);
        int selectedYear = this.selectedCalendar.get(1);
        int startMonth = this.startCalendar.get(2) + 1;
        int endMonth = this.endCalendar.get(2) + 1;
        int selectedMonth = this.selectedCalendar.get(2) + 1;
        int startDay = this.startCalendar.get(5);
        int endDay = this.endCalendar.get(5);
        int selectedDay = this.selectedCalendar.get(5);
        int tempIndex = -1;
        int lastSelectedIndex = -1;
        if (this.isSameValue(selectedYear, startYear) && this.isSameValue(selectedMonth, startMonth)) {
            startValue = startDay;
            endValue = this.selectedCalendar.getActualMaximum(5);
        } else if (this.isSameValue(selectedYear, endYear) && this.isSameValue(selectedMonth, endMonth)) {
            startValue = 1;
            endValue = endDay;
        } else {
            startValue = 1;
            endValue = this.selectedCalendar.getActualMaximum(5);
        }
        this.dayItems = new DateItem[endValue - startValue + 1];
        for (int i = startValue; i <= endValue; ++i) {
            this.dayItems[++tempIndex] = new DateItem(2, i);
            if (!this.isSameValue(selectedDay, i)) continue;
            lastSelectedIndex = tempIndex;
        }
        int newSelectedIndex = this.keepLastSelected ? (lastSelectedIndex == -1 ? 0 : lastSelectedIndex) : 0;
        this.dayWheelItemView.setItems(this.dayItems);
        this.dayWheelItemView.setSelectedIndex(newSelectedIndex);
    }

    private void onDayChanged() {
        int endValue;
        int startValue;
        int startYear = this.startCalendar.get(1);
        int endYear = this.endCalendar.get(1);
        int selectedYear = this.selectedCalendar.get(1);
        int startMonth = this.startCalendar.get(2) + 1;
        int endMonth = this.endCalendar.get(2) + 1;
        int selectedMonth = this.selectedCalendar.get(2) + 1;
        int startDay = this.startCalendar.get(5);
        int endDay = this.endCalendar.get(5);
        int selectedDay = this.selectedCalendar.get(5);
        int startHour = this.startCalendar.get(11);
        int endHour = this.endCalendar.get(11);
        int selectedHour = this.selectedCalendar.get(11);
        int tempIndex = -1;
        int lastSelectedIndex = -1;
        if (this.isSameValue(selectedYear, startYear) && this.isSameValue(selectedMonth, startMonth) && this.isSameValue(selectedDay, startDay)) {
            startValue = startHour;
            endValue = 23;
        } else if (this.isSameValue(selectedYear, endYear) && this.isSameValue(selectedMonth, endMonth) && this.isSameValue(selectedDay, endDay)) {
            startValue = 0;
            endValue = endHour;
        } else {
            startValue = 0;
            endValue = 23;
        }
        this.hourItems = new DateItem[endValue - startValue + 1];
        for (int i = startValue; i <= endValue; ++i) {
            this.hourItems[++tempIndex] = new DateItem(3, i);
            if (!this.isSameValue(selectedHour, i)) continue;
            lastSelectedIndex = tempIndex;
        }
        int newSelectedIndex = this.keepLastSelected ? (lastSelectedIndex == -1 ? 0 : lastSelectedIndex) : 0;
        this.hourWheelItemView.setItems(this.hourItems);
        this.hourWheelItemView.setSelectedIndex(newSelectedIndex);
    }

    private void onHourChanged() {
        int endValue;
        int startValue;
        int startYear = this.startCalendar.get(1);
        int endYear = this.endCalendar.get(1);
        int selectedYear = this.selectedCalendar.get(1);
        int startMonth = this.startCalendar.get(2) + 1;
        int endMonth = this.endCalendar.get(2) + 1;
        int selectedMonth = this.selectedCalendar.get(2) + 1;
        int startDay = this.startCalendar.get(5);
        int endDay = this.endCalendar.get(5);
        int selectedDay = this.selectedCalendar.get(5);
        int startHour = this.startCalendar.get(11);
        int endHour = this.endCalendar.get(11);
        int selectedHour = this.selectedCalendar.get(11);
        int startMinute = this.startCalendar.get(12);
        int endMinute = this.endCalendar.get(12);
        int selectedMinute = this.selectedCalendar.get(12);
        int tempIndex = -1;
        int lastSelectedIndex = -1;
        if (this.isSameValue(selectedYear, startYear) && this.isSameValue(selectedMonth, startMonth) && this.isSameValue(selectedDay, startDay) && this.isSameValue(selectedHour, startHour)) {
            startValue = startMinute;
            endValue = 59;
        } else if (selectedYear == endYear && selectedMonth == endMonth && selectedDay == endDay && selectedHour == endHour) {
            startValue = 0;
            endValue = endMinute;
        } else {
            startValue = 0;
            endValue = 59;
        }
        this.minuteItems = new DateItem[endValue - startValue + 1];
        for (int i = startValue; i <= endValue; ++i) {
            this.minuteItems[++tempIndex] = new DateItem(4, i);
            if (!this.isSameValue(selectedMinute, i)) continue;
            lastSelectedIndex = tempIndex;
        }
        int newSelectedIndex = this.keepLastSelected ? (lastSelectedIndex == -1 ? 0 : lastSelectedIndex) : 0;
        this.minuteWheelItemView.setItems(this.minuteItems);
        this.minuteWheelItemView.setSelectedIndex(newSelectedIndex);
    }

    private int findSelectedIndexByValue(DateItem[] items, int value) {
        int selectedIndex = 0;
        for (int i = 0; i < items.length; ++i) {
            if (!this.isSameValue(value, items[i].getValue())) continue;
            selectedIndex = i;
            break;
        }
        return selectedIndex;
    }

    private DateItem[] updateItems(int type, int startValue, int endValue) {
        int index = -1;
        DateItem[] items = new DateItem[endValue - startValue + 1];
        for (int i = startValue; i <= endValue; ++i) {
            items[++index] = new DateItem(type, i);
        }
        return items;
    }

    private boolean isScrolling() {
        if (this.showConfig == 0) {
            return this.yearWheelItemView.isScrolling();
        }
        if (this.showConfig == 1) {
            return this.yearWheelItemView.isScrolling() || this.monthWheelItemView.isScrolling();
        }
        if (this.showConfig == 2) {
            return this.yearWheelItemView.isScrolling() || this.monthWheelItemView.isScrolling() || this.dayWheelItemView.isScrolling();
        }
        if (this.showConfig == 3) {
            return this.yearWheelItemView.isScrolling() || this.monthWheelItemView.isScrolling() || this.dayWheelItemView.isScrolling() || this.hourWheelItemView.isScrolling();
        }
        return this.yearWheelItemView.isScrolling() || this.monthWheelItemView.isScrolling() || this.dayWheelItemView.isScrolling() || this.hourWheelItemView.isScrolling() || this.minuteWheelItemView.isScrolling();
    }

    private boolean isSameValue(int value1, int value2) {
        return value1 == value2;
    }

    private void ensureIsViewInitialized() {
        if (!this.isViewInitialized) {
            throw new IllegalStateException("View wasn't initialized, call show() first.");
        }
    }

    public static interface OnClickCallBack {
        public boolean callBack(View var1, @NonNull Date var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ShowConfig {
    }
}

