/*
 * Decompiled with CFR 0.152.
 */
package jsc.kit.wheel.base;

import android.animation.Animator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.Pair;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.widget.OverScroller;
import jsc.kit.wheel.R;
import jsc.kit.wheel.base.IWheel;
import jsc.kit.wheel.base.IWheelViewSetting;
import jsc.kit.wheel.base.WheelItem;

public class WheelView
extends View
implements IWheelViewSetting {
    private final String TAG = "WheelView";
    private TextPaint textPaint = new TextPaint(1);
    private Matrix matrix = new Matrix();
    private float textBaseLine = 0.0f;
    private IWheel[] items = null;
    private int textColor = -16777216;
    private float textSize = 0.0f;
    private int totalOffsetX = 0;
    private float averageShowTextLength = 0.0f;
    private int showCount = 5;
    private int drawCount = this.showCount + 2;
    private Rect[] defaultRectArray = null;
    private Rect[] drawRectArray = null;
    private int offsetY = 0;
    private int totalMoveY = 0;
    private int itemVerticalSpace = 0;
    private int itemHeight = 0;
    private float lastX = 0.0f;
    private float lastY = 0.0f;
    private int selectedIndex = 0;
    private OnSelectedListener onSelectedListener = null;
    private ValueAnimator animator = null;
    private boolean isScrolling = false;
    private boolean isAnimatorCanceledForwardly = false;
    private static final long CLICK_EVENT_INTERNAL_TIME = 2000L;
    private RectF clickRectF = new RectF();
    private boolean isClickEvent = false;
    private long touchDownTimeStamp = 0L;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int scaledTouchSlop;
    private VelocityTracker mVelocityTracker = null;
    private OverScroller mOverScroller;

    public WheelView(Context context) {
        super(context);
        this.initAttr(context, null, 0);
    }

    public WheelView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initAttr(context, attrs, 0);
    }

    public WheelView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initAttr(context, attrs, defStyleAttr);
    }

    private void initAttr(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this.mOverScroller = new OverScroller(context);
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)context);
        this.mMinimumVelocity = viewConfiguration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = viewConfiguration.getScaledMaximumFlingVelocity();
        this.scaledTouchSlop = viewConfiguration.getScaledTouchSlop();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.WheelView, defStyleAttr, 0);
        float defaultTextSize = TypedValue.applyDimension((int)1, (float)14.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.textColor = a.getColor(R.styleable.WheelView_wheelTextColor, -13421773);
        this.textSize = a.getDimension(R.styleable.WheelView_wheelTextSize, defaultTextSize);
        this.showCount = a.getInt(R.styleable.WheelView_wheelShowCount, 5);
        this.totalOffsetX = a.getDimensionPixelSize(R.styleable.WheelView_wheelTotalOffsetX, 0);
        this.itemVerticalSpace = a.getDimensionPixelSize(R.styleable.WheelView_wheelItemVerticalSpace, 32);
        a.recycle();
        this.initConfig();
        if (this.isInEditMode()) {
            IWheel[] items = new IWheel[50];
            for (int i = 0; i < items.length; ++i) {
                items[i] = new WheelItem("\u83dc\u5355\u9009\u9879" + (i < 10 ? "0" + i : String.valueOf(i)));
            }
            this.setItems(items);
        }
    }

    private void initConfig() {
        this.textPaint.setColor(this.textColor);
        this.textPaint.setTextSize(this.textSize);
        Paint.FontMetrics fontMetrics = this.textPaint.getFontMetrics();
        String testText = "\u83dc\u5355\u9009\u9879";
        Rect rect = new Rect();
        this.textPaint.getTextBounds(testText, 0, testText.length(), rect);
        this.itemHeight = rect.height() + this.itemVerticalSpace;
        this.textBaseLine = (float)(-this.itemHeight) / 2.0f + ((float)this.itemHeight - fontMetrics.bottom + fontMetrics.top) / 2.0f - fontMetrics.top;
        if (this.showCount < 5) {
            this.showCount = 5;
        }
        if (this.showCount % 2 == 0) {
            ++this.showCount;
        }
        this.drawCount = this.showCount + 2;
        this.defaultRectArray = new Rect[this.drawCount];
        this.drawRectArray = new Rect[this.drawCount];
        for (int i = 0; i < this.drawCount; ++i) {
            this.defaultRectArray[i] = new Rect();
            this.drawRectArray[i] = new Rect();
        }
    }

    @Override
    public void setTextSize(float textSize) {
        this.textSize = textSize;
        this.initConfig();
        this.requestLayout();
    }

    @Override
    public void setTextColor(@ColorInt int textColor) {
        this.textColor = textColor;
        this.textPaint.setColor(textColor);
        this.invalidate();
    }

    @Override
    public void setShowCount(int showCount) {
        this.showCount = showCount;
        this.initConfig();
        this.requestLayout();
    }

    @Override
    public void setTotalOffsetX(int totalOffsetX) {
        this.totalOffsetX = totalOffsetX;
        this.invalidate();
    }

    @Override
    public void setItemVerticalSpace(int itemVerticalSpace) {
        this.itemVerticalSpace = itemVerticalSpace;
        this.initConfig();
        this.requestLayout();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int top = 0 - this.itemHeight;
        for (int i = 0; i < this.drawCount; ++i) {
            this.defaultRectArray[i].set(0, top, 0, top + this.itemHeight);
            top += this.itemHeight;
        }
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(this.itemHeight * this.showCount), (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.isEmpty()) {
            return super.onTouchEvent(event);
        }
        this.initVelocityTrackerIfNotExists();
        switch (event.getAction()) {
            case 0: {
                this.mVelocityTracker.clear();
                if (this.animator != null && this.animator.isRunning()) {
                    this.isAnimatorCanceledForwardly = true;
                    this.animator.cancel();
                }
                this.lastX = event.getX();
                this.lastY = event.getY();
                this.isClickEvent = true;
                this.touchDownTimeStamp = System.currentTimeMillis();
                break;
            }
            case 2: {
                this.mVelocityTracker.addMovement(event);
                float currentX = event.getX();
                float currentY = event.getY();
                int distance = (int)(currentY - this.lastY);
                if (Math.abs(distance) >= this.scaledTouchSlop) {
                    this.isClickEvent = false;
                    this.touchDownTimeStamp = 0L;
                }
                if (!(currentY >= 0.0f) || !(currentY <= (float)this.getHeight())) break;
                this.lastX = currentX;
                this.lastY = currentY;
                this.totalMoveY += distance;
                this.updateByTotalMoveY();
                break;
            }
            case 1: 
            case 3: {
                if (this.executeClickEvent(event.getX(), event.getY())) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(200, (float)this.mMaximumVelocity);
                float currentVelocity = velocityTracker.getYVelocity();
                this.recycleVelocityTracker();
                int extraDistance = (int)currentVelocity;
                int tempTotalMoveY = this.totalMoveY + extraDistance;
                tempTotalMoveY = Math.max(tempTotalMoveY, -(this.getItemCount() + this.showCount / 2) * this.itemHeight);
                tempTotalMoveY = Math.min(tempTotalMoveY, this.showCount / 2 * this.itemHeight);
                Pair<Integer, Integer> pair = this.calculateSelectedIndex(tempTotalMoveY);
                int tempSelectedIndex = (Integer)pair.first;
                this.runAutoScrollAnimation(null, this.totalMoveY, tempTotalMoveY, 0 - tempSelectedIndex * this.itemHeight);
            }
        }
        return true;
    }

    @Override
    public void setOnSelectedListener(OnSelectedListener onSelectedListener) {
        this.onSelectedListener = onSelectedListener;
    }

    @Override
    public void setItems(IWheel[] items) {
        this.items = items;
        if (!this.isEmpty()) {
            this.averageShowTextLength = this.calAverageShowTextLength();
            this.invalidate();
        }
    }

    public int getItemHeight() {
        return this.itemHeight;
    }

    public int getShowCount() {
        return this.showCount;
    }

    @Override
    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    @Override
    public void setSelectedIndex(int targetIndexPosition) {
        this.setSelectedIndex(targetIndexPosition, true);
    }

    @Override
    public void setSelectedIndex(int targetIndexPosition, boolean withAnimation) {
        if (targetIndexPosition < 0 || targetIndexPosition >= this.getItemCount()) {
            throw new IndexOutOfBoundsException("Out of array bounds.");
        }
        if (withAnimation) {
            this.runAutoScrollAnimation(null, this.totalMoveY, 0 - this.itemHeight * targetIndexPosition);
        } else {
            this.selectedIndex = targetIndexPosition;
            this.offsetY = 0;
            this.invalidate();
            if (this.onSelectedListener != null) {
                this.onSelectedListener.onSelected(this.getContext(), this.selectedIndex);
            }
        }
    }

    @Override
    public boolean isScrolling() {
        return this.isScrolling;
    }

    private float calAverageShowTextLength() {
        float totalLength = 0.0f;
        String showText = null;
        for (IWheel wheel : this.items) {
            showText = wheel.getShowText();
            if (showText == null || showText.length() == 0) continue;
            totalLength += this.textPaint.measureText(showText);
        }
        return totalLength / (float)this.getItemCount();
    }

    private boolean executeClickEvent(float upX, float upY) {
        if (!this.isClickEvent || System.currentTimeMillis() - this.touchDownTimeStamp > 2000L) {
            return false;
        }
        boolean isValidTempSelectedIndex = false;
        int tempSelectedIndex = this.selectedIndex - this.drawCount / 2;
        for (int i = 0; i < this.drawCount; ++i) {
            this.clickRectF.set(this.drawRectArray[i]);
            if (this.clickRectF.contains(upX, upY)) {
                isValidTempSelectedIndex = true;
                break;
            }
            ++tempSelectedIndex;
        }
        if (isValidTempSelectedIndex && tempSelectedIndex >= 0 && tempSelectedIndex < this.getItemCount()) {
            this.setSelectedIndex(tempSelectedIndex);
            return true;
        }
        return false;
    }

    private int getItemCount() {
        return this.items == null ? 0 : this.items.length;
    }

    private IWheel getItemAt(int position) {
        if (this.isEmpty() || position < 0 || position >= this.getItemCount()) {
            return null;
        }
        return this.items[position];
    }

    private boolean isEmpty() {
        return this.getItemCount() == 0;
    }

    private void runAutoScrollAnimation(@Nullable Interpolator interpolator, int ... values) {
        if (values.length < 2) {
            if (this.onSelectedListener != null) {
                this.onSelectedListener.onSelected(this.getContext(), this.selectedIndex);
            }
            return;
        }
        int duration = 0;
        for (int i = 0; i < values.length; ++i) {
            if (i <= 0) continue;
            duration += Math.abs(values[i] - values[i - 1]);
        }
        if (duration == 0) {
            if (this.onSelectedListener != null) {
                this.onSelectedListener.onSelected(this.getContext(), this.selectedIndex);
            }
            return;
        }
        this.createAnimatorIfNecessary();
        if (this.animator.isRunning()) {
            this.isAnimatorCanceledForwardly = true;
            this.animator.cancel();
        }
        this.animator.setInterpolator((TimeInterpolator)(interpolator == null ? new LinearInterpolator() : interpolator));
        this.animator.setIntValues(values);
        this.animator.setDuration((long)this.calSuitableDuration(duration));
        this.animator.start();
    }

    private int calSuitableDuration(int duration) {
        int result;
        for (result = duration; result > 1200; result /= 2) {
        }
        return result;
    }

    private void createAnimatorIfNecessary() {
        if (this.animator == null) {
            this.animator = new ValueAnimator();
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int tempTotalMoveY = (Integer)animation.getAnimatedValue();
                    WheelView.this.setTotalMoveY(tempTotalMoveY);
                }
            });
            this.animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.animator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                    WheelView.this.isScrolling = true;
                }

                public void onAnimationEnd(Animator animation) {
                    WheelView.this.isScrolling = false;
                    if (WheelView.this.isAnimatorCanceledForwardly) {
                        Log.i((String)"WheelView", (String)"onAnimationEnd: Cancel animation forwardly.");
                        WheelView.this.isAnimatorCanceledForwardly = false;
                        return;
                    }
                    if (WheelView.this.onSelectedListener != null) {
                        WheelView.this.onSelectedListener.onSelected(WheelView.this.getContext(), WheelView.this.selectedIndex);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
        }
    }

    public int getTotalMoveY() {
        return this.totalMoveY;
    }

    public void setTotalMoveY(int totalMoveY) {
        this.totalMoveY = totalMoveY;
        this.updateByTotalMoveY();
    }

    private void updateByTotalMoveY() {
        Pair<Integer, Integer> pair = this.calculateSelectedIndex(this.totalMoveY);
        this.selectedIndex = (Integer)pair.first;
        this.offsetY = (Integer)pair.second;
        this.invalidate();
    }

    private Pair<Integer, Integer> calculateSelectedIndex(int totalMoveY) {
        int offsetY;
        int selectedIndex;
        if (totalMoveY > 0) {
            selectedIndex = 0;
            offsetY = totalMoveY;
        } else {
            selectedIndex = -totalMoveY / this.itemHeight;
            if (selectedIndex >= this.getItemCount()) {
                selectedIndex = this.getItemCount() - 1;
            }
            offsetY = totalMoveY + selectedIndex * this.itemHeight;
        }
        return new Pair((Object)selectedIndex, (Object)offsetY);
    }

    protected void onDraw(Canvas canvas) {
        if (this.isEmpty()) {
            return;
        }
        int tempStartSelectedIndex = this.selectedIndex - this.drawCount / 2;
        for (int i = 0; i < this.drawCount; ++i) {
            Rect rect = this.drawRectArray[i];
            rect.set(this.defaultRectArray[i]);
            rect.left = 0;
            rect.right = this.getWidth();
            if (tempStartSelectedIndex >= 0 && tempStartSelectedIndex < this.getItemCount()) {
                this.drawItem(canvas, rect, this.getItemAt(tempStartSelectedIndex), this.offsetY, this.textPaint);
            }
            ++tempStartSelectedIndex;
        }
    }

    private void drawItem(Canvas canvas, Rect rect, IWheel item, int offsetY, TextPaint textPaint) {
        String text;
        String string = text = item == null ? "" : item.getShowText();
        if (text == null || text.trim().length() == 0) {
            return;
        }
        rect.offset(0, offsetY);
        textPaint.setAlpha(this.calAlpha(rect));
        int offsetX = this.totalOffsetX == 0 ? 0 : this.calOffsetX(this.totalOffsetX, rect);
        float w = textPaint.measureText(text);
        float startX = 0.0f;
        if (this.totalOffsetX > 0) {
            float rightAlignPosition = ((float)this.getWidth() + this.averageShowTextLength) / 2.0f;
            startX = rightAlignPosition - w + (float)offsetX;
        } else if (this.totalOffsetX < 0) {
            float leftAlignPosition = ((float)this.getWidth() - this.averageShowTextLength) / 2.0f;
            startX = leftAlignPosition + (float)offsetX;
        } else {
            startX = ((float)this.getWidth() - w) / 2.0f + (float)offsetX;
        }
        float centerY = rect.exactCenterY();
        float baseLine = centerY + this.textBaseLine;
        if (this.totalOffsetX == 0) {
            canvas.drawText(text, startX, baseLine, (Paint)textPaint);
        } else {
            float skewX = this.calSkewX(rect);
            if (this.totalOffsetX > 0) {
                this.matrix.setSkew(-skewX, 0.0f, (startX + w) / 2.0f, centerY);
            } else {
                this.matrix.setSkew(skewX, 0.0f, (startX + w) / 2.0f, centerY);
            }
            canvas.save();
            canvas.setMatrix(this.matrix);
            canvas.drawText(text, startX, baseLine, (Paint)textPaint);
            canvas.restore();
        }
    }

    private int calAlpha(Rect rect) {
        int centerY = this.getHeight() / 2;
        int distance = Math.abs(centerY - rect.centerY());
        int totalDistance = this.itemHeight * (this.showCount / 2);
        float alpha = 0.6f * (float)distance / (float)totalDistance;
        return (int)((1.0f - alpha) * 255.0f);
    }

    private float calSkewX(Rect rect) {
        int centerY = this.getHeight() / 2;
        int distance = centerY - rect.centerY();
        int totalDistance = this.itemHeight * (this.showCount / 2);
        return 0.3f * (float)distance / (float)totalDistance;
    }

    private int calOffsetX(int totalOffsetX, Rect rect) {
        int centerY = this.getHeight() / 2;
        int distance = Math.abs(centerY - rect.centerY());
        int totalDistance = this.itemHeight * (this.showCount / 2);
        return totalOffsetX * distance / totalDistance;
    }

    private void initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private void recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    public static interface OnSelectedListener {
        public void onSelected(Context var1, int var2);
    }
}

