/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.errorprone.slf4j;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Modifier;
import jp.skypencil.errorprone.slf4j.LoggerMatcher;

@BugPattern(name="Slf4jLoggerShouldBeFinal", summary="Logger field should be final", tags={"SLF4J"}, severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class PreferFinalSlf4jLogger
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final long serialVersionUID = -5127926153475887075L;
    private static final Matcher<VariableTree> FINAL = new FinalMatcher();
    private static final Matcher<VariableTree> SLF4J_LOGGER = new LoggerMatcher();

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (Matchers.allOf((Matcher[])new Matcher[]{Matchers.isField(), SLF4J_LOGGER, Matchers.not(FINAL)}).matches((Tree)tree, state)) {
            return Description.builder((Tree)tree, (String)"Slf4jLoggerShouldBeFinal", (String)"https://github.com/KengoTODA/findbugs-slf4j#slf4j_logger_should_be_final", (BugPattern.SeverityLevel)BugPattern.SeverityLevel.WARNING, (String)"Logger field should be final").addFix(SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.FINAL})).build();
        }
        return Description.NO_MATCH;
    }

    private static final class FinalMatcher
    implements Matcher<VariableTree> {
        private static final long serialVersionUID = -8036242499062168842L;

        private FinalMatcher() {
        }

        public boolean matches(VariableTree tree, VisitorState state) {
            return tree.getModifiers().getFlags().contains((Object)Modifier.FINAL);
        }
    }
}

