/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.errorprone.slf4j;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.skypencil.errorprone.slf4j.Consts;

@BugPattern(name="Slf4jPlaceholderMismatch", summary="Count of placeholder does not match with count of parameter", tags={"SLF4J"}, severity=BugPattern.SeverityLevel.ERROR)
public class PlaceholderMismatch
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1442638758364703416L;
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(.?)(\\\\\\\\)*\\{\\}");
    private static final com.google.errorprone.matchers.Matcher<ExpressionTree> IS_MARKER = Matchers.isSubtypeOf((String)"org.slf4j.Marker");
    private static final com.google.errorprone.matchers.Matcher<ExpressionTree> IS_THROWABLE = Matchers.isSubtypeOf((String)"java.lang.Throwable");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol method = ASTHelpers.getSymbol((Tree)tree.getMethodSelect());
        String methodStr = method.toString();
        String methodName = methodStr.substring(0, methodStr.indexOf(40));
        if (!Consts.TARGET_METHOD_NAMES.contains((Object)methodName)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol clazz = method.enclClass();
        if (!"org.slf4j.Logger".equals(((Symbol)clazz).toString())) {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> arguments = tree.getArguments();
        int argumentSize = arguments.size() - 1;
        int formatIndex = 0;
        if (IS_MARKER.matches((Tree)arguments.get(0), state)) {
            --argumentSize;
            formatIndex = 1;
        }
        if (IS_THROWABLE.matches((Tree)arguments.get(arguments.size() - 1), state)) {
            --argumentSize;
        }
        if (argumentSize < 0) {
            return Description.NO_MATCH;
        }
        Object constant = ASTHelpers.constValue((Tree)tree.getArguments().get(formatIndex));
        if (constant == null) {
            return Description.NO_MATCH;
        }
        String format = constant.toString();
        int placeholders = this.countPlaceholder(format);
        if (argumentSize != placeholders) {
            String message = String.format("Count of placeholder (%d) does not match with count of parameter (%d)", placeholders, argumentSize);
            return Description.builder((Tree)tree, (String)"Slf4jPlaceholderMismatch", (String)"https://github.com/KengoTODA/findbugs-slf4j#slf4j_place_holder_mismatch", (BugPattern.SeverityLevel)BugPattern.SeverityLevel.ERROR, (String)message).build();
        }
        return Description.NO_MATCH;
    }

    int countPlaceholder(String format) {
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(format);
        int count = 0;
        while (matcher.find()) {
            if ("\\".equals(matcher.group(1))) continue;
            ++count;
        }
        return count;
    }
}

