/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.errorprone.slf4j;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

@BugPattern(name="Slf4jIllegalPassedClass", summary="LoggerFactory.getLogger(Class) should get the class that defines variable", tags={"SLF4J"}, severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class IllegalPassedClass
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 8309704818374164342L;

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        Symbol.TypeSymbol type = tree.accept(new LoggerInitializerVisitor(), state);
        if (type == null) {
            return Description.NO_MATCH;
        }
        java.util.List<Symbol.ClassSymbol> enclosingClasses = this.listEnclosingClasses(state);
        String message = String.format("LoggerFactory.getLogger(Class) should get one of [%s] but it gets %s", enclosingClasses.stream().map(Symbol.ClassSymbol::className).collect(Collectors.joining(",")), type.getSimpleName());
        Description.Builder builder = Description.builder((Tree)tree, (String)"Slf4jIllegalPassedClass", (String)"https://github.com/KengoTODA/findbugs-slf4j#slf4j_illegal_passed_class", (BugPattern.SeverityLevel)BugPattern.SeverityLevel.WARNING, (String)message);
        for (Symbol.ClassSymbol enclosingSymbol : enclosingClasses) {
            if (!ASTHelpers.isSameType((Type)type.type, (Type)enclosingSymbol.type, (VisitorState)state)) continue;
            return Description.NO_MATCH;
        }
        VariableTree variableTree = (VariableTree)state.findEnclosing(new Class[]{VariableTree.class});
        if (variableTree != null && !variableTree.getModifiers().getFlags().contains((Object)Modifier.STATIC)) {
            builder.addFix((Fix)SuggestedFix.builder().replace((Tree)tree.getArguments().get(0), "getClass()").build());
        }
        for (Symbol.ClassSymbol enclosingSymbol : enclosingClasses) {
            builder.addFix((Fix)SuggestedFix.builder().replace((Tree)tree.getArguments().get(0), enclosingSymbol.getSimpleName() + ".class").build());
        }
        return builder.build();
    }

    private java.util.List<Symbol.ClassSymbol> listEnclosingClasses(VisitorState state) {
        ClassTree enclosing = (ClassTree)state.findEnclosing(new Class[]{ClassTree.class});
        if (enclosing == null) {
            return Collections.emptyList();
        }
        ArrayList<Symbol.ClassSymbol> result = new ArrayList<Symbol.ClassSymbol>();
        Symbol.ClassSymbol enclosingSymbol = ASTHelpers.getSymbol((ClassTree)enclosing);
        while (enclosingSymbol != null) {
            result.add(enclosingSymbol);
            enclosingSymbol = ASTHelpers.enclosingClass((Symbol)enclosingSymbol);
        }
        return result;
    }

    private static final class LoggerInitializerVisitor
    extends TreeScanner<Symbol.TypeSymbol, VisitorState> {
        private final Matcher<ExpressionTree> isGetLogger = MethodMatchers.staticMethod().onClass("org.slf4j.LoggerFactory").named("getLogger").withParameters(new String[]{"java.lang.Class"});

        private LoggerInitializerVisitor() {
        }

        @Override
        public Symbol.TypeSymbol visitMethodInvocation(MethodInvocationTree node, VisitorState state) {
            if (!this.isGetLogger.matches((Tree)node, state)) {
                return null;
            }
            ExpressionTree arg = node.getArguments().get(0);
            Type.ClassType type = (Type.ClassType)ASTHelpers.getType((Tree)arg);
            Type typeParameter = (Type)((List)type.getTypeArguments()).get(0);
            return typeParameter.asElement();
        }
    }
}

