/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.errorprone.slf4j;

import com.google.common.base.CaseFormat;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Optional;
import javax.lang.model.element.Modifier;
import jp.skypencil.errorprone.slf4j.LoggerMatcher;

@BugPattern(name="Slf4jLoggerShouldBeNonStatic", summary="Do not use static Logger field, use non-static one instead", tags={"SLF4J"}, severity=BugPattern.SeverityLevel.SUGGESTION, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class DoNotUseStaticSlf4jLogger
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final long serialVersionUID = 2656759159827947106L;
    private static final Matcher<VariableTree> SLF4J_LOGGER = new LoggerMatcher();

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (Matchers.allOf((Matcher[])new Matcher[]{Matchers.isField(), SLF4J_LOGGER, Matchers.isStatic()}).matches((Tree)tree, state)) {
            SuggestedFix.Builder builder = SuggestedFix.builder();
            SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.STATIC}).ifPresent(arg_0 -> ((SuggestedFix.Builder)builder).merge(arg_0));
            this.suggestRename(tree, state).ifPresent(arg_0 -> ((SuggestedFix.Builder)builder).merge(arg_0));
            return Description.builder((Tree)tree, (String)"Slf4jLoggerShouldBeNonStatic", (String)"https://github.com/KengoTODA/findbugs-slf4j#slf4j_logger_should_be_non_static", (BugPattern.SeverityLevel)BugPattern.SeverityLevel.SUGGESTION, (String)"Do not use static Logger field, use non-static one instead").addFix((Fix)builder.build()).build();
        }
        return Description.NO_MATCH;
    }

    private Optional<SuggestedFix> suggestRename(VariableTree tree, VisitorState state) {
        String formatted;
        String name = tree.getName().toString();
        if (name.equals(formatted = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, name))) {
            return Optional.empty();
        }
        return Optional.of(SuggestedFixes.renameVariable((VariableTree)tree, (String)formatted, (VisitorState)state));
    }
}

