/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.errorprone.slf4j;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import javax.lang.model.element.Modifier;
import jp.skypencil.errorprone.slf4j.LoggerMatcher;

@BugPattern(name="Slf4jLoggerShouldBePrivate", summary="Do not publish Logger field, it should be private", tags={"SLF4J"}, severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class DoNotPublishSlf4jLogger
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final long serialVersionUID = 3718668951312958622L;
    private static final Matcher<VariableTree> PRIVATE = new PrivateMatcher();
    private static final Matcher<VariableTree> SLF4J_LOGGER = new LoggerMatcher();

    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (Matchers.allOf((Matcher[])new Matcher[]{Matchers.isField(), SLF4J_LOGGER, Matchers.not(PRIVATE)}).matches((Tree)tree, state)) {
            SuggestedFix.Builder builder = SuggestedFix.builder();
            SuggestedFixes.addModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PRIVATE}).ifPresent(arg_0 -> ((SuggestedFix.Builder)builder).merge(arg_0));
            SuggestedFixes.removeModifiers((Tree)tree, (VisitorState)state, (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.PROTECTED}).ifPresent(arg_0 -> ((SuggestedFix.Builder)builder).merge(arg_0));
            return Description.builder((Tree)tree, (String)"Slf4jLoggerShouldBePrivate", (String)"https://github.com/KengoTODA/findbugs-slf4j#slf4j_logger_should_be_private", (BugPattern.SeverityLevel)BugPattern.SeverityLevel.WARNING, (String)"Do not publish Logger field, it should be private").addFix((Fix)builder.build()).build();
        }
        return Description.NO_MATCH;
    }

    private static final class PrivateMatcher
    implements Matcher<VariableTree> {
        private static final long serialVersionUID = 4297995943793097263L;

        private PrivateMatcher() {
        }

        public boolean matches(VariableTree tree, VisitorState state) {
            return tree.getModifiers().getFlags().contains((Object)Modifier.PRIVATE);
        }
    }
}

