/*
 * Decompiled with CFR 0.152.
 */
package jp.skypencil.errorprone.slf4j;

import java.util.Iterator;
import java.util.NoSuchElementException;

final class CodepointIterator
implements Iterator<Integer> {
    private CharSequence sequence;
    private int index;

    CodepointIterator(CharSequence sequence) {
        this.sequence = sequence;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.sequence.length();
    }

    @Override
    public Integer next() {
        int result;
        if (this.index >= this.sequence.length()) {
            throw new NoSuchElementException();
        }
        if (Character.isHighSurrogate(this.sequence.charAt(this.index))) {
            result = (this.sequence.charAt(this.index) << 16) + this.sequence.charAt(this.index + 1);
            this.index += 2;
        } else {
            result = this.sequence.charAt(this.index);
            ++this.index;
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

