/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adssearchapi.v5.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import jp.co.yahoo.adssearchapi.v5.model.LabelServiceCountLabeledEntity;

@ApiModel(description="<div lang=\"ja\">LabelServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u64cd\u4f5c\u306e\u5bfe\u8c61\u3068\u3059\u308b\u30e9\u30d9\u30eb\u306e\u60c5\u5831\u304a\u3088\u3073\u30d5\u30a3\u30eb\u30bf\u6761\u4ef6\u3092\u8868\u3057\u307e\u3059\u3002</div> <div lang=\"en\">LabelServiceSelector object describes the information of label to be operated and filter conditions.</div> ")
public class LabelServiceSelector {
    @JsonProperty(value="accountId")
    private Long accountId;
    @JsonProperty(value="countLabeledEntity")
    private LabelServiceCountLabeledEntity countLabeledEntity = null;
    @JsonProperty(value="labelIds")
    @Valid
    private List<Long> labelIds = null;
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;

    public LabelServiceSelector accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u30a2\u30ab\u30a6\u30f3\u30c8ID</div> <div lang=\"en\">Account ID.</div> ")
    @NotNull
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public LabelServiceSelector countLabeledEntity(LabelServiceCountLabeledEntity countLabeledEntity) {
        this.countLabeledEntity = countLabeledEntity;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public LabelServiceCountLabeledEntity getCountLabeledEntity() {
        return this.countLabeledEntity;
    }

    public void setCountLabeledEntity(LabelServiceCountLabeledEntity countLabeledEntity) {
        this.countLabeledEntity = countLabeledEntity;
    }

    public LabelServiceSelector labelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
        return this;
    }

    public LabelServiceSelector addLabelIdsItem(Long labelIdsItem) {
        if (this.labelIds == null) {
            this.labelIds = new ArrayList<Long>();
        }
        this.labelIds.add(labelIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30e9\u30d9\u30ebID<br>\u6307\u5b9a\u3057\u306a\u3044\u5834\u5408\u306f\u3001\u30d5\u30a3\u30eb\u30bf\u6761\u4ef6\u306b \u3059\u3079\u3066\u306e\u30e9\u30d9\u30eb\u304c\u542b\u307e\u308c\u307e\u3059\u3002</div> <div lang=\"en\">Label ID.<br>If not specified, the filter condition includes all labels.</div> ")
    @Size(max=1000)
    public @Size(max=1000) List<Long> getLabelIds() {
        return this.labelIds;
    }

    public void setLabelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
    }

    public LabelServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=2000L)
    public @Min(value=1L) @Max(value=2000L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public LabelServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabelServiceSelector labelServiceSelector = (LabelServiceSelector)o;
        return Objects.equals(this.accountId, labelServiceSelector.accountId) && Objects.equals((Object)this.countLabeledEntity, (Object)labelServiceSelector.countLabeledEntity) && Objects.equals(this.labelIds, labelServiceSelector.labelIds) && Objects.equals(this.numberResults, labelServiceSelector.numberResults) && Objects.equals(this.startIndex, labelServiceSelector.startIndex);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.countLabeledEntity, this.labelIds, this.numberResults, this.startIndex});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LabelServiceSelector {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    countLabeledEntity: ").append(this.toIndentedString((Object)this.countLabeledEntity)).append("\n");
        sb.append("    labelIds: ").append(this.toIndentedString(this.labelIds)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

