/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adssearchapi.v6.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@ApiModel(description="<div lang=\"ja\">AccountSharedServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u691c\u7d22\u6761\u4ef6\uff08\u5b9f\u884c\u30d1\u30e9\u30e1\u30fc\u30bf\uff09\u3092\u4fdd\u6301\u3057\u307e\u3059\u3002</div> <div lang=\"en\">AccountSharedServiceSelector object holds search criteria (exec parameter).</div> ")
public class AccountSharedServiceSelector {
    private static final String EXTRA_INFO = "jp.co.yahoo.api-ads:ads-search-api-lib:0.0.12";
    @JsonProperty(value="accountId")
    private Long accountId;
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="sharedListIds")
    @Valid
    private List<Long> sharedListIds = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;

    @JsonProperty(value="_extraInfo")
    public String get_extraInfo() {
        return EXTRA_INFO;
    }

    public AccountSharedServiceSelector accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u30a2\u30ab\u30a6\u30f3\u30c8ID\u3067\u3059\u3002</div> <div lang=\"en\">Account ID.</div> ")
    @NotNull
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public AccountSharedServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=20L)
    public @Min(value=1L) @Max(value=20L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public AccountSharedServiceSelector sharedListIds(List<Long> sharedListIds) {
        this.sharedListIds = sharedListIds;
        return this;
    }

    public AccountSharedServiceSelector addSharedListIdsItem(Long sharedListIdsItem) {
        if (this.sharedListIds == null) {
            this.sharedListIds = new ArrayList<Long>();
        }
        this.sharedListIds.add(sharedListIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u5bfe\u8c61\u5916\u30ad\u30fc\u30ef\u30fc\u30c9\u30ea\u30b9\u30c8ID\u3067\u3059\u3002</div> <div lang=\"en\">Negative keyword list ID.</div> ")
    @Size(max=20)
    public @Size(max=20) List<Long> getSharedListIds() {
        return this.sharedListIds;
    }

    public void setSharedListIds(List<Long> sharedListIds) {
        this.sharedListIds = sharedListIds;
    }

    public AccountSharedServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountSharedServiceSelector accountSharedServiceSelector = (AccountSharedServiceSelector)o;
        return Objects.equals(this.accountId, accountSharedServiceSelector.accountId) && Objects.equals(this.numberResults, accountSharedServiceSelector.numberResults) && Objects.equals(this.sharedListIds, accountSharedServiceSelector.sharedListIds) && Objects.equals(this.startIndex, accountSharedServiceSelector.startIndex);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.numberResults, this.sharedListIds, this.startIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountSharedServiceSelector {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    sharedListIds: ").append(this.toIndentedString(this.sharedListIds)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

