/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adssearchapi.v6.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import jp.co.yahoo.adssearchapi.v6.model.AdGroupAdServiceAdType;
import jp.co.yahoo.adssearchapi.v6.model.AdGroupAdServiceApprovalStatus;
import jp.co.yahoo.adssearchapi.v6.model.AdGroupAdServiceContainsLabelId;
import jp.co.yahoo.adssearchapi.v6.model.AdGroupAdServiceCreatedDateRange;
import jp.co.yahoo.adssearchapi.v6.model.AdGroupAdServiceUserStatus;

@ApiModel(description="<div lang=\"ja\">AdGroupAdServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u64cd\u4f5c\u306e\u5bfe\u8c61\u3068\u3059\u308b\u5e83\u544a\u304a\u3088\u3073\u30d5\u30a3\u30eb\u30bf\u6761\u4ef6\u3092\u8868\u3057\u307e\u3059\u3002</div> <div lang=\"en\">AdGroupAdServiceSelector object describes the information and filter criteria of the Ads to be operated on.</div> ")
public class AdGroupAdServiceSelector {
    @JsonProperty(value="accountId")
    private Long accountId;
    @JsonProperty(value="adGroupIds")
    @Valid
    private List<Long> adGroupIds = null;
    @JsonProperty(value="adIds")
    @Valid
    private List<Long> adIds = null;
    @JsonProperty(value="adTypes")
    @Valid
    private List<AdGroupAdServiceAdType> adTypes = null;
    @JsonProperty(value="approvalStatuses")
    @Valid
    private List<AdGroupAdServiceApprovalStatus> approvalStatuses = null;
    @JsonProperty(value="campaignIds")
    @Valid
    private List<Long> campaignIds = null;
    @JsonProperty(value="containsLabelId")
    private AdGroupAdServiceContainsLabelId containsLabelId = null;
    @JsonProperty(value="labelIds")
    @Valid
    private List<Long> labelIds = null;
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;
    @JsonProperty(value="userStatuses")
    @Valid
    private List<AdGroupAdServiceUserStatus> userStatuses = null;
    @JsonProperty(value="createdDateRange")
    private AdGroupAdServiceCreatedDateRange createdDateRange = null;

    public AdGroupAdServiceSelector accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u30a2\u30ab\u30a6\u30f3\u30c8ID</div> <div lang=\"en\">Search condition: Account ID.</div> ")
    @NotNull
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public AdGroupAdServiceSelector adGroupIds(List<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
        return this;
    }

    public AdGroupAdServiceSelector addAdGroupIdsItem(Long adGroupIdsItem) {
        if (this.adGroupIds == null) {
            this.adGroupIds = new ArrayList<Long>();
        }
        this.adGroupIds.add(adGroupIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u5e83\u544a\u30b0\u30eb\u30fc\u30d7ID</div> <div lang=\"en\">Search condition: Ad group ID.<br> Ads returned will be from adgroups whose ids are included in this list.</div> ")
    @Size(max=1000)
    public @Size(max=1000) List<Long> getAdGroupIds() {
        return this.adGroupIds;
    }

    public void setAdGroupIds(List<Long> adGroupIds) {
        this.adGroupIds = adGroupIds;
    }

    public AdGroupAdServiceSelector adIds(List<Long> adIds) {
        this.adIds = adIds;
        return this;
    }

    public AdGroupAdServiceSelector addAdIdsItem(Long adIdsItem) {
        if (this.adIds == null) {
            this.adIds = new ArrayList<Long>();
        }
        this.adIds.add(adIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u5e83\u544aID</div> <div lang=\"en\">Search condition: Ad ID.<br> Ads will return from ads whose ids are included in this list.<br> If you omit adIds field, it will return all adIds under the adGroup.</div> ")
    @Size(max=1000)
    public @Size(max=1000) List<Long> getAdIds() {
        return this.adIds;
    }

    public void setAdIds(List<Long> adIds) {
        this.adIds = adIds;
    }

    public AdGroupAdServiceSelector adTypes(List<AdGroupAdServiceAdType> adTypes) {
        this.adTypes = adTypes;
        return this;
    }

    public AdGroupAdServiceSelector addAdTypesItem(AdGroupAdServiceAdType adTypesItem) {
        if (this.adTypes == null) {
            this.adTypes = new ArrayList<AdGroupAdServiceAdType>();
        }
        this.adTypes.add(adTypesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=5)
    public @Valid @Size(max=5) List<AdGroupAdServiceAdType> getAdTypes() {
        return this.adTypes;
    }

    public void setAdTypes(List<AdGroupAdServiceAdType> adTypes) {
        this.adTypes = adTypes;
    }

    public AdGroupAdServiceSelector approvalStatuses(List<AdGroupAdServiceApprovalStatus> approvalStatuses) {
        this.approvalStatuses = approvalStatuses;
        return this;
    }

    public AdGroupAdServiceSelector addApprovalStatusesItem(AdGroupAdServiceApprovalStatus approvalStatusesItem) {
        if (this.approvalStatuses == null) {
            this.approvalStatuses = new ArrayList<AdGroupAdServiceApprovalStatus>();
        }
        this.approvalStatuses.add(approvalStatusesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=5)
    public @Valid @Size(max=5) List<AdGroupAdServiceApprovalStatus> getApprovalStatuses() {
        return this.approvalStatuses;
    }

    public void setApprovalStatuses(List<AdGroupAdServiceApprovalStatus> approvalStatuses) {
        this.approvalStatuses = approvalStatuses;
    }

    public AdGroupAdServiceSelector campaignIds(List<Long> campaignIds) {
        this.campaignIds = campaignIds;
        return this;
    }

    public AdGroupAdServiceSelector addCampaignIdsItem(Long campaignIdsItem) {
        if (this.campaignIds == null) {
            this.campaignIds = new ArrayList<Long>();
        }
        this.campaignIds.add(campaignIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u30ad\u30e3\u30f3\u30da\u30fc\u30f3ID</div> <div lang=\"en\">Search condition: Campaign ID.<br> Ads returned will be from campaigns whose ids are included in this list.<br> An empty list means there are no campaign restrictions when selecting AdGroupAds.<br> * This field must contain distinct elements.<br>* This field cannot contain null elements.</div> ")
    @Size(max=1000)
    public @Size(max=1000) List<Long> getCampaignIds() {
        return this.campaignIds;
    }

    public void setCampaignIds(List<Long> campaignIds) {
        this.campaignIds = campaignIds;
    }

    public AdGroupAdServiceSelector containsLabelId(AdGroupAdServiceContainsLabelId containsLabelId) {
        this.containsLabelId = containsLabelId;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public AdGroupAdServiceContainsLabelId getContainsLabelId() {
        return this.containsLabelId;
    }

    public void setContainsLabelId(AdGroupAdServiceContainsLabelId containsLabelId) {
        this.containsLabelId = containsLabelId;
    }

    public AdGroupAdServiceSelector labelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
        return this;
    }

    public AdGroupAdServiceSelector addLabelIdsItem(Long labelIdsItem) {
        if (this.labelIds == null) {
            this.labelIds = new ArrayList<Long>();
        }
        this.labelIds.add(labelIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u30e9\u30d9\u30ebID</div> <div lang=\"en\">Search condition: Label ID</div> ")
    @Size(max=1000)
    public @Size(max=1000) List<Long> getLabelIds() {
        return this.labelIds;
    }

    public void setLabelIds(List<Long> labelIds) {
        this.labelIds = labelIds;
    }

    public AdGroupAdServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=10000L)
    public @Min(value=1L) @Max(value=10000L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public AdGroupAdServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public AdGroupAdServiceSelector userStatuses(List<AdGroupAdServiceUserStatus> userStatuses) {
        this.userStatuses = userStatuses;
        return this;
    }

    public AdGroupAdServiceSelector addUserStatusesItem(AdGroupAdServiceUserStatus userStatusesItem) {
        if (this.userStatuses == null) {
            this.userStatuses = new ArrayList<AdGroupAdServiceUserStatus>();
        }
        this.userStatuses.add(userStatusesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=2)
    public @Valid @Size(max=2) List<AdGroupAdServiceUserStatus> getUserStatuses() {
        return this.userStatuses;
    }

    public void setUserStatuses(List<AdGroupAdServiceUserStatus> userStatuses) {
        this.userStatuses = userStatuses;
    }

    public AdGroupAdServiceSelector createdDateRange(AdGroupAdServiceCreatedDateRange createdDateRange) {
        this.createdDateRange = createdDateRange;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public AdGroupAdServiceCreatedDateRange getCreatedDateRange() {
        return this.createdDateRange;
    }

    public void setCreatedDateRange(AdGroupAdServiceCreatedDateRange createdDateRange) {
        this.createdDateRange = createdDateRange;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdGroupAdServiceSelector adGroupAdServiceSelector = (AdGroupAdServiceSelector)o;
        return Objects.equals(this.accountId, adGroupAdServiceSelector.accountId) && Objects.equals(this.adGroupIds, adGroupAdServiceSelector.adGroupIds) && Objects.equals(this.adIds, adGroupAdServiceSelector.adIds) && Objects.equals(this.adTypes, adGroupAdServiceSelector.adTypes) && Objects.equals(this.approvalStatuses, adGroupAdServiceSelector.approvalStatuses) && Objects.equals(this.campaignIds, adGroupAdServiceSelector.campaignIds) && Objects.equals((Object)this.containsLabelId, (Object)adGroupAdServiceSelector.containsLabelId) && Objects.equals(this.labelIds, adGroupAdServiceSelector.labelIds) && Objects.equals(this.numberResults, adGroupAdServiceSelector.numberResults) && Objects.equals(this.startIndex, adGroupAdServiceSelector.startIndex) && Objects.equals(this.userStatuses, adGroupAdServiceSelector.userStatuses) && Objects.equals(this.createdDateRange, adGroupAdServiceSelector.createdDateRange);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountId, this.adGroupIds, this.adIds, this.adTypes, this.approvalStatuses, this.campaignIds, this.containsLabelId, this.labelIds, this.numberResults, this.startIndex, this.userStatuses, this.createdDateRange});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AdGroupAdServiceSelector {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    adGroupIds: ").append(this.toIndentedString(this.adGroupIds)).append("\n");
        sb.append("    adIds: ").append(this.toIndentedString(this.adIds)).append("\n");
        sb.append("    adTypes: ").append(this.toIndentedString(this.adTypes)).append("\n");
        sb.append("    approvalStatuses: ").append(this.toIndentedString(this.approvalStatuses)).append("\n");
        sb.append("    campaignIds: ").append(this.toIndentedString(this.campaignIds)).append("\n");
        sb.append("    containsLabelId: ").append(this.toIndentedString((Object)this.containsLabelId)).append("\n");
        sb.append("    labelIds: ").append(this.toIndentedString(this.labelIds)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("    userStatuses: ").append(this.toIndentedString(this.userStatuses)).append("\n");
        sb.append("    createdDateRange: ").append(this.toIndentedString(this.createdDateRange)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

