/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adssearchapi.v4.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import jp.co.yahoo.adssearchapi.v4.model.BiddingStrategyServiceType;

@ApiModel(description="<div lang=\"ja\">BiddingStrategyServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u81ea\u52d5\u5165\u672d\u8a2d\u5b9a\u306e\u691c\u7d22\u6761\u4ef6\u306b\u95a2\u3059\u308b\u60c5\u5831\u3092\u8868\u3057\u307e\u3059\u3002</div> <div lang=\"en\">BiddingStrategyServiceSelector object displays the details of search results of auto bidding setting .</div> ")
public class BiddingStrategyServiceSelector {
    @JsonProperty(value="accountId")
    private Long accountId;
    @JsonProperty(value="biddingStrategyIds")
    @Valid
    private List<Long> biddingStrategyIds = null;
    @JsonProperty(value="biddingStrategyTypes")
    @Valid
    private List<BiddingStrategyServiceType> biddingStrategyTypes = null;
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;

    public BiddingStrategyServiceSelector accountId(Long accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="<div lang=\"ja\">\u30a2\u30ab\u30a6\u30f3\u30c8ID</div> <div lang=\"en\">Account ID.</div> ")
    @NotNull
    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public BiddingStrategyServiceSelector biddingStrategyIds(List<Long> biddingStrategyIds) {
        this.biddingStrategyIds = biddingStrategyIds;
        return this;
    }

    public BiddingStrategyServiceSelector addBiddingStrategyIdsItem(Long biddingStrategyIdsItem) {
        if (this.biddingStrategyIds == null) {
            this.biddingStrategyIds = new ArrayList<Long>();
        }
        this.biddingStrategyIds.add(biddingStrategyIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u81ea\u52d5\u5165\u672dID</div> <div lang=\"en\">Auto bidding ID.</div> ")
    @Size(max=500)
    public @Size(max=500) List<Long> getBiddingStrategyIds() {
        return this.biddingStrategyIds;
    }

    public void setBiddingStrategyIds(List<Long> biddingStrategyIds) {
        this.biddingStrategyIds = biddingStrategyIds;
    }

    public BiddingStrategyServiceSelector biddingStrategyTypes(List<BiddingStrategyServiceType> biddingStrategyTypes) {
        this.biddingStrategyTypes = biddingStrategyTypes;
        return this;
    }

    public BiddingStrategyServiceSelector addBiddingStrategyTypesItem(BiddingStrategyServiceType biddingStrategyTypesItem) {
        if (this.biddingStrategyTypes == null) {
            this.biddingStrategyTypes = new ArrayList<BiddingStrategyServiceType>();
        }
        this.biddingStrategyTypes.add(biddingStrategyTypesItem);
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    @Size(max=3)
    public @Valid @Size(max=3) List<BiddingStrategyServiceType> getBiddingStrategyTypes() {
        return this.biddingStrategyTypes;
    }

    public void setBiddingStrategyTypes(List<BiddingStrategyServiceType> biddingStrategyTypes) {
        this.biddingStrategyTypes = biddingStrategyTypes;
    }

    public BiddingStrategyServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1. Also see Entity Limits per operation.</div> ")
    @Min(value=1L)
    @Max(value=500L)
    public @Min(value=1L) @Max(value=500L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public BiddingStrategyServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BiddingStrategyServiceSelector biddingStrategyServiceSelector = (BiddingStrategyServiceSelector)o;
        return Objects.equals(this.accountId, biddingStrategyServiceSelector.accountId) && Objects.equals(this.biddingStrategyIds, biddingStrategyServiceSelector.biddingStrategyIds) && Objects.equals(this.biddingStrategyTypes, biddingStrategyServiceSelector.biddingStrategyTypes) && Objects.equals(this.numberResults, biddingStrategyServiceSelector.numberResults) && Objects.equals(this.startIndex, biddingStrategyServiceSelector.startIndex);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.biddingStrategyIds, this.biddingStrategyTypes, this.numberResults, this.startIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BiddingStrategyServiceSelector {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    biddingStrategyIds: ").append(this.toIndentedString(this.biddingStrategyIds)).append("\n");
        sb.append("    biddingStrategyTypes: ").append(this.toIndentedString(this.biddingStrategyTypes)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

