/*
 * Decompiled with CFR 0.152.
 */
package jp.co.yahoo.adsdisplayapi.v6.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Size;
import jp.co.yahoo.adsdisplayapi.v6.model.AccountManagementServiceAuthType;
import jp.co.yahoo.adsdisplayapi.v6.model.AccountManagementServiceIncludeTestAccount;
import jp.co.yahoo.adsdisplayapi.v6.model.AccountManagementServicePaymentType;
import jp.co.yahoo.adsdisplayapi.v6.model.AccountManagementServiceStatus;

@ApiModel(description="<div lang=\"ja\">AccountManagementServiceSelector\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u3001\u9078\u629e\u3059\u308b\u30a2\u30ab\u30a6\u30f3\u30c8\u3092\u8868\u3057\u307e\u3059\u3002</div> <div lang=\"en\">AccountManagementServiceSelector object explains which accounts to return.</div> ")
public class AccountManagementServiceSelector {
    private static final String EXTRA_INFO = "jp.co.yahoo.api-ads:ads-display-api-lib:0.0.11";
    @JsonProperty(value="accountIds")
    @Valid
    private List<Long> accountIds = null;
    @JsonProperty(value="accountStatuses")
    @Valid
    private List<AccountManagementServiceStatus> accountStatuses = null;
    @JsonProperty(value="accountTypes")
    @Valid
    private List<AccountManagementServicePaymentType> accountTypes = null;
    @JsonProperty(value="authType")
    private AccountManagementServiceAuthType authType = null;
    @JsonProperty(value="includeTestAccount")
    private AccountManagementServiceIncludeTestAccount includeTestAccount = null;
    @JsonProperty(value="numberResults")
    private Integer numberResults = null;
    @JsonProperty(value="startIndex")
    private Integer startIndex = null;

    @JsonProperty(value="_extraInfo")
    public String get_extraInfo() {
        return EXTRA_INFO;
    }

    public AccountManagementServiceSelector accountIds(List<Long> accountIds) {
        this.accountIds = accountIds;
        return this;
    }

    public AccountManagementServiceSelector addAccountIdsItem(Long accountIdsItem) {
        if (this.accountIds == null) {
            this.accountIds = new ArrayList<Long>();
        }
        this.accountIds.add(accountIdsItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u30a2\u30ab\u30a6\u30f3\u30c8ID</div> <div lang=\"en\">Account IDs.</div> ")
    @Size(max=200)
    public @Size(max=200) List<Long> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(List<Long> accountIds) {
        this.accountIds = accountIds;
    }

    public AccountManagementServiceSelector accountStatuses(List<AccountManagementServiceStatus> accountStatuses) {
        this.accountStatuses = accountStatuses;
        return this;
    }

    public AccountManagementServiceSelector addAccountStatusesItem(AccountManagementServiceStatus accountStatusesItem) {
        if (this.accountStatuses == null) {
            this.accountStatuses = new ArrayList<AccountManagementServiceStatus>();
        }
        this.accountStatuses.add(accountStatusesItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u30a2\u30ab\u30a6\u30f3\u30c8\u30b9\u30c6\u30fc\u30bf\u30b9</div> <div lang=\"en\">Account Statuses.</div> ")
    @Valid
    @Size(max=6)
    public @Valid @Size(max=6) List<AccountManagementServiceStatus> getAccountStatuses() {
        return this.accountStatuses;
    }

    public void setAccountStatuses(List<AccountManagementServiceStatus> accountStatuses) {
        this.accountStatuses = accountStatuses;
    }

    public AccountManagementServiceSelector accountTypes(List<AccountManagementServicePaymentType> accountTypes) {
        this.accountTypes = accountTypes;
        return this;
    }

    public AccountManagementServiceSelector addAccountTypesItem(AccountManagementServicePaymentType accountTypesItem) {
        if (this.accountTypes == null) {
            this.accountTypes = new ArrayList<AccountManagementServicePaymentType>();
        }
        this.accountTypes.add(accountTypesItem);
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u691c\u7d22\u6761\u4ef6\uff1a\u30a2\u30ab\u30a6\u30f3\u30c8\u306e\u6599\u91d1\u652f\u6255\u3044\u7a2e\u5225</div> <div lang=\"en\">Account Payment Types.</div> ")
    @Valid
    @Size(max=2)
    public @Valid @Size(max=2) List<AccountManagementServicePaymentType> getAccountTypes() {
        return this.accountTypes;
    }

    public void setAccountTypes(List<AccountManagementServicePaymentType> accountTypes) {
        this.accountTypes = accountTypes;
    }

    public AccountManagementServiceSelector authType(AccountManagementServiceAuthType authType) {
        this.authType = authType;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public AccountManagementServiceAuthType getAuthType() {
        return this.authType;
    }

    public void setAuthType(AccountManagementServiceAuthType authType) {
        this.authType = authType;
    }

    public AccountManagementServiceSelector includeTestAccount(AccountManagementServiceIncludeTestAccount includeTestAccount) {
        this.includeTestAccount = includeTestAccount;
        return this;
    }

    @ApiModelProperty(value="")
    @Valid
    public AccountManagementServiceIncludeTestAccount getIncludeTestAccount() {
        return this.includeTestAccount;
    }

    public void setIncludeTestAccount(AccountManagementServiceIncludeTestAccount includeTestAccount) {
        this.includeTestAccount = includeTestAccount;
    }

    public AccountManagementServiceSelector numberResults(Integer numberResults) {
        this.numberResults = numberResults;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u6700\u5927\u4ef6\u6570\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Maximum number of results to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    @Max(value=200L)
    public @Min(value=1L) @Max(value=200L) Integer getNumberResults() {
        return this.numberResults;
    }

    public void setNumberResults(Integer numberResults) {
        this.numberResults = numberResults;
    }

    public AccountManagementServiceSelector startIndex(Integer startIndex) {
        this.startIndex = startIndex;
        return this;
    }

    @ApiModelProperty(value="<div lang=\"ja\">\u30da\u30fc\u30b8\u306e\u5148\u982d\u306e\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u3067\u3059\u3002\u3053\u306e\u30d5\u30a3\u30fc\u30eb\u30c9\u306f\u30011\u4ee5\u4e0a\u3092\u6307\u5b9a\u3059\u308b\u5fc5\u8981\u304c\u3042\u308a\u307e\u3059\u3002</div> <div lang=\"en\">Index of the first result to return in this page. This field must be greater than or equal to 1.</div> ")
    @Min(value=1L)
    public @Min(value=1L) Integer getStartIndex() {
        return this.startIndex;
    }

    public void setStartIndex(Integer startIndex) {
        this.startIndex = startIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountManagementServiceSelector accountManagementServiceSelector = (AccountManagementServiceSelector)o;
        return Objects.equals(this.accountIds, accountManagementServiceSelector.accountIds) && Objects.equals(this.accountStatuses, accountManagementServiceSelector.accountStatuses) && Objects.equals(this.accountTypes, accountManagementServiceSelector.accountTypes) && Objects.equals((Object)this.authType, (Object)accountManagementServiceSelector.authType) && Objects.equals((Object)this.includeTestAccount, (Object)accountManagementServiceSelector.includeTestAccount) && Objects.equals(this.numberResults, accountManagementServiceSelector.numberResults) && Objects.equals(this.startIndex, accountManagementServiceSelector.startIndex);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountIds, this.accountStatuses, this.accountTypes, this.authType, this.includeTestAccount, this.numberResults, this.startIndex});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountManagementServiceSelector {\n");
        sb.append("    accountIds: ").append(this.toIndentedString(this.accountIds)).append("\n");
        sb.append("    accountStatuses: ").append(this.toIndentedString(this.accountStatuses)).append("\n");
        sb.append("    accountTypes: ").append(this.toIndentedString(this.accountTypes)).append("\n");
        sb.append("    authType: ").append(this.toIndentedString((Object)this.authType)).append("\n");
        sb.append("    includeTestAccount: ").append(this.toIndentedString((Object)this.includeTestAccount)).append("\n");
        sb.append("    numberResults: ").append(this.toIndentedString(this.numberResults)).append("\n");
        sb.append("    startIndex: ").append(this.toIndentedString(this.startIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

