/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;

public class GPUImagePosterizeFilter
extends GPUImageFilter {
    public static final String POSTERIZE_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\nuniform highp float colorLevels;\n\nvoid main()\n{\n   highp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n   \n   gl_FragColor = floor((textureColor * colorLevels) + vec4(0.5)) / colorLevels;\n}";
    private int mGLUniformColorLevels;
    private int mColorLevels;

    public GPUImagePosterizeFilter() {
        this(10);
    }

    public GPUImagePosterizeFilter(int colorLevels) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", POSTERIZE_FRAGMENT_SHADER);
        this.mColorLevels = colorLevels;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mGLUniformColorLevels = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"colorLevels");
        this.setColorLevels(this.mColorLevels);
    }

    public void setColorLevels(int colorLevels) {
        this.mColorLevels = colorLevels;
        this.setFloat(this.mGLUniformColorLevels, colorLevels);
    }
}

