/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ConfigurationInfo;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.media.ExifInterface;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.opengl.GLSurfaceView;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.view.Display;
import android.view.WindowManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.List;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.GPUImageRenderer;
import jp.co.cyberagent.android.gpuimage.PixelBuffer;
import jp.co.cyberagent.android.gpuimage.Rotation;

public class GPUImage {
    private final Context mContext;
    private final GPUImageRenderer mRenderer;
    private GLSurfaceView mGlSurfaceView;
    private GPUImageFilter mFilter;
    private Bitmap mCurrentBitmap;
    private ScaleType mScaleType = ScaleType.CENTER_CROP;

    public GPUImage(Context context) {
        if (!this.supportsOpenGLES2(context)) {
            throw new IllegalStateException("OpenGL ES 2.0 is not supported on this phone.");
        }
        this.mContext = context;
        this.mFilter = new GPUImageFilter();
        this.mRenderer = new GPUImageRenderer(this.mFilter);
    }

    private boolean supportsOpenGLES2(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        ConfigurationInfo configurationInfo = activityManager.getDeviceConfigurationInfo();
        return configurationInfo.reqGlEsVersion >= 131072;
    }

    public void setGLSurfaceView(GLSurfaceView view) {
        this.mGlSurfaceView = view;
        this.mGlSurfaceView.setEGLContextClientVersion(2);
        this.mGlSurfaceView.setEGLConfigChooser(8, 8, 8, 8, 16, 0);
        this.mGlSurfaceView.getHolder().setFormat(1);
        this.mGlSurfaceView.setRenderer((GLSurfaceView.Renderer)this.mRenderer);
        this.mGlSurfaceView.setRenderMode(0);
        this.mGlSurfaceView.requestRender();
    }

    public void setBackgroundColor(float red, float green, float blue) {
        this.mRenderer.setBackgroundColor(red, green, blue);
    }

    public void requestRender() {
        if (this.mGlSurfaceView != null) {
            this.mGlSurfaceView.requestRender();
        }
    }

    public void setUpCamera(Camera camera) {
        this.setUpCamera(camera, 0, false, false);
    }

    public void setUpCamera(Camera camera, int degrees, boolean flipHorizontal, boolean flipVertical) {
        this.mGlSurfaceView.setRenderMode(1);
        if (Build.VERSION.SDK_INT > 10) {
            this.setUpCameraGingerbread(camera);
        } else {
            camera.setPreviewCallback((Camera.PreviewCallback)this.mRenderer);
            camera.startPreview();
        }
        Rotation rotation = Rotation.NORMAL;
        switch (degrees) {
            case 90: {
                rotation = Rotation.ROTATION_90;
                break;
            }
            case 180: {
                rotation = Rotation.ROTATION_180;
                break;
            }
            case 270: {
                rotation = Rotation.ROTATION_270;
            }
        }
        this.mRenderer.setRotationCamera(rotation, flipHorizontal, flipVertical);
    }

    @TargetApi(value=11)
    private void setUpCameraGingerbread(Camera camera) {
        this.mRenderer.setUpSurfaceTexture(camera);
    }

    public void setFilter(GPUImageFilter filter) {
        this.mFilter = filter;
        this.mRenderer.setFilter(this.mFilter);
        this.requestRender();
    }

    public void setImage(Bitmap bitmap) {
        this.mCurrentBitmap = bitmap;
        this.mRenderer.setImageBitmap(bitmap, false);
        this.requestRender();
    }

    public void setScaleType(ScaleType scaleType) {
        this.mScaleType = scaleType;
        this.mRenderer.setScaleType(scaleType);
        this.mRenderer.deleteImage();
        this.mCurrentBitmap = null;
        this.requestRender();
    }

    public void setRotation(Rotation rotation) {
        this.mRenderer.setRotation(rotation);
    }

    public void setRotation(Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        this.mRenderer.setRotation(rotation, flipHorizontal, flipVertical);
    }

    public void deleteImage() {
        this.mRenderer.deleteImage();
        this.mCurrentBitmap = null;
        this.requestRender();
    }

    public void setImage(Uri uri) {
        new LoadImageUriTask(this, uri).execute(new Void[0]);
    }

    public void setImage(File file) {
        new LoadImageFileTask(this, file).execute(new Void[0]);
    }

    private String getPath(Uri uri) {
        String[] projection = new String[]{"_data"};
        Cursor cursor = this.mContext.getContentResolver().query(uri, projection, null, null, null);
        int pathIndex = cursor.getColumnIndexOrThrow("_data");
        String path = null;
        if (cursor.moveToFirst()) {
            path = cursor.getString(pathIndex);
        }
        cursor.close();
        return path;
    }

    public Bitmap getBitmapWithFilterApplied() {
        return this.getBitmapWithFilterApplied(this.mCurrentBitmap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap getBitmapWithFilterApplied(Bitmap bitmap) {
        if (this.mGlSurfaceView != null) {
            this.mRenderer.deleteImage();
            this.mRenderer.runOnDraw(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    GPUImageFilter gPUImageFilter = GPUImage.this.mFilter;
                    synchronized (gPUImageFilter) {
                        GPUImage.this.mFilter.destroy();
                        GPUImage.this.mFilter.notify();
                    }
                }
            });
            GPUImageFilter gPUImageFilter = this.mFilter;
            synchronized (gPUImageFilter) {
                this.requestRender();
                try {
                    this.mFilter.wait();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        GPUImageRenderer renderer = new GPUImageRenderer(this.mFilter);
        renderer.setRotation(Rotation.NORMAL, this.mRenderer.isFlippedHorizontally(), this.mRenderer.isFlippedVertically());
        renderer.setScaleType(this.mScaleType);
        PixelBuffer buffer = new PixelBuffer(bitmap.getWidth(), bitmap.getHeight());
        buffer.setRenderer(renderer);
        renderer.setImageBitmap(bitmap, false);
        Bitmap result = buffer.getBitmap();
        this.mFilter.destroy();
        renderer.deleteImage();
        buffer.destroy();
        this.mRenderer.setFilter(this.mFilter);
        if (this.mCurrentBitmap != null) {
            this.mRenderer.setImageBitmap(this.mCurrentBitmap, false);
        }
        this.requestRender();
        return result;
    }

    public static void getBitmapForMultipleFilters(Bitmap bitmap, List<GPUImageFilter> filters, ResponseListener<Bitmap> listener) {
        if (filters.isEmpty()) {
            return;
        }
        GPUImageRenderer renderer = new GPUImageRenderer(filters.get(0));
        renderer.setImageBitmap(bitmap, false);
        PixelBuffer buffer = new PixelBuffer(bitmap.getWidth(), bitmap.getHeight());
        buffer.setRenderer(renderer);
        for (GPUImageFilter filter : filters) {
            renderer.setFilter(filter);
            listener.response(buffer.getBitmap());
            filter.destroy();
        }
        renderer.deleteImage();
        buffer.destroy();
    }

    @Deprecated
    public void saveToPictures(String folderName, String fileName, OnPictureSavedListener listener) {
        this.saveToPictures(this.mCurrentBitmap, folderName, fileName, listener);
    }

    @Deprecated
    public void saveToPictures(Bitmap bitmap, String folderName, String fileName, OnPictureSavedListener listener) {
        new SaveTask(bitmap, folderName, fileName, listener).execute(new Void[0]);
    }

    void runOnGLThread(Runnable runnable) {
        this.mRenderer.runOnDrawEnd(runnable);
    }

    private int getOutputWidth() {
        if (this.mRenderer != null && this.mRenderer.getFrameWidth() != 0) {
            return this.mRenderer.getFrameWidth();
        }
        if (this.mCurrentBitmap != null) {
            return this.mCurrentBitmap.getWidth();
        }
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        return display.getWidth();
    }

    private int getOutputHeight() {
        if (this.mRenderer != null && this.mRenderer.getFrameHeight() != 0) {
            return this.mRenderer.getFrameHeight();
        }
        if (this.mCurrentBitmap != null) {
            return this.mCurrentBitmap.getHeight();
        }
        WindowManager windowManager = (WindowManager)this.mContext.getSystemService("window");
        Display display = windowManager.getDefaultDisplay();
        return display.getHeight();
    }

    public static enum ScaleType {
        CENTER_INSIDE,
        CENTER_CROP;

    }

    public static interface ResponseListener<T> {
        public void response(T var1);
    }

    private abstract class LoadImageTask
    extends AsyncTask<Void, Void, Bitmap> {
        private final GPUImage mGPUImage;
        private int mOutputWidth;
        private int mOutputHeight;

        public LoadImageTask(GPUImage gpuImage) {
            this.mGPUImage = gpuImage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Bitmap doInBackground(Void ... params) {
            if (GPUImage.this.mRenderer != null && GPUImage.this.mRenderer.getFrameWidth() == 0) {
                try {
                    Object object = ((GPUImage)GPUImage.this).mRenderer.mSurfaceChangedWaiter;
                    synchronized (object) {
                        ((GPUImage)GPUImage.this).mRenderer.mSurfaceChangedWaiter.wait(3000L);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            this.mOutputWidth = GPUImage.this.getOutputWidth();
            this.mOutputHeight = GPUImage.this.getOutputHeight();
            return this.loadResizedImage();
        }

        protected void onPostExecute(Bitmap bitmap) {
            super.onPostExecute((Object)bitmap);
            this.mGPUImage.deleteImage();
            this.mGPUImage.setImage(bitmap);
        }

        protected abstract Bitmap decode(BitmapFactory.Options var1);

        private Bitmap loadResizedImage() {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            this.decode(options);
            int scale = 1;
            while (this.checkSize(options.outWidth / scale > this.mOutputWidth, options.outHeight / scale > this.mOutputHeight)) {
                ++scale;
            }
            if (--scale < 1) {
                scale = 1;
            }
            options = new BitmapFactory.Options();
            options.inSampleSize = scale;
            options.inPreferredConfig = Bitmap.Config.RGB_565;
            options.inPurgeable = true;
            options.inTempStorage = new byte[32768];
            Bitmap bitmap = this.decode(options);
            if (bitmap == null) {
                return null;
            }
            bitmap = this.rotateImage(bitmap);
            bitmap = this.scaleBitmap(bitmap);
            return bitmap;
        }

        private Bitmap scaleBitmap(Bitmap bitmap) {
            int diffHeight;
            int diffWidth;
            int height;
            int width = bitmap.getWidth();
            int[] newSize = this.getScaleSize(width, height = bitmap.getHeight());
            Bitmap workBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)newSize[0], (int)newSize[1], (boolean)true);
            if (workBitmap != bitmap) {
                bitmap.recycle();
                bitmap = workBitmap;
                System.gc();
            }
            if (GPUImage.this.mScaleType == ScaleType.CENTER_CROP && (workBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)((diffWidth = newSize[0] - this.mOutputWidth) / 2), (int)((diffHeight = newSize[1] - this.mOutputHeight) / 2), (int)(newSize[0] - diffWidth), (int)(newSize[1] - diffHeight))) != bitmap) {
                bitmap.recycle();
                bitmap = workBitmap;
            }
            return bitmap;
        }

        private int[] getScaleSize(int width, int height) {
            float newWidth;
            float newHeight;
            boolean adjustWidth;
            float withRatio = (float)width / (float)this.mOutputWidth;
            float heightRatio = (float)height / (float)this.mOutputHeight;
            boolean bl = GPUImage.this.mScaleType == ScaleType.CENTER_CROP ? withRatio > heightRatio : (adjustWidth = withRatio < heightRatio);
            if (adjustWidth) {
                newHeight = this.mOutputHeight;
                newWidth = newHeight / (float)height * (float)width;
            } else {
                newWidth = this.mOutputWidth;
                newHeight = newWidth / (float)width * (float)height;
            }
            return new int[]{Math.round(newWidth), Math.round(newHeight)};
        }

        private boolean checkSize(boolean widthBigger, boolean heightBigger) {
            if (GPUImage.this.mScaleType == ScaleType.CENTER_CROP) {
                return widthBigger && heightBigger;
            }
            return widthBigger || heightBigger;
        }

        private Bitmap rotateImage(Bitmap bitmap) {
            if (bitmap == null) {
                return null;
            }
            Bitmap rotatedBitmap = bitmap;
            try {
                int orientation = this.getImageOrientation();
                if (orientation != 0) {
                    Matrix matrix = new Matrix();
                    matrix.postRotate((float)orientation);
                    rotatedBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
                    bitmap.recycle();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            return rotatedBitmap;
        }

        protected abstract int getImageOrientation() throws IOException;
    }

    private class LoadImageFileTask
    extends LoadImageTask {
        private final File mImageFile;

        public LoadImageFileTask(GPUImage gpuImage, File file) {
            super(gpuImage);
            this.mImageFile = file;
        }

        @Override
        protected Bitmap decode(BitmapFactory.Options options) {
            return BitmapFactory.decodeFile((String)this.mImageFile.getAbsolutePath(), (BitmapFactory.Options)options);
        }

        @Override
        protected int getImageOrientation() throws IOException {
            ExifInterface exif = new ExifInterface(this.mImageFile.getAbsolutePath());
            int orientation = exif.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 1: {
                    return 0;
                }
                case 6: {
                    return 90;
                }
                case 3: {
                    return 180;
                }
                case 8: {
                    return 270;
                }
            }
            return 0;
        }
    }

    private class LoadImageUriTask
    extends LoadImageTask {
        private final Uri mUri;

        public LoadImageUriTask(GPUImage gpuImage, Uri uri) {
            super(gpuImage);
            this.mUri = uri;
        }

        @Override
        protected Bitmap decode(BitmapFactory.Options options) {
            try {
                InputStream inputStream = this.mUri.getScheme().startsWith("http") || this.mUri.getScheme().startsWith("https") ? new URL(this.mUri.toString()).openStream() : GPUImage.this.mContext.getContentResolver().openInputStream(this.mUri);
                return BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        @Override
        protected int getImageOrientation() throws IOException {
            Cursor cursor = GPUImage.this.mContext.getContentResolver().query(this.mUri, new String[]{"orientation"}, null, null, null);
            if (cursor == null || cursor.getCount() != 1) {
                return 0;
            }
            cursor.moveToFirst();
            int orientation = cursor.getInt(0);
            cursor.close();
            return orientation;
        }
    }

    public static interface OnPictureSavedListener {
        public void onPictureSaved(Uri var1);
    }

    @Deprecated
    private class SaveTask
    extends AsyncTask<Void, Void, Void> {
        private final Bitmap mBitmap;
        private final String mFolderName;
        private final String mFileName;
        private final OnPictureSavedListener mListener;
        private final Handler mHandler;

        public SaveTask(Bitmap bitmap, String folderName, String fileName, OnPictureSavedListener listener) {
            this.mBitmap = bitmap;
            this.mFolderName = folderName;
            this.mFileName = fileName;
            this.mListener = listener;
            this.mHandler = new Handler();
        }

        protected Void doInBackground(Void ... params) {
            Bitmap result = GPUImage.this.getBitmapWithFilterApplied(this.mBitmap);
            this.saveImage(this.mFolderName, this.mFileName, result);
            return null;
        }

        private void saveImage(String folderName, String fileName, Bitmap image) {
            File path = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
            File file = new File(path, folderName + "/" + fileName);
            try {
                file.getParentFile().mkdirs();
                image.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)new FileOutputStream(file));
                MediaScannerConnection.scanFile((Context)GPUImage.this.mContext, (String[])new String[]{file.toString()}, null, (MediaScannerConnection.OnScanCompletedListener)new MediaScannerConnection.OnScanCompletedListener(){

                    public void onScanCompleted(String path, final Uri uri) {
                        if (SaveTask.this.mListener != null) {
                            SaveTask.this.mHandler.post(new Runnable(){

                                @Override
                                public void run() {
                                    SaveTask.this.mListener.onPictureSaved(uri);
                                }
                            });
                        }
                    }
                });
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
    }
}

