/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;

public class GPUImagePixelationFilter
extends GPUImageFilter {
    public static final String PIXELATION_FRAGMENT_SHADER = "precision highp float;\nvarying vec2 textureCoordinate;\nuniform float imageWidthFactor;\nuniform float imageHeightFactor;\nuniform sampler2D inputImageTexture;\nuniform float pixel;\nvoid main()\n{\n  vec2 uv  = textureCoordinate.xy;\n  float dx = pixel * imageWidthFactor;\n  float dy = pixel * imageHeightFactor;\n  vec2 coord = vec2(dx * floor(uv.x / dx), dy * floor(uv.y / dy));\n  vec3 tc = texture2D(inputImageTexture, coord).xyz;\n  gl_FragColor = vec4(tc, 1.0);\n}";
    private int mImageWidthFactorLocation;
    private int mImageHeightFactorLocation;
    private float mPixel = 1.0f;
    private int mPixelLocation;

    public GPUImagePixelationFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", PIXELATION_FRAGMENT_SHADER);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mImageWidthFactorLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"imageWidthFactor");
        this.mImageHeightFactorLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"imageHeightFactor");
        this.mPixelLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"pixel");
        this.setPixel(this.mPixel);
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        this.setFloat(this.mImageWidthFactorLocation, 1.0f / (float)width);
        this.setFloat(this.mImageHeightFactorLocation, 1.0f / (float)height);
    }

    public void setPixel(float pixel) {
        this.mPixel = pixel;
        this.setFloat(this.mPixelLocation, this.mPixel);
    }
}

