/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;

public class GPUImageHazeFilter
extends GPUImageFilter {
    public static final String HAZE_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\n\nuniform lowp float distance;\nuniform highp float slope;\n\nvoid main()\n{\n\t//todo reconsider precision modifiers\t \n\t highp vec4 color = vec4(1.0);//todo reimplement as a parameter\n\n\t highp float  d = textureCoordinate.y * slope  +  distance; \n\n\t highp vec4 c = texture2D(inputImageTexture, textureCoordinate) ; // consider using unpremultiply\n\n\t c = (c - d * color) / (1.0 -d);\n\n\t gl_FragColor = c; //consider using premultiply(c);\n}\n";
    private float mDistance;
    private int mDistanceLocation;
    private float mSlope;
    private int mSlopeLocation;

    public GPUImageHazeFilter() {
        this(0.2f, 0.0f);
    }

    public GPUImageHazeFilter(float distance, float slope) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", HAZE_FRAGMENT_SHADER);
        this.mDistance = distance;
        this.mSlope = slope;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mDistanceLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"distance");
        this.mSlopeLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"slope");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setDistance(this.mDistance);
        this.setSlope(this.mSlope);
    }

    public void setDistance(float distance) {
        this.mDistance = distance;
        this.setFloat(this.mDistanceLocation, distance);
    }

    public void setSlope(float slope) {
        this.mSlope = slope;
        this.setFloat(this.mSlopeLocation, slope);
    }
}

