/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.GPUImageFilter;

public class GPUImageColorMatrixFilter
extends GPUImageFilter {
    public static final String COLOR_MATRIX_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\n\nuniform lowp mat4 colorMatrix;\nuniform lowp float intensity;\n\nvoid main()\n{\n    lowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n    lowp vec4 outputColor = textureColor * colorMatrix;\n    \n    gl_FragColor = (intensity * outputColor) + ((1.0 - intensity) * textureColor);\n}";
    private float mIntensity;
    private float[] mColorMatrix;
    private int mColorMatrixLocation;
    private int mIntensityLocation;

    public GPUImageColorMatrixFilter() {
        this(1.0f, new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
    }

    public GPUImageColorMatrixFilter(float intensity, float[] colorMatrix) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", COLOR_MATRIX_FRAGMENT_SHADER);
        this.mIntensity = intensity;
        this.mColorMatrix = colorMatrix;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mColorMatrixLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"colorMatrix");
        this.mIntensityLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"intensity");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setIntensity(this.mIntensity);
        this.setColorMatrix(this.mColorMatrix);
    }

    public void setIntensity(float intensity) {
        this.mIntensity = intensity;
        this.setFloat(this.mIntensityLocation, intensity);
    }

    public void setColorMatrix(float[] colorMatrix) {
        this.mColorMatrix = colorMatrix;
        this.setUniformMatrix4f(this.mColorMatrixLocation, colorMatrix);
    }
}

