/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage.filter;

import android.graphics.PointF;
import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;

public class GPUImageSwirlFilter
extends GPUImageFilter {
    public static final String SWIRL_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\n\nuniform highp vec2 center;\nuniform highp float radius;\nuniform highp float angle;\n\nvoid main()\n{\nhighp vec2 textureCoordinateToUse = textureCoordinate;\nhighp float dist = distance(center, textureCoordinate);\nif (dist < radius)\n{\ntextureCoordinateToUse -= center;\nhighp float percent = (radius - dist) / radius;\nhighp float theta = percent * percent * angle * 8.0;\nhighp float s = sin(theta);\nhighp float c = cos(theta);\ntextureCoordinateToUse = vec2(dot(textureCoordinateToUse, vec2(c, -s)), dot(textureCoordinateToUse, vec2(s, c)));\ntextureCoordinateToUse += center;\n}\n\ngl_FragColor = texture2D(inputImageTexture, textureCoordinateToUse );\n\n}\n";
    private float angle;
    private int angleLocation;
    private float radius;
    private int radiusLocation;
    private PointF center;
    private int centerLocation;

    public GPUImageSwirlFilter() {
        this(0.5f, 1.0f, new PointF(0.5f, 0.5f));
    }

    public GPUImageSwirlFilter(float radius, float angle, PointF center) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", SWIRL_FRAGMENT_SHADER);
        this.radius = radius;
        this.angle = angle;
        this.center = center;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.angleLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"angle");
        this.radiusLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"radius");
        this.centerLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"center");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setRadius(this.radius);
        this.setAngle(this.angle);
        this.setCenter(this.center);
    }

    public void setRadius(float radius) {
        this.radius = radius;
        this.setFloat(this.radiusLocation, radius);
    }

    public void setAngle(float angle) {
        this.angle = angle;
        this.setFloat(this.angleLocation, angle);
    }

    public void setCenter(PointF center) {
        this.center = center;
        this.setPoint(this.centerLocation, center);
    }
}

