/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage.filter;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageTwoPassFilter;

public class GPUImageTwoPassTextureSamplingFilter
extends GPUImageTwoPassFilter {
    public GPUImageTwoPassTextureSamplingFilter(String firstVertexShader, String firstFragmentShader, String secondVertexShader, String secondFragmentShader) {
        super(firstVertexShader, firstFragmentShader, secondVertexShader, secondFragmentShader);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.initTexelOffsets();
    }

    protected void initTexelOffsets() {
        float ratio = this.getHorizontalTexelOffsetRatio();
        GPUImageFilter filter = this.getFilters().get(0);
        int texelWidthOffsetLocation = GLES20.glGetUniformLocation((int)filter.getProgram(), (String)"texelWidthOffset");
        int texelHeightOffsetLocation = GLES20.glGetUniformLocation((int)filter.getProgram(), (String)"texelHeightOffset");
        filter.setFloat(texelWidthOffsetLocation, ratio / (float)this.getOutputWidth());
        filter.setFloat(texelHeightOffsetLocation, 0.0f);
        ratio = this.getVerticalTexelOffsetRatio();
        filter = this.getFilters().get(1);
        texelWidthOffsetLocation = GLES20.glGetUniformLocation((int)filter.getProgram(), (String)"texelWidthOffset");
        texelHeightOffsetLocation = GLES20.glGetUniformLocation((int)filter.getProgram(), (String)"texelHeightOffset");
        filter.setFloat(texelWidthOffsetLocation, 0.0f);
        filter.setFloat(texelHeightOffsetLocation, ratio / (float)this.getOutputHeight());
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        this.initTexelOffsets();
    }

    public float getVerticalTexelOffsetRatio() {
        return 1.0f;
    }

    public float getHorizontalTexelOffsetRatio() {
        return 1.0f;
    }
}

