/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage.filter;

import android.opengl.GLES20;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;

public class GPUImage3x3TextureSamplingFilter
extends GPUImageFilter {
    public static final String THREE_X_THREE_TEXTURE_SAMPLING_VERTEX_SHADER = "attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n\nuniform highp float texelWidth; \nuniform highp float texelHeight; \n\nvarying vec2 textureCoordinate;\nvarying vec2 leftTextureCoordinate;\nvarying vec2 rightTextureCoordinate;\n\nvarying vec2 topTextureCoordinate;\nvarying vec2 topLeftTextureCoordinate;\nvarying vec2 topRightTextureCoordinate;\n\nvarying vec2 bottomTextureCoordinate;\nvarying vec2 bottomLeftTextureCoordinate;\nvarying vec2 bottomRightTextureCoordinate;\n\nvoid main()\n{\n    gl_Position = position;\n\n    vec2 widthStep = vec2(texelWidth, 0.0);\n    vec2 heightStep = vec2(0.0, texelHeight);\n    vec2 widthHeightStep = vec2(texelWidth, texelHeight);\n    vec2 widthNegativeHeightStep = vec2(texelWidth, -texelHeight);\n\n    textureCoordinate = inputTextureCoordinate.xy;\n    leftTextureCoordinate = inputTextureCoordinate.xy - widthStep;\n    rightTextureCoordinate = inputTextureCoordinate.xy + widthStep;\n\n    topTextureCoordinate = inputTextureCoordinate.xy - heightStep;\n    topLeftTextureCoordinate = inputTextureCoordinate.xy - widthHeightStep;\n    topRightTextureCoordinate = inputTextureCoordinate.xy + widthNegativeHeightStep;\n\n    bottomTextureCoordinate = inputTextureCoordinate.xy + heightStep;\n    bottomLeftTextureCoordinate = inputTextureCoordinate.xy - widthNegativeHeightStep;\n    bottomRightTextureCoordinate = inputTextureCoordinate.xy + widthHeightStep;\n}";
    private int uniformTexelWidthLocation;
    private int uniformTexelHeightLocation;
    private boolean hasOverriddenImageSizeFactor = false;
    private float texelWidth;
    private float texelHeight;
    private float lineSize = 1.0f;

    public GPUImage3x3TextureSamplingFilter() {
        this("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}");
    }

    public GPUImage3x3TextureSamplingFilter(String fragmentShader) {
        super(THREE_X_THREE_TEXTURE_SAMPLING_VERTEX_SHADER, fragmentShader);
    }

    @Override
    public void onInit() {
        super.onInit();
        this.uniformTexelWidthLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"texelWidth");
        this.uniformTexelHeightLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"texelHeight");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        if (this.texelWidth != 0.0f) {
            this.updateTexelValues();
        }
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        if (!this.hasOverriddenImageSizeFactor) {
            this.setLineSize(this.lineSize);
        }
    }

    public void setTexelWidth(float texelWidth) {
        this.hasOverriddenImageSizeFactor = true;
        this.texelWidth = texelWidth;
        this.setFloat(this.uniformTexelWidthLocation, texelWidth);
    }

    public void setTexelHeight(float texelHeight) {
        this.hasOverriddenImageSizeFactor = true;
        this.texelHeight = texelHeight;
        this.setFloat(this.uniformTexelHeightLocation, texelHeight);
    }

    public void setLineSize(float size) {
        this.lineSize = size;
        this.texelWidth = size / (float)this.getOutputWidth();
        this.texelHeight = size / (float)this.getOutputHeight();
        this.updateTexelValues();
    }

    private void updateTexelValues() {
        this.setFloat(this.uniformTexelWidthLocation, this.texelWidth);
        this.setFloat(this.uniformTexelHeightLocation, this.texelHeight);
    }
}

