/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.opengl.GLES20;
import android.opengl.GLSurfaceView;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.LinkedList;
import java.util.Queue;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;
import jp.co.cyberagent.android.gpuimage.GLTextureView;
import jp.co.cyberagent.android.gpuimage.GPUImage;
import jp.co.cyberagent.android.gpuimage.GPUImageNativeLibrary;
import jp.co.cyberagent.android.gpuimage.filter.GPUImageFilter;
import jp.co.cyberagent.android.gpuimage.util.OpenGlUtils;
import jp.co.cyberagent.android.gpuimage.util.Rotation;
import jp.co.cyberagent.android.gpuimage.util.TextureRotationUtil;

public class GPUImageRenderer
implements GLSurfaceView.Renderer,
GLTextureView.Renderer,
Camera.PreviewCallback {
    private static final int NO_IMAGE = -1;
    public static final float[] CUBE = new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f};
    private GPUImageFilter filter;
    public final Object surfaceChangedWaiter = new Object();
    private int glTextureId = -1;
    private SurfaceTexture surfaceTexture = null;
    private final FloatBuffer glCubeBuffer;
    private final FloatBuffer glTextureBuffer;
    private IntBuffer glRgbBuffer;
    private int outputWidth;
    private int outputHeight;
    private int imageWidth;
    private int imageHeight;
    private int addedPadding;
    private final Queue<Runnable> runOnDraw;
    private final Queue<Runnable> runOnDrawEnd;
    private Rotation rotation;
    private boolean flipHorizontal;
    private boolean flipVertical;
    private GPUImage.ScaleType scaleType = GPUImage.ScaleType.CENTER_CROP;
    private float backgroundRed = 0.0f;
    private float backgroundGreen = 0.0f;
    private float backgroundBlue = 0.0f;

    public GPUImageRenderer(GPUImageFilter filter) {
        this.filter = filter;
        this.runOnDraw = new LinkedList<Runnable>();
        this.runOnDrawEnd = new LinkedList<Runnable>();
        this.glCubeBuffer = ByteBuffer.allocateDirect(CUBE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.glCubeBuffer.put(CUBE).position(0);
        this.glTextureBuffer = ByteBuffer.allocateDirect(TextureRotationUtil.TEXTURE_NO_ROTATION.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        this.setRotation(Rotation.NORMAL, false, false);
    }

    @Override
    public void onSurfaceCreated(GL10 unused, EGLConfig config) {
        GLES20.glClearColor((float)this.backgroundRed, (float)this.backgroundGreen, (float)this.backgroundBlue, (float)1.0f);
        GLES20.glDisable((int)2929);
        this.filter.ifNeedInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSurfaceChanged(GL10 gl, int width, int height) {
        this.outputWidth = width;
        this.outputHeight = height;
        GLES20.glViewport((int)0, (int)0, (int)width, (int)height);
        GLES20.glUseProgram((int)this.filter.getProgram());
        this.filter.onOutputSizeChanged(width, height);
        this.adjustImageScaling();
        Object object = this.surfaceChangedWaiter;
        synchronized (object) {
            this.surfaceChangedWaiter.notifyAll();
        }
    }

    @Override
    public void onDrawFrame(GL10 gl) {
        GLES20.glClear((int)16640);
        this.runAll(this.runOnDraw);
        this.filter.onDraw(this.glTextureId, this.glCubeBuffer, this.glTextureBuffer);
        this.runAll(this.runOnDrawEnd);
        if (this.surfaceTexture != null) {
            this.surfaceTexture.updateTexImage();
        }
    }

    public void setBackgroundColor(float red, float green, float blue) {
        this.backgroundRed = red;
        this.backgroundGreen = green;
        this.backgroundBlue = blue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runAll(Queue<Runnable> queue) {
        Queue<Runnable> queue2 = queue;
        synchronized (queue2) {
            while (!queue.isEmpty()) {
                queue.poll().run();
            }
        }
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        Camera.Size previewSize = camera.getParameters().getPreviewSize();
        this.onPreviewFrame(data, previewSize.width, previewSize.height);
    }

    public void onPreviewFrame(final byte[] data, final int width, final int height) {
        if (this.glRgbBuffer == null) {
            this.glRgbBuffer = IntBuffer.allocate(width * height);
        }
        if (this.runOnDraw.isEmpty()) {
            this.runOnDraw(new Runnable(){

                @Override
                public void run() {
                    GPUImageNativeLibrary.YUVtoRBGA(data, width, height, GPUImageRenderer.this.glRgbBuffer.array());
                    GPUImageRenderer.this.glTextureId = OpenGlUtils.loadTexture(GPUImageRenderer.this.glRgbBuffer, width, height, GPUImageRenderer.this.glTextureId);
                    if (GPUImageRenderer.this.imageWidth != width) {
                        GPUImageRenderer.this.imageWidth = width;
                        GPUImageRenderer.this.imageHeight = height;
                        GPUImageRenderer.this.adjustImageScaling();
                    }
                }
            });
        }
    }

    public void setUpSurfaceTexture(final Camera camera) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                int[] textures = new int[1];
                GLES20.glGenTextures((int)1, (int[])textures, (int)0);
                GPUImageRenderer.this.surfaceTexture = new SurfaceTexture(textures[0]);
                try {
                    camera.setPreviewTexture(GPUImageRenderer.this.surfaceTexture);
                    camera.setPreviewCallback((Camera.PreviewCallback)GPUImageRenderer.this);
                    camera.startPreview();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void setFilter(final GPUImageFilter filter) {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GPUImageFilter oldFilter = GPUImageRenderer.this.filter;
                GPUImageRenderer.this.filter = filter;
                if (oldFilter != null) {
                    oldFilter.destroy();
                }
                GPUImageRenderer.this.filter.ifNeedInit();
                GLES20.glUseProgram((int)GPUImageRenderer.this.filter.getProgram());
                GPUImageRenderer.this.filter.onOutputSizeChanged(GPUImageRenderer.this.outputWidth, GPUImageRenderer.this.outputHeight);
            }
        });
    }

    public void deleteImage() {
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                GLES20.glDeleteTextures((int)1, (int[])new int[]{GPUImageRenderer.this.glTextureId}, (int)0);
                GPUImageRenderer.this.glTextureId = -1;
            }
        });
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.setImageBitmap(bitmap, true);
    }

    public void setImageBitmap(final Bitmap bitmap, final boolean recycle) {
        if (bitmap == null) {
            return;
        }
        this.runOnDraw(new Runnable(){

            @Override
            public void run() {
                Bitmap resizedBitmap = null;
                if (bitmap.getWidth() % 2 == 1) {
                    resizedBitmap = Bitmap.createBitmap((int)(bitmap.getWidth() + 1), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                    Canvas can = new Canvas(resizedBitmap);
                    can.drawARGB(0, 0, 0, 0);
                    can.drawBitmap(bitmap, 0.0f, 0.0f, null);
                    GPUImageRenderer.this.addedPadding = 1;
                } else {
                    GPUImageRenderer.this.addedPadding = 0;
                }
                GPUImageRenderer.this.glTextureId = OpenGlUtils.loadTexture(resizedBitmap != null ? resizedBitmap : bitmap, GPUImageRenderer.this.glTextureId, recycle);
                if (resizedBitmap != null) {
                    resizedBitmap.recycle();
                }
                GPUImageRenderer.this.imageWidth = bitmap.getWidth();
                GPUImageRenderer.this.imageHeight = bitmap.getHeight();
                GPUImageRenderer.this.adjustImageScaling();
            }
        });
    }

    public void setScaleType(GPUImage.ScaleType scaleType) {
        this.scaleType = scaleType;
    }

    protected int getFrameWidth() {
        return this.outputWidth;
    }

    protected int getFrameHeight() {
        return this.outputHeight;
    }

    private void adjustImageScaling() {
        float outputWidth = this.outputWidth;
        float outputHeight = this.outputHeight;
        if (this.rotation == Rotation.ROTATION_270 || this.rotation == Rotation.ROTATION_90) {
            outputWidth = this.outputHeight;
            outputHeight = this.outputWidth;
        }
        float ratio1 = outputWidth / (float)this.imageWidth;
        float ratio2 = outputHeight / (float)this.imageHeight;
        float ratioMax = Math.max(ratio1, ratio2);
        int imageWidthNew = Math.round((float)this.imageWidth * ratioMax);
        int imageHeightNew = Math.round((float)this.imageHeight * ratioMax);
        float ratioWidth = (float)imageWidthNew / outputWidth;
        float ratioHeight = (float)imageHeightNew / outputHeight;
        float[] cube = CUBE;
        float[] textureCords = TextureRotationUtil.getRotation(this.rotation, this.flipHorizontal, this.flipVertical);
        if (this.scaleType == GPUImage.ScaleType.CENTER_CROP) {
            float distHorizontal = (1.0f - 1.0f / ratioWidth) / 2.0f;
            float distVertical = (1.0f - 1.0f / ratioHeight) / 2.0f;
            textureCords = new float[]{this.addDistance(textureCords[0], distHorizontal), this.addDistance(textureCords[1], distVertical), this.addDistance(textureCords[2], distHorizontal), this.addDistance(textureCords[3], distVertical), this.addDistance(textureCords[4], distHorizontal), this.addDistance(textureCords[5], distVertical), this.addDistance(textureCords[6], distHorizontal), this.addDistance(textureCords[7], distVertical)};
        } else {
            cube = new float[]{CUBE[0] / ratioHeight, CUBE[1] / ratioWidth, CUBE[2] / ratioHeight, CUBE[3] / ratioWidth, CUBE[4] / ratioHeight, CUBE[5] / ratioWidth, CUBE[6] / ratioHeight, CUBE[7] / ratioWidth};
        }
        this.glCubeBuffer.clear();
        this.glCubeBuffer.put(cube).position(0);
        this.glTextureBuffer.clear();
        this.glTextureBuffer.put(textureCords).position(0);
    }

    private float addDistance(float coordinate, float distance) {
        return coordinate == 0.0f ? distance : 1.0f - distance;
    }

    public void setRotationCamera(Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        this.setRotation(rotation, flipVertical, flipHorizontal);
    }

    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
        this.adjustImageScaling();
    }

    public void setRotation(Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        this.flipHorizontal = flipHorizontal;
        this.flipVertical = flipVertical;
        this.setRotation(rotation);
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    public boolean isFlippedHorizontally() {
        return this.flipHorizontal;
    }

    public boolean isFlippedVertically() {
        return this.flipVertical;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDraw(Runnable runnable) {
        Queue<Runnable> queue = this.runOnDraw;
        synchronized (queue) {
            this.runOnDraw.add(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runOnDrawEnd(Runnable runnable) {
        Queue<Runnable> queue = this.runOnDrawEnd;
        synchronized (queue) {
            this.runOnDrawEnd.add(runnable);
        }
    }
}

