/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.android.gpuimage.util;

import jp.co.cyberagent.android.gpuimage.util.Rotation;

public class TextureRotationUtil {
    public static final float[] TEXTURE_NO_ROTATION = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    public static final float[] TEXTURE_ROTATED_90 = new float[]{1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    public static final float[] TEXTURE_ROTATED_180 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    public static final float[] TEXTURE_ROTATED_270 = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};

    private TextureRotationUtil() {
    }

    public static float[] getRotation(Rotation rotation, boolean flipHorizontal, boolean flipVertical) {
        float[] rotatedTex;
        switch (rotation) {
            case ROTATION_90: {
                rotatedTex = TEXTURE_ROTATED_90;
                break;
            }
            case ROTATION_180: {
                rotatedTex = TEXTURE_ROTATED_180;
                break;
            }
            case ROTATION_270: {
                rotatedTex = TEXTURE_ROTATED_270;
                break;
            }
            default: {
                rotatedTex = TEXTURE_NO_ROTATION;
            }
        }
        if (flipHorizontal) {
            rotatedTex = new float[]{TextureRotationUtil.flip(rotatedTex[0]), rotatedTex[1], TextureRotationUtil.flip(rotatedTex[2]), rotatedTex[3], TextureRotationUtil.flip(rotatedTex[4]), rotatedTex[5], TextureRotationUtil.flip(rotatedTex[6]), rotatedTex[7]};
        }
        if (flipVertical) {
            rotatedTex = new float[]{rotatedTex[0], TextureRotationUtil.flip(rotatedTex[1]), rotatedTex[2], TextureRotationUtil.flip(rotatedTex[3]), rotatedTex[4], TextureRotationUtil.flip(rotatedTex[5]), rotatedTex[6], TextureRotationUtil.flip(rotatedTex[7])};
        }
        return rotatedTex;
    }

    private static float flip(float i) {
        if (i == 0.0f) {
            return 1.0f;
        }
        return 0.0f;
    }
}

